/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexOnViewSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySqlServer;
import oracle.dbtools.crest.util.logging.Logger;

public class SHExtendedPropertiesSqlServer
extends DDLStatementHandlerSqlServer {
    private static final Logger LOGGER = new Logger(SHExtendedPropertiesSqlServer.class);
    private String propertyName;
    private String propertyValue;
    private String object;
    private String objectName;
    private Table table;
    private TableProxySqlServer tableProxy;
    private TableView view;
    private TableViewProxySqlServer viewProxy;
    private ColumnProxySqlServer columnProxy;
    private IndexProxySqlServer indexProxy;
    private IndexOnViewSqlServer indexOnView;
    private String object2;
    private String objectName2;

    public SHExtendedPropertiesSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHExtendedPropertiesSqlServer.clearCR(line);
        if (Token.startsWithString(statement, "EXEC sp_addextendedproperty")) {
            try {
                this.createExtProperties(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(SHExtendedPropertiesSqlServer.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void createExtProperties(String statement) {
        this.statement = statement.replaceAll("\"", "");
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServer stoDesign = (StorageDesignSqlServer)this.design.getStorageDesign(site);
        if (stoDesign != null) {
            String exp = Token.getStringAfter(this.statement, "sp_addextendedproperty").trim();
            StringTokenizer st = new StringTokenizer(exp, ",");
            String first = st.nextToken().trim();
            if (first.equalsIgnoreCase("'MS_Description'")) {
                this.initComments(st, stoDesign);
            } else if (st.countTokens() == 6) {
                this.initWithoutColumn(st, stoDesign);
            } else if (st.countTokens() == 8) {
                this.initWithColumn(st, stoDesign);
            }
        }
    }

    private void initComments(StringTokenizer tokenizer, StorageDesignSqlServer stoDesign) {
        block33: {
            String comment;
            block58: {
                block64: {
                    block65: {
                        Index index;
                        block62: {
                            block63: {
                                block59: {
                                    block60: {
                                        block61: {
                                            int count;
                                            block41: {
                                                block57: {
                                                    block49: {
                                                        block55: {
                                                            block56: {
                                                                Index index2;
                                                                block53: {
                                                                    block54: {
                                                                        block50: {
                                                                            block51: {
                                                                                block52: {
                                                                                    block42: {
                                                                                        RuleSqlServer rule;
                                                                                        block48: {
                                                                                            block47: {
                                                                                                block45: {
                                                                                                    block46: {
                                                                                                        block43: {
                                                                                                            block44: {
                                                                                                                block34: {
                                                                                                                    RuleSqlServer rule2;
                                                                                                                    block40: {
                                                                                                                        block39: {
                                                                                                                            block37: {
                                                                                                                                block38: {
                                                                                                                                    block35: {
                                                                                                                                        block36: {
                                                                                                                                            count = tokenizer.countTokens() + 1;
                                                                                                                                            comment = tokenizer.nextToken().trim();
                                                                                                                                            comment = Token.cutN(comment);
                                                                                                                                            comment = Token.getValBetweenQuotationMarks(comment);
                                                                                                                                            if (count != 4) break block34;
                                                                                                                                            this.object = tokenizer.nextToken().trim();
                                                                                                                                            this.object = Token.cutN(this.object);
                                                                                                                                            this.objectName = tokenizer.nextToken().trim();
                                                                                                                                            this.objectName = Token.cutN(this.objectName);
                                                                                                                                            this.objectName = Token.getValBetweenQuotationMarks(this.objectName);
                                                                                                                                            if (!this.object.equalsIgnoreCase("'table'")) break block35;
                                                                                                                                            this.tableProxy = ((TableProxySetSqlServer)stoDesign.getTableProxySet()).getByName(this.objectName);
                                                                                                                                            if (this.tableProxy == null) break block36;
                                                                                                                                            this.tableProxy.setCommentInRDBMS(comment);
                                                                                                                                            this.tableProxy.setCommentInRDBMSChanged(true);
                                                                                                                                            break block33;
                                                                                                                                        }
                                                                                                                                        this.table = (Table)this.design.getDesign().getRelationalDesign().getTableSet().getByName(this.objectName);
                                                                                                                                        if (this.table == null) break block33;
                                                                                                                                        this.table.setCommentInRDBMS(comment);
                                                                                                                                        break block33;
                                                                                                                                    }
                                                                                                                                    if (!this.object.equalsIgnoreCase("'view'")) break block37;
                                                                                                                                    this.viewProxy = ((TableViewProxySetSqlServer)stoDesign.getTableViewProxySet()).getByName(this.objectName);
                                                                                                                                    if (this.viewProxy == null) break block38;
                                                                                                                                    this.viewProxy.setCommentInRDBMS(comment);
                                                                                                                                    this.viewProxy.setCommentInRDBMSChanged(true);
                                                                                                                                    break block33;
                                                                                                                                }
                                                                                                                                this.view = (TableView)this.design.getDesign().getRelationalDesign().getTableViewSet().getByName(this.objectName);
                                                                                                                                if (this.view == null) break block33;
                                                                                                                                this.view.setCommentInRDBMS(comment);
                                                                                                                                break block33;
                                                                                                                            }
                                                                                                                            if (!this.object.equalsIgnoreCase("'procedure'")) break block39;
                                                                                                                            StoredProcedureSqlServer procedure = (StoredProcedureSqlServer)stoDesign.getStoredProcedureSet().getByName(this.objectName);
                                                                                                                            if (procedure == null) break block33;
                                                                                                                            procedure.setCommentInRDBMS(comment);
                                                                                                                            break block33;
                                                                                                                        }
                                                                                                                        if (!this.object.equalsIgnoreCase("'default'")) break block40;
                                                                                                                        DefaultSqlServer def = (DefaultSqlServer)stoDesign.getDefaultSet().getByName(this.objectName);
                                                                                                                        if (def == null) break block33;
                                                                                                                        def.setCommentInRDBMS(comment);
                                                                                                                        break block33;
                                                                                                                    }
                                                                                                                    if (!this.object.equalsIgnoreCase("'rule'") || (rule2 = (RuleSqlServer)stoDesign.getRuleSet().getByName(this.objectName)) == null) break block33;
                                                                                                                    rule2.setCommentInRDBMS(comment);
                                                                                                                    break block33;
                                                                                                                }
                                                                                                                if (count != 6) break block41;
                                                                                                                this.object = tokenizer.nextToken().trim();
                                                                                                                this.object = Token.cutN(this.object);
                                                                                                                this.objectName = tokenizer.nextToken().trim();
                                                                                                                this.objectName = Token.cutN(this.objectName);
                                                                                                                this.objectName = Token.getValBetweenQuotationMarks(this.objectName);
                                                                                                                this.object2 = tokenizer.nextToken().trim();
                                                                                                                this.object2 = Token.cutN(this.object2);
                                                                                                                this.objectName2 = tokenizer.nextToken().trim();
                                                                                                                this.objectName2 = Token.cutN(this.objectName2);
                                                                                                                this.objectName2 = Token.getValBetweenQuotationMarks(this.objectName2);
                                                                                                                if (!this.object.equalsIgnoreCase("'user'") && !this.object.equalsIgnoreCase("'schema'")) break block42;
                                                                                                                if (!this.object2.equalsIgnoreCase("'table'")) break block43;
                                                                                                                this.tableProxy = ((TableProxySetSqlServer)stoDesign.getTableProxySet()).getByName(this.objectName2);
                                                                                                                if (this.tableProxy == null) break block44;
                                                                                                                this.tableProxy.setCommentInRDBMS(comment);
                                                                                                                this.tableProxy.setCommentInRDBMSChanged(true);
                                                                                                                break block33;
                                                                                                            }
                                                                                                            this.table = (Table)this.design.getDesign().getRelationalDesign().getTableSet().getByName(this.objectName2);
                                                                                                            if (this.table == null) break block33;
                                                                                                            this.table.setCommentInRDBMS(comment);
                                                                                                            break block33;
                                                                                                        }
                                                                                                        if (!this.object2.equalsIgnoreCase("'view'")) break block45;
                                                                                                        this.viewProxy = ((TableViewProxySetSqlServer)stoDesign.getTableViewProxySet()).getByName(this.objectName2);
                                                                                                        if (this.viewProxy == null) break block46;
                                                                                                        this.viewProxy.setCommentInRDBMS(comment);
                                                                                                        this.viewProxy.setCommentInRDBMSChanged(true);
                                                                                                        break block33;
                                                                                                    }
                                                                                                    this.view = (TableView)this.design.getDesign().getRelationalDesign().getTableViewSet().getByName(this.objectName2);
                                                                                                    if (this.view == null) break block33;
                                                                                                    this.view.setCommentInRDBMS(comment);
                                                                                                    break block33;
                                                                                                }
                                                                                                if (!this.object2.equalsIgnoreCase("'procedure'")) break block47;
                                                                                                StoredProcedureSqlServer procedure = (StoredProcedureSqlServer)stoDesign.getStoredProcedureSet().getByName(this.objectName2);
                                                                                                if (procedure == null) break block33;
                                                                                                procedure.setCommentInRDBMS(comment);
                                                                                                break block33;
                                                                                            }
                                                                                            if (!this.object2.equalsIgnoreCase("'default'")) break block48;
                                                                                            DefaultSqlServer def = (DefaultSqlServer)stoDesign.getDefaultSet().getByName(this.getNameOnly(this.objectName2));
                                                                                            if (def == null) break block33;
                                                                                            def.setCommentInRDBMS(comment);
                                                                                            break block33;
                                                                                        }
                                                                                        if (!this.object2.equalsIgnoreCase("'rule'") || (rule = (RuleSqlServer)stoDesign.getRuleSet().getByName(this.objectName2)) == null) break block33;
                                                                                        rule.setCommentInRDBMS(comment);
                                                                                        break block33;
                                                                                    }
                                                                                    if (!this.object.equalsIgnoreCase("'table'")) break block49;
                                                                                    this.tableProxy = ((TableProxySetSqlServer)stoDesign.getTableProxySet()).getByName(this.objectName);
                                                                                    this.table = (Table)this.design.getDesign().getRelationalDesign().getTableSet().getByName(this.objectName);
                                                                                    if (!this.object2.equalsIgnoreCase("'column'")) break block50;
                                                                                    if (this.tableProxy == null) break block51;
                                                                                    ColumnProxy col = this.tableProxy.getColumnProxyByName(this.objectName2);
                                                                                    if (col == null) break block52;
                                                                                    col.setCommentInRDBMS(comment);
                                                                                    col.setCommentInRDBMSChanged(true);
                                                                                    break block33;
                                                                                }
                                                                                if (this.table == null) break block33;
                                                                                ContainedObject[] cols = this.table.getElements();
                                                                                for (int i = 0; i < cols.length; ++i) {
                                                                                    if (!cols[i].getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                                    cols[i].setCommentInRDBMS(comment);
                                                                                    break block33;
                                                                                }
                                                                                break block33;
                                                                            }
                                                                            if (this.table == null) break block33;
                                                                            ContainedObject[] cols = this.table.getElements();
                                                                            for (int i = 0; i < cols.length; ++i) {
                                                                                if (!cols[i].getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                                cols[i].setCommentInRDBMS(comment);
                                                                                break block33;
                                                                            }
                                                                            break block33;
                                                                        }
                                                                        if (!this.object2.equalsIgnoreCase("'index'")) break block53;
                                                                        if (this.tableProxy == null) break block54;
                                                                        IndexProxy[] indexes = this.tableProxy.getIndexProxies();
                                                                        boolean flag = false;
                                                                        for (int i = 0; i < indexes.length; ++i) {
                                                                            if (!indexes[i].getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                            indexes[i].setCommentInRDBMS(comment);
                                                                            indexes[i].setCommentInRDBMSChanged(true);
                                                                            flag = true;
                                                                            break;
                                                                        }
                                                                        if (flag || this.table == null) break block33;
                                                                        for (DesignObjectPlaceHolder dph : this.table.getIndexes()) {
                                                                            Index index3 = (Index)dph.getDesignObject();
                                                                            if (!index3.getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                            index3.setCommentInRDBMS(comment);
                                                                            break block33;
                                                                        }
                                                                        break block33;
                                                                    }
                                                                    if (this.table == null) break block33;
                                                                    for (DesignObjectPlaceHolder dph : this.table.getIndexes()) {
                                                                        Index index4 = (Index)dph.getDesignObject();
                                                                        if (!index4.getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                        index4.setCommentInRDBMS(comment);
                                                                        break block33;
                                                                    }
                                                                    break block33;
                                                                }
                                                                if (!this.object2.equalsIgnoreCase("'constraint'")) break block55;
                                                                if (this.tableProxy == null) break block56;
                                                                boolean flag = false;
                                                                for (PKProxySqlServer pkey : this.tableProxy.getPkeys()) {
                                                                    if (!pkey.getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                    pkey.setCommentInRDBMS(comment);
                                                                    pkey.setCommentInRDBMSChanged(true);
                                                                    flag = true;
                                                                    break;
                                                                }
                                                                if (!flag) {
                                                                    for (UniqueProxySqlServer ukey : this.tableProxy.getUkeys()) {
                                                                        if (!ukey.getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                        ukey.setCommentInRDBMS(comment);
                                                                        ukey.setCommentInRDBMSChanged(true);
                                                                        flag = true;
                                                                        break;
                                                                    }
                                                                }
                                                                if (!flag && this.table != null) {
                                                                    for (DesignObjectPlaceHolder dph : this.table.getPKeys()) {
                                                                        index2 = (Index)dph.getDesignObject();
                                                                        if (!index2.getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                        index2.setCommentInRDBMS(comment);
                                                                        break;
                                                                    }
                                                                }
                                                                if (flag || this.table == null) break block33;
                                                                for (DesignObjectPlaceHolder dph : this.table.getUKeys()) {
                                                                    index2 = (Index)dph.getDesignObject();
                                                                    if (!index2.getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                    index2.setCommentInRDBMS(comment);
                                                                    break block33;
                                                                }
                                                                break block33;
                                                            }
                                                            if (this.table == null) break block33;
                                                            for (DesignObjectPlaceHolder dph : this.table.getPKeys()) {
                                                                Index index5 = (Index)dph.getDesignObject();
                                                                if (!index5.getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                index5.setCommentInRDBMS(comment);
                                                                break block33;
                                                            }
                                                            break block33;
                                                        }
                                                        if (!this.object2.equalsIgnoreCase("'trigger'") || this.tableProxy == null) break block33;
                                                        for (TriggerSqlServer trigger : this.tableProxy.getTriggers()) {
                                                            if (!trigger.getName().equalsIgnoreCase(this.objectName2)) continue;
                                                            trigger.setCommentInRDBMS(comment);
                                                            break block33;
                                                        }
                                                        break block33;
                                                    }
                                                    if (!this.object.equalsIgnoreCase("'view'")) break block33;
                                                    this.viewProxy = ((TableViewProxySetSqlServer)stoDesign.getTableViewProxySet()).getByName(this.objectName);
                                                    if (this.viewProxy == null || !this.object2.equalsIgnoreCase("'index'")) break block57;
                                                    for (IndexOnViewSqlServer index6 : this.viewProxy.getIndexesOnView()) {
                                                        if (!index6.getName().equalsIgnoreCase(this.objectName2)) continue;
                                                        index6.setCommentInRDBMS(comment);
                                                        break block33;
                                                    }
                                                    break block33;
                                                }
                                                if (this.viewProxy == null || !this.object2.equalsIgnoreCase("'trigger'") || this.viewProxy == null) break block33;
                                                for (TriggerSqlServer trigger : this.viewProxy.getTriggers()) {
                                                    if (!trigger.getName().equalsIgnoreCase(this.objectName2)) continue;
                                                    trigger.setCommentInRDBMS(comment);
                                                    break block33;
                                                }
                                                break block33;
                                            }
                                            if (count != 8) break block33;
                                            tokenizer.nextToken().trim();
                                            tokenizer.nextToken().trim();
                                            this.object = tokenizer.nextToken().trim();
                                            this.object = Token.cutN(this.object);
                                            this.objectName = tokenizer.nextToken().trim();
                                            this.objectName = Token.cutN(this.objectName);
                                            this.objectName = Token.getValBetweenQuotationMarks(this.objectName);
                                            this.object2 = tokenizer.nextToken().trim();
                                            this.object2 = Token.cutN(this.object2);
                                            this.objectName2 = tokenizer.nextToken().trim();
                                            this.objectName2 = Token.cutN(this.objectName2);
                                            this.objectName2 = Token.getValBetweenQuotationMarks(this.objectName2);
                                            if (!this.object.equalsIgnoreCase("'table'")) break block58;
                                            this.tableProxy = ((TableProxySetSqlServer)stoDesign.getTableProxySet()).getByName(this.objectName);
                                            this.table = (Table)this.design.getDesign().getRelationalDesign().getTableSet().getByName(this.objectName);
                                            if (!this.object2.equalsIgnoreCase("'column'")) break block59;
                                            if (this.tableProxy == null) break block60;
                                            ColumnProxy col = this.tableProxy.getColumnProxyByName(this.objectName2);
                                            if (col == null) break block61;
                                            col.setCommentInRDBMS(comment);
                                            col.setCommentInRDBMSChanged(true);
                                            break block33;
                                        }
                                        if (this.table == null) break block33;
                                        ContainedObject[] cols = this.table.getElements();
                                        for (int i = 0; i < cols.length; ++i) {
                                            if (!cols[i].getName().equalsIgnoreCase(this.objectName2)) continue;
                                            cols[i].setCommentInRDBMS(comment);
                                            break block33;
                                        }
                                        break block33;
                                    }
                                    if (this.table == null) break block33;
                                    ContainedObject[] cols = this.table.getElements();
                                    for (int i = 0; i < cols.length; ++i) {
                                        if (!cols[i].getName().equalsIgnoreCase(this.objectName2)) continue;
                                        cols[i].setCommentInRDBMS(comment);
                                        break block33;
                                    }
                                    break block33;
                                }
                                if (!this.object2.equalsIgnoreCase("'index'")) break block62;
                                if (this.tableProxy == null) break block63;
                                IndexProxy[] indexes = this.tableProxy.getIndexProxies();
                                boolean flag = false;
                                for (int i = 0; i < indexes.length; ++i) {
                                    if (!indexes[i].getName().equalsIgnoreCase(this.objectName2)) continue;
                                    indexes[i].setCommentInRDBMS(comment);
                                    indexes[i].setCommentInRDBMSChanged(true);
                                    flag = true;
                                    break;
                                }
                                if (flag || this.table == null) break block33;
                                for (DesignObjectPlaceHolder dph : this.table.getIndexes()) {
                                    Index index7 = (Index)dph.getDesignObject();
                                    if (!index7.getName().equalsIgnoreCase(this.objectName2)) continue;
                                    index7.setCommentInRDBMS(comment);
                                    break block33;
                                }
                                break block33;
                            }
                            if (this.table == null) break block33;
                            for (DesignObjectPlaceHolder dph : this.table.getIndexes()) {
                                Index index8 = (Index)dph.getDesignObject();
                                if (!index8.getName().equalsIgnoreCase(this.objectName2)) continue;
                                index8.setCommentInRDBMS(comment);
                                break block33;
                            }
                            break block33;
                        }
                        if (!this.object2.equalsIgnoreCase("'constraint'")) break block64;
                        if (this.tableProxy == null) break block65;
                        boolean flag = false;
                        for (PKProxySqlServer pkey : this.tableProxy.getPkeys()) {
                            if (!pkey.getName().equalsIgnoreCase(this.objectName2)) continue;
                            pkey.setCommentInRDBMS(comment);
                            pkey.setCommentInRDBMSChanged(true);
                            flag = true;
                            break;
                        }
                        if (!flag) {
                            for (UniqueProxySqlServer ukey : this.tableProxy.getUkeys()) {
                                if (!ukey.getName().equalsIgnoreCase(this.objectName2)) continue;
                                ukey.setCommentInRDBMS(comment);
                                ukey.setCommentInRDBMSChanged(true);
                                flag = true;
                                break;
                            }
                        }
                        if (!flag && this.table != null) {
                            for (DesignObjectPlaceHolder dph : this.table.getPKeys()) {
                                index = (Index)dph.getDesignObject();
                                if (!index.getName().equalsIgnoreCase(this.objectName2)) continue;
                                index.setCommentInRDBMS(comment);
                                break;
                            }
                        }
                        if (flag || this.table == null) break block33;
                        for (DesignObjectPlaceHolder dph : this.table.getUKeys()) {
                            index = (Index)dph.getDesignObject();
                            if (!index.getName().equalsIgnoreCase(this.objectName2)) continue;
                            index.setCommentInRDBMS(comment);
                            break block33;
                        }
                        break block33;
                    }
                    if (this.table == null) break block33;
                    for (DesignObjectPlaceHolder dph : this.table.getPKeys()) {
                        Index index = (Index)dph.getDesignObject();
                        if (!index.getName().equalsIgnoreCase(this.objectName2)) continue;
                        index.setCommentInRDBMS(comment);
                        break block33;
                    }
                    break block33;
                }
                if (!this.object2.equalsIgnoreCase("'trigger'") || this.tableProxy == null) break block33;
                for (TriggerSqlServer trigger : this.tableProxy.getTriggers()) {
                    if (!trigger.getName().equalsIgnoreCase(this.objectName2)) continue;
                    trigger.setCommentInRDBMS(comment);
                    break block33;
                }
                break block33;
            }
            if (!this.object.equalsIgnoreCase("'view'")) break block33;
            this.viewProxy = ((TableViewProxySetSqlServer)stoDesign.getTableViewProxySet()).getByName(this.objectName);
            if (this.viewProxy != null && this.object2.equalsIgnoreCase("'index'")) {
                for (IndexOnViewSqlServer index : this.viewProxy.getIndexesOnView()) {
                    if (!index.getName().equalsIgnoreCase(this.objectName2)) continue;
                    index.setCommentInRDBMS(comment);
                    break;
                }
            } else if (this.viewProxy != null && this.object2.equalsIgnoreCase("'trigger'") && this.viewProxy != null) {
                for (TriggerSqlServer trigger : this.viewProxy.getTriggers()) {
                    if (!trigger.getName().equalsIgnoreCase(this.objectName2)) continue;
                    trigger.setCommentInRDBMS(comment);
                    break;
                }
            }
        }
    }

    private void initWithoutColumn(StringTokenizer tokenizer, StorageDesignSqlServer stoDesign) {
        this.propertyName = tokenizer.nextToken().trim();
        this.propertyName = Token.cutN(this.propertyName);
        this.propertyName = Token.getValBetweenQuotationMarks(this.propertyName);
        this.propertyValue = tokenizer.nextToken().trim();
        this.propertyValue = Token.cutN(this.propertyValue);
        this.propertyValue = Token.getValBetweenQuotationMarks(this.propertyValue);
        tokenizer.nextToken().trim();
        tokenizer.nextToken().trim();
        this.object = tokenizer.nextToken().trim();
        this.objectName = tokenizer.nextToken().trim();
        this.object = Token.cutN(this.object);
        this.objectName = Token.cutN(this.objectName);
        if (this.object.equalsIgnoreCase("'table'")) {
            this.setTableProps(this.propertyName, this.propertyValue, this.objectName.toUpperCase(), stoDesign);
        } else if (this.object.equalsIgnoreCase("'view'")) {
            this.setViewProps(this.propertyName, this.propertyValue, this.objectName.toUpperCase(), stoDesign);
        }
    }

    private void setIndexOnView(String propertyName, String propertyValue, String objectName, StorageDesignSqlServer stoDesign) {
        this.indexOnView = (IndexOnViewSqlServer)stoDesign.getIndexOnViewSet().getByName(objectName);
        this.indexOnView.setProps(propertyName);
        this.indexOnView.setProps(propertyValue);
    }

    private void setTableProps(String propertyName, String propertyValue, String objectName, StorageDesignSqlServer stoDesign) {
        this.table = (Table)this.design.getDesign().getRelationalDesign().getTableSet().getByName(objectName);
        this.tableProxy = (TableProxySqlServer)stoDesign.getTableProxySet().getProxy(this.table.getObjectID());
        this.tableProxy.setProps(propertyName);
        this.tableProxy.setProps(propertyValue);
    }

    private void setViewProps(String propertyName, String propertyValue, String objectName, StorageDesignSqlServer stoDesign) {
        this.view = (TableView)this.design.getDesign().getRelationalDesign().getTableViewSet().getByName(objectName);
        this.viewProxy = (TableViewProxySqlServer)stoDesign.getTableViewProxySet().getProxy(this.view.getObjectID());
        this.viewProxy.setProps(propertyName);
        this.viewProxy.setProps(propertyValue);
    }

    private void initWithColumn(StringTokenizer tokenizer, StorageDesignSqlServer stoDesign) {
        this.propertyName = tokenizer.nextToken().trim();
        this.propertyName = Token.cutN(this.propertyName);
        this.propertyName = Token.getValBetweenQuotationMarks(this.propertyName);
        this.propertyValue = tokenizer.nextToken().trim();
        this.propertyValue = Token.cutN(this.propertyValue);
        this.propertyValue = Token.getValBetweenQuotationMarks(this.propertyValue);
        tokenizer.nextToken().trim();
        tokenizer.nextToken().trim();
        this.object = tokenizer.nextToken().trim();
        this.objectName = tokenizer.nextToken().trim();
        this.object2 = tokenizer.nextToken().trim();
        this.objectName2 = tokenizer.nextToken().trim();
        this.object = Token.cutN(this.object);
        this.objectName = Token.cutN(this.objectName);
        this.object2 = Token.cutN(this.object2);
        this.objectName2 = Token.cutN(this.objectName2);
        this.objectName = Token.getValBetweenQuotationMarks(this.objectName);
        this.objectName2 = Token.getValBetweenQuotationMarks(this.objectName2);
        if (this.object.equalsIgnoreCase("'Schema-bound View'")) {
            this.setIndexOnView(this.propertyName, this.propertyValue, this.objectName2.toUpperCase(), stoDesign);
        } else if (this.object2.equalsIgnoreCase("'column'")) {
            this.setColumnProps(this.propertyName, this.propertyValue, this.objectName2.toUpperCase(), stoDesign);
        } else if (this.object2.equalsIgnoreCase("'index'")) {
            this.setTableIndexProps(this.propertyName, this.propertyValue, this.objectName2.toUpperCase(), stoDesign);
        }
    }

    private void setTableIndexProps(String propertyName, String propertyValue, String objectName2, StorageDesignSqlServer stoDesign) {
        this.indexProxy = (IndexProxySqlServer)stoDesign.getIndexProxySet().getByName(objectName2);
        this.indexProxy.setProps(propertyName);
        this.indexProxy.setProps(propertyValue);
    }

    private void setColumnProps(String propertyName, String propertyValue, String objectName, StorageDesignSqlServer stoDesign) {
        this.columnProxy = ((ColumnProxySetSqlServer)stoDesign.getColumnProxySet()).getByName(objectName);
        this.columnProxy.setProps(propertyName);
        this.columnProxy.setProps(propertyValue);
    }
}

