/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateRoleSqlServer
extends DDLStatementHandlerSqlServer {
    private static final String ROLENAME = "@rolename";
    private static final String MEMBERNAME = "@membername";
    private static final String PASSWORD = "@password";
    private static final String OWNERNAME = "@ownername";
    private static final Logger LOGGER = new Logger(SHCreateRoleSqlServer.class);

    public SHCreateRoleSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateRoleSqlServer.clearCR(line);
        if (Token.startsWithString(statement, "exec sp_addrole")) {
            try {
                this.createDBRole(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(SHCreateRoleSqlServer.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "exec sp_addapprole")) {
            try {
                this.createApplRole(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(SHCreateRoleSqlServer.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "exec sp_addrolemember")) {
            try {
                this.addRoleMember(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(SHCreateRoleSqlServer.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void createDBRole(String statement) {
        RoleSqlServer role;
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(site);
        if (stoDesign != null && (role = stoDesign.getRoleSet().createRole()) != null) {
            this.design.getRelationalDesign().stampModelObjectDDL(role);
            role.setIsApplicationRole(false);
            String exp = Token.getStringAfter(this.statement, "sp_addrole").trim();
            StringTokenizer tokenizer = new StringTokenizer(exp, ",");
            String name = "";
            if (tokenizer.countTokens() == 1) {
                name = tokenizer.nextToken().trim();
                if (name.startsWith(ROLENAME)) {
                    name = Token.getStringAfter(name, "=").trim();
                }
                if (name.toUpperCase().startsWith("N'")) {
                    name = name.substring(1);
                }
                if (name.startsWith("'")) {
                    name = Token.getValBetweenQuotationMarks(name);
                }
                name = Token.getValBetweenSquareBrackets(name);
                role.setName(name);
                role.setDatabase(this.getCurrentDB());
            } else if (tokenizer.countTokens() == 2) {
                name = tokenizer.nextToken().trim();
                String ownerName = tokenizer.nextToken().trim();
                if (name.startsWith(ROLENAME)) {
                    name = Token.getStringAfter(name, "=").trim();
                }
                if (name.toUpperCase().startsWith("N'")) {
                    name = name.substring(1);
                }
                if (name.startsWith("'")) {
                    name = Token.getValBetweenQuotationMarks(name);
                }
                name = Token.getValBetweenSquareBrackets(name);
                if (ownerName.startsWith(OWNERNAME)) {
                    ownerName = Token.getStringAfter(ownerName, "=").trim();
                }
                if (ownerName.toUpperCase().startsWith("N'")) {
                    ownerName = ownerName.substring(1);
                }
                if (ownerName.startsWith("'")) {
                    ownerName = Token.getValBetweenQuotationMarks(ownerName);
                }
                ownerName = Token.getValBetweenSquareBrackets(ownerName);
                role.setName(name);
                role.setDatabase(this.getCurrentDB());
                StorageObjectCollection users = (StorageObjectCollection)this.getCurrentDB().getChild(3);
                UserSqlServer owner = (UserSqlServer)users.getByName(ownerName);
                role.setOwner(owner);
            } else {
                LOGGER.error("RoleSqlServer.createDBRole(): wrong syntax!");
                this.importLog.addWarning("Wrong syntax defining db role " + exp);
            }
        }
    }

    private void createApplRole(String statement) {
        RoleSqlServer role;
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(site);
        if (stoDesign != null && (role = stoDesign.getRoleSet().createRole()) != null) {
            this.design.getRelationalDesign().stampModelObjectDDL(role);
            role.setIsApplicationRole(true);
            String exp = Token.getStringAfter(this.statement, "sp_addapprole").trim();
            StringTokenizer tokenizer = new StringTokenizer(exp, ",");
            if (tokenizer.countTokens() == 2) {
                String name = tokenizer.nextToken().trim();
                String pass = tokenizer.nextToken().trim();
                if (name.startsWith(ROLENAME)) {
                    name = Token.getStringAfter(name, "=").trim();
                }
                if (name.toUpperCase().startsWith("N'")) {
                    name = name.substring(1);
                }
                if (name.startsWith("'")) {
                    name = Token.getValBetweenQuotationMarks(name);
                }
                name = Token.getValBetweenSquareBrackets(name);
                if (pass.startsWith(PASSWORD)) {
                    pass = Token.getStringAfter(pass, "=").trim();
                }
                if (pass.toUpperCase().startsWith("N'")) {
                    pass = pass.substring(1);
                }
                if (pass.startsWith("'")) {
                    pass = Token.getValBetweenQuotationMarks(pass);
                }
                role.setName(name);
                role.encodePassword(pass);
                role.setDatabase(this.getCurrentDB());
            } else {
                LOGGER.error("RoleSqlServer.createApplRole(): wrong syntax!");
                this.importLog.addWarning("Wrong syntax in creating appl role " + exp);
            }
        }
    }

    private void addRoleMember(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(site);
        if (stoDesign != null) {
            String exp = Token.getStringAfter(this.statement, "sp_addrolemember").trim();
            StringTokenizer tokenizer = new StringTokenizer(exp, ",");
            if (tokenizer.countTokens() == 2) {
                String roleName = tokenizer.nextToken().trim();
                String userName = tokenizer.nextToken().trim();
                if (roleName.startsWith(ROLENAME)) {
                    roleName = Token.getStringAfter(roleName, "=").trim();
                }
                if (roleName.toUpperCase().startsWith("N'")) {
                    roleName = roleName.substring(1);
                }
                if (roleName.startsWith("'")) {
                    roleName = Token.getValBetweenQuotationMarks(roleName);
                }
                roleName = Token.getValBetweenSquareBrackets(roleName);
                if (userName.startsWith(MEMBERNAME)) {
                    userName = Token.getStringAfter(userName, "=").trim();
                }
                if (userName.toUpperCase().startsWith("N'")) {
                    userName = userName.substring(1);
                }
                if (userName.startsWith("'")) {
                    userName = Token.getValBetweenQuotationMarks(userName);
                }
                userName = Token.getValBetweenSquareBrackets(userName);
                RoleSqlServer role = (RoleSqlServer)stoDesign.getRoleSet().getByName(roleName);
                if (role != null && userName != null && stoDesign.getUserSet().getByName(userName) != null) {
                    role.setUsers(userName);
                }
            } else {
                LOGGER.error("RoleSqlServer.addRoleMember(): wrong syntax!");
                this.importLog.addWarning("Wrong syntax in defining role member " + exp);
            }
        }
    }
}

