/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDefaultSqlServer
extends DDLStatementHandlerSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateDefaultSqlServer.class);

    public SHCreateDefaultSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateDefaultSqlServer.clearCR(line);
        if (Token.startsWithString(statement, "create default ")) {
            try {
                this.createDefault(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error("Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addError("Parsing " + statement + " for SQL Server failed");
                this.importLog.addFailedStatement(SHCreateDefaultSqlServer.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "sp_bindefault ")) {
            try {
                this.bindDefault(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error("Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addError("Parsing " + statement + " for SQL Server failed");
                this.importLog.addFailedStatement(SHCreateDefaultSqlServer.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void createDefault(String statement) {
        DefaultSqlServer def;
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(site);
        if (stoDesign != null && (def = stoDesign.getDefaultSet().createDefault()) != null) {
            this.design.getRelationalDesign().stampModelObjectDDL(def);
            String name = Token.getStringAfter(this.statement, "CREATE DEFAULT").trim();
            name = Token.getValBetweenSquareBrackets(Token.getStringBefore(name, "AS").trim());
            if (name.indexOf(46) > -1) {
                String ownerName = Token.getValBetweenSquareBrackets(name.substring(0, name.indexOf(46)));
                StorageObjectCollection users = (StorageObjectCollection)this.getCurrentDB().getChild(3);
                UserSqlServer owner = (UserSqlServer)users.getByName(ownerName);
                if (owner != null) {
                    def.setOwner(owner);
                }
                name = Token.getValBetweenSquareBrackets(name.substring(name.indexOf(46) + 1));
            }
            def.setName(name);
            String exp = Token.getStringAfterToken(this.statement, " AS ").trim();
            if (exp.toUpperCase().startsWith("N'")) {
                exp = exp.substring(1);
            }
            if (exp.startsWith("'")) {
                exp = Token.getValBetweenQuotationMarks(exp);
            }
            def.setConstant(exp);
            def.setDataBase(this.getCurrentDB());
        }
    }

    private void bindDefault(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(site);
        if (stoDesign != null) {
            String exp = Token.getStringAfter(this.statement.toLowerCase(), "sp_bindefault ").trim();
            StringTokenizer tokenizer = new StringTokenizer(exp, ",");
            if (tokenizer.countTokens() == 2) {
                String defName = tokenizer.nextToken().trim();
                String colName = tokenizer.nextToken().trim();
                if ((defName = Token.getValBetweenSquareBrackets(defName).trim()).startsWith("'")) {
                    defName = Token.getValBetweenQuotationMarks(defName);
                }
                if (colName.startsWith("'")) {
                    colName = Token.getValBetweenQuotationMarks(colName);
                }
                if (colName.indexOf(46) > -1) {
                    colName = colName.substring(colName.indexOf(46) + 1);
                }
                colName = Token.getValBetweenSquareBrackets(colName).trim();
                DefaultSqlServer def = (DefaultSqlServer)stoDesign.getDefaultSet().getByName(defName);
                ColumnProxySqlServer column = ((ColumnProxySetSqlServer)stoDesign.getColumnProxySet()).getByName(colName);
                if (def != null || column != null) {
                    column.setDefaultObject(def);
                    column.setDefineDefault(true);
                }
            } else {
                LOGGER.error("DefaultSqlServer.bindDefault(): wrong syntax!");
                this.importLog.addError("Wrong syntax near " + statement);
            }
        }
    }
}

