/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.ddl.AlterTableHandler;
import oracle.dbtools.crest.imports.ddl.CreateTableHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;

public class DDLStatementHandlerSqlServer
extends DDLStatementHandler
implements StatementsConstants {
    private DataBaseSqlServer currentDB = null;
    protected DDLStatementHandlerSqlServer successor = null;

    public DDLStatementHandlerSqlServer(Design design) {
        super(design);
    }

    public void add(DDLStatementHandlerSqlServer succ) {
        DDLStatementHandlerSqlServer end = this;
        while (end.successor != null) {
            end = end.successor;
        }
        end.successor = succ;
    }

    @Override
    public void handle(String line) {
        this.nextHandler(line);
    }

    @Override
    public void nextHandler(String line) {
        if (this.successor != null) {
            this.successor.setCurrentDB(this.getCurrentDB());
            this.successor.setImportLog(this.importLog);
            this.successor.handle(line);
        } else {
            this.importLog.addNotRecognized(DDLStatementHandlerSqlServer.FormatCR(line, "\n"));
        }
    }

    @Override
    public void setStatement(String statement) {
        this.statement = statement;
    }

    protected DataBaseSqlServer getCurrentDB() {
        return this.currentDB;
    }

    public void setCurrentDB(String currentDBName) {
        this.setCurrentDB(currentDBName, false);
    }

    public void setCurrentDB(String currentDBName, boolean create) {
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServer stoDesign = (StorageDesignSqlServer)this.design.getStorageDesign(site);
        DataBaseSqlServer db = (DataBaseSqlServer)stoDesign.getDataBaseSet().getByName(currentDBName);
        if (db == null) {
            if (create) {
                db = stoDesign.getDataBaseSet().createDataBase();
                db.setName(currentDBName);
                this.design.getRelationalDesign().stampModelObjectDDL(db);
            } else {
                db = (DataBaseSqlServer)stoDesign.getDataBaseSet().getNullInstance();
            }
        }
        this.currentDB = db;
    }

    protected void setCurrentDB(DataBaseSqlServer currentDB) {
        this.currentDB = currentDB;
    }

    @Override
    public CreateTableHandler getCreateTableHandler() {
        if (this instanceof CreateTableHandler) {
            return (CreateTableHandler)((Object)this);
        }
        if (this.successor != null) {
            return this.successor.getCreateTableHandler();
        }
        return null;
    }

    @Override
    public AlterTableHandler getAlterTableHandler() {
        if (this instanceof AlterTableHandler) {
            return (AlterTableHandler)((Object)this);
        }
        if (this.successor != null) {
            return this.successor.getAlterTableHandler();
        }
        return null;
    }
}

