/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ContextOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateContextOraclev9i
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateContextOraclev9i.class);

    public SHCreateContextOraclev9i(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateContextOraclev9i.clearCR(line);
        if (Token.startsWithString(statement, "CREATE CONTEXT") || Token.startsWithString(statement, "CREATE OR REPLACE CONTEXT")) {
            try {
                this.parseContext(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for Oracle 9i failed!", e);
                this.importLog.addFailedStatement(SHCreateContextOraclev9i.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseContext(String statement) {
        ContextOraclev9i context;
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignOracle stoDesign = (StorageDesignOracle)this.design.getStorageDesign(site);
        if (stoDesign != null && (context = (ContextOraclev9i)stoDesign.getContextSet().createContext()) != null) {
            this.initNamespace(context);
            this.initPackage(context);
            this.initOptions(context);
            this.design.getRelationalDesign().stampModelObjectDDL(context);
        }
    }

    private void initNamespace(ContextOraclev9i context) {
        String startOfName = Token.getStringAfterToken(this.statement, "CONTEXT");
        String namespace = Token.getFirstName(startOfName, '\"', '\"');
        context.setName(namespace);
        context.setNamespace(namespace);
        if (startOfName.startsWith("\"") && !namespace.equals(namespace.toUpperCase())) {
            context.setNameHasQuotes(true);
        }
    }

    private void initPackage(ContextOraclev9i context) {
        String pack = Token.getQuotedNameAfterToken(this.statement, "USING");
        context.setPackage(pack);
    }

    private void initOptions(ContextOraclev9i context) {
        if (Token.hasToken(this.statement, "INITIALIZED")) {
            String initialized = Token.getTokenAfter(this.statement, "INITIALIZED");
            context.setInitialized(initialized);
        } else if (this.statement.toUpperCase().indexOf("ACCESSED GLOBALLY") > -1) {
            context.setAccessedGlobally("YES");
        }
    }
}

