/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDimensionOraclev10g
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateDimensionOraclev10g.class);
    private DimensionOracle dimension;
    private StorageDesignOracle storageDesign;
    private String line;

    public SHCreateDimensionOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateDimensionOraclev10g.clearCR(line);
        this.line = line;
        if (Token.startsWithString(statement, "CREATE DIMENSION")) {
            this.parseDimension(statement);
        } else {
            this.nextHandler(line);
        }
    }

    private void parseDimension(String statement) {
        try {
            this.statement = statement;
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOracle)this.design.getStorageDesign(site);
            if (this.storageDesign != null) {
                this.dimension = this.storageDesign.getDimensionSet().createDimension();
                if (this.dimension != null) {
                    this.initName();
                    this.initLevels();
                    this.initHierarchies();
                    this.initAttributes();
                    this.design.getRelationalDesign().stampModelObjectDDL(this.dimension);
                }
            }
            this.importLog.incrementImportedStatements();
        }
        catch (Exception e) {
            LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
            this.importLog.addFailedStatement(SHCreateDimensionOraclev10g.FormatCR(this.line, "\n"));
        }
    }

    private void initName() {
        String startOfName = Token.getStringAfterToken(this.statement, "DIMENSION");
        String name = Token.getFirstName(startOfName, '\"', '\"');
        if (name.indexOf(46) > -1) {
            String ownerName = name.substring(0, name.indexOf(46));
            UserOracle owner = (UserOracle)this.storageDesign.getUserSet().getByName(ownerName);
            if (owner == null) {
                owner = this.storageDesign.getUserSet().createUser();
                owner.setName(ownerName);
                this.design.getRelationalDesign().stampModelObjectDDL(owner);
            }
            if (owner != null) {
                this.dimension.setUser(owner);
            }
            name = name.substring(name.indexOf(46) + 1);
            startOfName = startOfName.substring(startOfName.indexOf(46) + 1);
        }
        this.dimension.setName(name);
        if (startOfName.startsWith("\"") && !name.equals(name.toUpperCase())) {
            this.dimension.setNameHasQuotes(true);
        }
    }

    private void initLevels() {
        int index = this.statement.toUpperCase().indexOf("LEVEL ");
        if (index > -1) {
            String levels = this.statement.substring(index);
            if (Token.hasToken(levels, "HIERARCHY")) {
                levels = Token.getStringBeforeToken(levels, "HIERARCHY");
            }
            if (Token.hasToken(levels, "ATTRIBUTE")) {
                levels = Token.getStringBeforeToken(levels, "ATTRIBUTE");
            }
            while (Token.hasToken(levels, "LEVEL")) {
                String currLevel;
                if (levels.toUpperCase().indexOf("LEVEL ", 5) > -1) {
                    currLevel = levels.substring(0, levels.toUpperCase().indexOf("LEVEL ", 5));
                    levels = levels.substring(levels.toUpperCase().indexOf("LEVEL ", 5));
                } else {
                    currLevel = levels;
                    levels = "";
                }
                currLevel = Token.cutFirstToken(currLevel);
                String levelName = Token.getFirstName(currLevel, '\"', '\"');
                LevelOracle level = this.storageDesign.getLevelSet().createLevel();
                level.setName(levelName);
                if (currLevel.startsWith("\"") && !levelName.equals(levelName.toUpperCase())) {
                    level.setNameHasQuotes(true);
                }
                this.design.getRelationalDesign().stampModelObjectDDL(level);
                level.setDimension(this.dimension);
                String columns = Token.getStringAfterToken(currLevel, "IS");
                if (Token.hasToken(columns, "HIERARCHY")) {
                    columns = Token.getStringBeforeToken(columns, "HIERARCHY");
                }
                if (Token.hasToken(columns, "ATTRIBUTES")) {
                    columns = Token.getStringBeforeToken(columns, "ATTRIBUTES");
                }
                if ("".equalsIgnoreCase(columns)) continue;
                if (columns.charAt(0) == '(' && Token.hasCloseAndOpenBrackets(columns)) {
                    String between = Token.getValBetweenBrackets(columns);
                    StringTokenizer colTokenizer = new StringTokenizer(between, ",");
                    while (colTokenizer.hasMoreElements()) {
                        this.addLevelColumn(level, colTokenizer.nextToken());
                    }
                    continue;
                }
                this.addLevelColumn(level, columns);
            }
        }
    }

    private void addLevelColumn(LevelOracle level, String colName) {
        int dotIndex = colName.lastIndexOf(46);
        if (dotIndex > -1) {
            ColumnProxy col;
            TableProxyOracle table;
            String userName = null;
            String tableName = colName.substring(0, dotIndex).trim();
            colName = colName.substring(dotIndex + 1).trim();
            int tableDotIndex = tableName.lastIndexOf(46);
            if (tableDotIndex > -1) {
                userName = tableName.substring(0, tableDotIndex);
                tableName = tableName.substring(tableDotIndex + 1);
            }
            if ((table = ((TableProxySetOracle)this.storageDesign.getTableProxySet()).getByLongName(tableName, userName)) != null && (col = table.getColumnProxyByName(colName = Token.getName(colName))) != null) {
                level.setColumns(col.getObjectID());
                level.setLevelTable(table);
            }
        }
    }

    private void initHierarchies() {
        int index = this.statement.toUpperCase().indexOf("HIERARCHY ");
        if (index > -1) {
            String hierarchies = this.statement.substring(index);
            while (Token.hasToken(hierarchies, "HIERARCHY")) {
                String levels;
                String currHierarchy;
                index = hierarchies.toUpperCase().indexOf("HIERARCHY ", 9);
                if (index > -1) {
                    currHierarchy = hierarchies.substring(0, index);
                    hierarchies = hierarchies.substring(index);
                } else {
                    currHierarchy = hierarchies;
                    hierarchies = "";
                }
                currHierarchy = Token.cutFirstToken(currHierarchy);
                String hierName = Token.getFirstName(currHierarchy, '\"', '\"');
                HierarchyOracle h = this.storageDesign.getHierarchySet().createHierarchy();
                h.setName(hierName);
                if (currHierarchy.startsWith("\"") && !hierName.equals(hierName.toUpperCase())) {
                    h.setNameHasQuotes(true);
                }
                this.design.getRelationalDesign().stampModelObjectDDL(h);
                h.setDimension(this.dimension);
                if (Token.hasToken(currHierarchy, "ATTRIBUTE")) {
                    currHierarchy = Token.getStringBeforeToken(currHierarchy, "ATTRIBUTE");
                }
                currHierarchy = Token.getValBetweenBrackets(currHierarchy, 1);
                String joins = "";
                int ind = currHierarchy.toUpperCase().indexOf("JOIN KEY ");
                if (ind > -1) {
                    levels = currHierarchy.substring(0, ind).trim();
                    joins = currHierarchy.substring(ind);
                } else {
                    levels = currHierarchy;
                }
                while (!levels.equalsIgnoreCase("")) {
                    LevelOracle level;
                    String currLevel;
                    int childIndex = levels.toUpperCase().indexOf("CHILD OF");
                    if (childIndex > -1) {
                        currLevel = levels.substring(0, childIndex).trim();
                        levels = Token.getStringAfter(levels, "CHILD OF");
                    } else {
                        currLevel = levels;
                        levels = "";
                    }
                    if ((level = this.dimension.getLevelByName(currLevel = Token.getFirstName(currLevel, '\"', '\"'))) == null) continue;
                    h.setLevels(level.getObjectID());
                }
                if (joins.equalsIgnoreCase("")) continue;
                while (!joins.equalsIgnoreCase("")) {
                    String currJoin;
                    int joinIndex = joins.toUpperCase().indexOf("JOIN KEY", 7);
                    if (joinIndex > -1) {
                        currJoin = joins.substring(0, joinIndex).trim();
                        joins = joins.substring(joinIndex);
                    } else {
                        currJoin = joins.trim();
                        joins = "";
                    }
                    h.setJoins(currJoin);
                }
            }
        }
    }

    private void initAttributes() {
        int index = this.statement.toUpperCase().indexOf("ATTRIBUTE ");
        if (index > -1) {
            String attributes = this.statement.substring(index);
            while (Token.hasToken(attributes, "ATTRIBUTE")) {
                String columns;
                LevelOracle level;
                String currAttr;
                index = attributes.toUpperCase().indexOf("ATTRIBUTE ", 9);
                if (index > -1) {
                    currAttr = attributes.substring(0, index);
                    attributes = attributes.substring(index);
                } else {
                    currAttr = attributes;
                    attributes = "";
                }
                currAttr = Token.cutTokenFromFront(currAttr, "ATTRIBUTE");
                DimensionAttributeOracle attr = this.storageDesign.getDimensionAttributeSet().createDimensionAttribute();
                this.design.getRelationalDesign().stampModelObjectDDL(attr);
                attr.setDimension(this.dimension);
                String attrName = Token.getFirstName(currAttr, '\"', '\"');
                attr.setName(attrName);
                if (currAttr.startsWith("\"") && !attrName.equals(attrName.toUpperCase())) {
                    attr.setNameHasQuotes(true);
                }
                currAttr = currAttr.substring(attrName.length());
                String levelName = attrName;
                if (Token.hasToken(currAttr, "LEVEL")) {
                    currAttr = Token.getStringAfterToken(currAttr, "LEVEL");
                    levelName = Token.getFirstName(currAttr, '\"', '\"');
                    currAttr = currAttr.substring(levelName.length());
                }
                if ((level = this.dimension.getLevelByName(levelName)) != null) {
                    attr.setLevel(level);
                }
                if ((columns = Token.getStringAfterToken(currAttr, "DETERMINES")).charAt(0) == '(' && Token.hasCloseAndOpenBrackets(columns)) {
                    columns = Token.getValBetweenBrackets(columns);
                    StringTokenizer colTokenizer = new StringTokenizer(columns, ",");
                    while (colTokenizer.hasMoreElements()) {
                        this.addAttributeColumn(attr, level, colTokenizer.nextToken().trim());
                    }
                    continue;
                }
                this.addAttributeColumn(attr, level, columns);
            }
        }
    }

    private void addAttributeColumn(DimensionAttributeOracle attr, LevelOracle level, String colName) {
        TableProxy table;
        if (level != null && (table = level.getLevelTable()) != null) {
            ColumnProxy col;
            int dotIndex = colName.lastIndexOf(46);
            if (dotIndex > -1) {
                colName = colName.substring(dotIndex + 1).trim();
            }
            if ((col = table.getColumnProxyByName(colName = Token.getName(colName))) != null) {
                attr.setColumns(col.getObjectID());
            }
        }
    }
}

