/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;

public class SHCommentOnOracle
extends DDLStatementHandler {
    public SHCommentOnOracle(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCommentOnOracle.clearCR(line);
        if (Token.startsWithString(statement, "comment on")) {
            try {
                this.parseCommentOn(statement.replaceAll("\"", ""), line);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHCommentOnOracle.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseCommentOn(String statement, String line) throws ObjectDoesNotExistException {
        ContainerObject tableOrView;
        String onObject = Token.getTokenAfter(statement, "ON");
        String comment = Token.getStringAfter(line, "IS");
        if ((comment = Token.getFirstTextLiteral(comment)).startsWith("'")) {
            comment = comment.substring(1, comment.length() - 1);
            comment = comment.replaceAll("''", "'");
        }
        if (onObject.equalsIgnoreCase("COLUMN")) {
            onObject = Token.getNameAfterToken(statement, "COLUMN", '\"', '\"');
            StringTokenizer tokenizer = new StringTokenizer(onObject, ".");
            String tableName = null;
            String userName = null;
            String columnName = null;
            if (tokenizer.countTokens() == 3) {
                userName = tokenizer.nextToken();
                tableName = tokenizer.nextToken();
                columnName = tokenizer.nextToken();
            } else if (tokenizer.countTokens() == 2) {
                tableName = tokenizer.nextToken();
                columnName = tokenizer.nextToken();
            }
            ContainedObject column = null;
            ContainerObject tableOrView2 = this.getTableOrView(userName, tableName);
            if (tableOrView2 != null) {
                column = tableOrView2.getElementByName(columnName);
            }
            if (column != null) {
                column.setCommentInRDBMS(comment);
                return;
            }
            this.importLog.addError("Trying to set comment to a non-existent object: " + onObject);
            throw new ObjectDoesNotExistException();
        }
        if (onObject.equalsIgnoreCase("TABLE")) {
            ContainerObject modelObject;
            String tableOrView3 = onObject = Token.getNameAfterToken(statement, "TABLE", '\"', '\"');
            String userName = null;
            int dotIndex = onObject.indexOf(46);
            if (dotIndex > -1) {
                userName = onObject.substring(0, dotIndex);
                tableOrView3 = onObject.substring(dotIndex + 1);
            }
            if ((modelObject = this.getTableOrView(userName, tableOrView3)) != null) {
                modelObject.setCommentInRDBMS(comment);
                return;
            }
            this.importLog.addError("Trying to set comment to a non-existent object: " + onObject);
            throw new ObjectDoesNotExistException();
        }
        if (!onObject.equalsIgnoreCase("MATERIALIZED")) return;
        onObject = Token.getNameAfterToken(statement, "VIEW", '\"', '\"');
        String userName = null;
        int dotIndex = onObject.indexOf(46);
        if (dotIndex > -1) {
            userName = onObject.substring(0, dotIndex);
            onObject = onObject.substring(dotIndex + 1);
        }
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignOracle storageDesign = (StorageDesignOracle)this.design.getStorageDesign(site);
        SnapshotOracle snapshot = null;
        if (userName != null) {
            snapshot = (SnapshotOracle)storageDesign.getSnapshotSet().getBySchemaAndName(userName, onObject);
        }
        if (snapshot == null) {
            snapshot = (SnapshotOracle)storageDesign.getSnapshotSet().getByName(onObject);
        }
        if ((tableOrView = this.getTableOrView(userName, onObject)) != null) {
            tableOrView.setCommentInRDBMS(comment);
            return;
        }
        if (snapshot != null) {
            snapshot.setCommentInRDBMS(comment);
            return;
        }
        this.importLog.addError("Trying to set comment to a non-existent object: " + onObject);
        throw new ObjectDoesNotExistException();
    }

    private ContainerObject getTableOrView(String userName, String objectName) {
        ContainerObject syncModelObj;
        RelationalDesign rm;
        ContainerObject modelObject = this.getTableOrViewInRelDesign(userName, objectName, this.design.getRelationalDesign());
        if (modelObject == null && (rm = this.design.getRelationalDesign().getRelatedSyncModel()) != null && (syncModelObj = this.getTableOrViewInRelDesign(userName, objectName, rm)) != null) {
            if (syncModelObj instanceof Table) {
                modelObject = this.design.getRelationalDesign().createTable();
                ((Table)syncModelObj).restoreTo((Table)modelObject, true);
            } else if (syncModelObj instanceof TableView) {
                modelObject = this.design.getRelationalDesign().createTableView();
                syncModelObj.copy(modelObject);
                modelObject.setObjectID(syncModelObj.getObjectID());
            }
            modelObject.setCopyForIncrementalDDL(true);
        }
        return modelObject;
    }

    private ContainerObject getTableOrViewInRelDesign(String userName, String objectName, RelationalDesign relDesign) {
        DesignObject modelObject = null;
        if (userName != null && (modelObject = relDesign.getTableSet().getBySchemaAndName(userName, objectName)) == null) {
            modelObject = relDesign.getTableViewSet().getBySchemaAndName(userName, objectName);
        }
        if (modelObject == null && (modelObject = relDesign.getTableSet().getByName(objectName)) == null) {
            modelObject = relDesign.getTableViewSet().getByName(objectName);
        }
        return modelObject;
    }
}

