/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;

public class SHCreateSynonym
extends DDLStatementHandler {
    public SHCreateSynonym(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateSynonym.clearCR(line);
        if (Token.startsWithString(statement, "create synonym")) {
            try {
                this.parseSynonym(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHCreateSynonym.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseSynonym(String statement) {
        this.statement = statement;
        String synonymName = this.getNameOnly(Token.getNameAfterToken(this.statement, "SYNONYM", '\"', '\"').trim());
        String refObjName = this.getNameOnly(Token.getNameAfterToken(this.statement, "FOR", '\"', '\"').trim());
        Table table = (Table)this.design.getRelationalDesign().getTableSet().getByName(refObjName);
        TableView view = null;
        AliasDB2 alias = null;
        if (table == null) {
            view = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(refObjName);
        }
        if (table != null || view != null) {
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            AbstractStorageDesignDB2 storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
            SynonymDB2 synonym = storageDesign.getSynonymSet().createSynonym();
            synonym.setName(synonymName);
            this.design.getRelationalDesign().stampModelObjectDDL(synonym);
            if (table != null) {
                TableProxyDB2 tableProxy = (TableProxyDB2)storageDesign.getTableProxySet().getProxy(table.getObjectID());
                synonym.setTable(tableProxy);
                if (this.getOwner() != null) {
                    synonym.setOwner(this.getOwner());
                } else {
                    synonym.setOwner(storageDesign.getOwnerSet().getDefaultOwner());
                }
            } else {
                TableViewProxyDB2 tableViewProxy = (TableViewProxyDB2)storageDesign.getTableViewProxySet().getProxy(view.getObjectID());
                synonym.setView(tableViewProxy);
                if (this.getOwner() != null) {
                    synonym.setOwner(this.getOwner());
                } else {
                    synonym.setOwner(storageDesign.getOwnerSet().getDefaultOwner());
                }
            }
        } else {
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            AbstractStorageDesignDB2 storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
            alias = (AliasDB2)storageDesign.getAliasSet().getByName(refObjName);
            if (alias != null) {
                SynonymDB2 synonym = storageDesign.getSynonymSet().createSynonym();
                synonym.setName(synonymName);
                synonym.setAlias(alias);
                synonym.setOwner(this.getOwner());
                this.design.getRelationalDesign().stampModelObjectDDL(synonym);
            }
        }
    }
}

