/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureDB2;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateStoredProcedureDB2
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateStoredProcedureDB2.class);

    public SHCreateStoredProcedureDB2(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateStoredProcedureDB2.clearCR(line);
        if (Token.startsWithString(statement, "create procedure")) {
            try {
                this.parseStoredProcedure(statement.replaceAll("\"", ""), line);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error("Parsing " + statement + " for DB2 failed!", e);
                this.importLog.addFailedStatement(SHCreateStoredProcedureDB2.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseStoredProcedure(String statement, String line) {
        StoredProcedureDB2 proc;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
        if (storageDesign != null && (proc = storageDesign.getStoredProcedureSet().createStoredProcedure()) != null) {
            this.initStoredProcedureName(storageDesign, proc, statement);
            this.initBody(proc, line, statement);
            this.design.getRelationalDesign().stampModelObjectDDL(proc);
        }
    }

    private void initStoredProcedureName(AbstractStorageDesignDB2 storageDesign, StoredProcedureDB2 proc, String statement) {
        String name = Token.getTokenAfter(statement, "PROCEDURE");
        if (name.indexOf(46) > -1) {
            String ownerName = name.substring(0, name.indexOf(46));
            ownerName = Token.getValBetweenSquareBrackets(ownerName);
            Owner owner = (Owner)storageDesign.getOwnerSet().getByName(ownerName);
            if (owner != null) {
                proc.setOwner(owner);
            } else {
                proc.setOwner(storageDesign.getOwnerSet().getDefaultOwner());
            }
            name = name.substring(name.indexOf(46) + 1);
        }
        proc.setName(name);
    }

    private void initBody(StoredProcedureDB2 proc, String line, String statement) {
        String name = Token.getTokenAfter(statement, "PROCEDURE");
        String bodyText = Token.getStringAfter(line, name);
        proc.setBody(bodyText);
    }
}

