/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupSetDB2;

public class SHCreateDatabase
extends DDLStatementHandler {
    private DataBaseDB2 database;
    private static final String SYSDEFLT = "SYSDEFLT";

    public SHCreateDatabase(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateDatabase.clearCR(line);
        if (Token.startsWithString(statement, "create database")) {
            try {
                this.parseDatabase(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHCreateDatabase.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseDatabase(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 stoDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
        if (stoDesign != null) {
            String ccsid;
            String stoGroup;
            boolean isIndexBP;
            String indexBP;
            boolean isBufferpool;
            this.database = stoDesign.getDataBaseSet().createDataBase();
            String nameDB = this.initDatabaseName();
            this.database.setName(nameDB);
            this.design.getRelationalDesign().stampModelObjectDDL(this.database);
            this.initType();
            BufferPoolSetDB2 bufferPoolSet = stoDesign.getBufferPoolSet();
            String bufferPool = this.initBufferPool();
            if (bufferPool != null && (isBufferpool = bufferPoolSet.containsName(bufferPool))) {
                for (BufferPoolDB2 bufPool : bufferPoolSet) {
                    if (!bufPool.getName().equalsIgnoreCase(bufferPool)) continue;
                    this.database.setBufferPool(bufPool);
                    break;
                }
            }
            if ((indexBP = this.initIndexBP()) != null && (isIndexBP = bufferPoolSet.containsName(indexBP))) {
                for (BufferPoolDB2 bufPool : bufferPoolSet) {
                    if (!bufPool.getName().equalsIgnoreCase(indexBP)) continue;
                    this.database.setIndexBufferPool(bufPool);
                    break;
                }
            }
            if ((stoGroup = this.initStogroup()) != null) {
                StorageGroupSetDB2 stoGroupSet = stoDesign.getStorageGroupSet();
                boolean isStoGroup = stoGroupSet.containsName(stoGroup);
                if (!isStoGroup) {
                    stoGroup = SYSDEFLT;
                }
                this.database.setStorageGroup(stoGroupSet.getOrCreateStorageGroup(stoGroup));
            }
            if ((ccsid = this.initCCsid()) != null) {
                String[] choiseCCsid = DataBaseDB2.getCcsidChoices();
                for (int choise = 0; choise < choiseCCsid.length; ++choise) {
                    if (!ccsid.equalsIgnoreCase(choiseCCsid[choise])) continue;
                    this.database.setCcsid(choiseCCsid[choise]);
                    break;
                }
            }
        }
    }

    private String initDatabaseName() {
        return Token.getNameAfterToken(this.statement, "DATABASE", '\"', '\"').trim();
    }

    private String initBufferPool() {
        String bufferpool = null;
        boolean hasBufferpool = Token.hasToken(this.statement, "BUFFERPOOL");
        if (hasBufferpool) {
            bufferpool = Token.getTokenAfter(this.statement, "BUFFERPOOL").trim();
        }
        return bufferpool;
    }

    private String initIndexBP() {
        String indexBP = null;
        boolean hasIndexBp = Token.hasToken(this.statement, "INDEXBP");
        if (hasIndexBp) {
            indexBP = Token.getTokenAfter(this.statement, "INDEXBP").trim();
        }
        return indexBP;
    }

    private String initStogroup() {
        String stogroup = null;
        boolean hasStogroup = Token.hasToken(this.statement, "STOGROUP");
        if (hasStogroup) {
            stogroup = Token.getTokenAfter(this.statement, "STOGROUP").trim();
        }
        return stogroup;
    }

    private String initCCsid() {
        String ccsid = null;
        boolean hasCCsid = Token.hasToken(this.statement, "CCSID");
        if (hasCCsid) {
            ccsid = Token.getTokenAfter(this.statement, "CCSID").trim();
        }
        return ccsid;
    }

    public DataBaseDB2 getDatabase() {
        return this.database;
    }

    private void initType() {
        String type = null;
        String member = null;
        boolean hasType = Token.hasToken(this.statement, "AS");
        boolean hasMember = Token.hasToken(this.statement, "FOR");
        if (hasType && hasMember) {
            type = Token.getTokenAfter(this.statement, "AS").trim();
            member = Token.getTokenAfter(this.statement, "FOR").trim();
            if (type.equalsIgnoreCase("WORKFILE") || type.equalsIgnoreCase("TEMP")) {
                this.database.setType(type);
            }
            this.database.setMember(member);
        }
    }
}

