/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerDB2;

public class SHCommentOn
extends DDLStatementHandler {
    public SHCommentOn(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCommentOn.clearCR(line);
        if (Token.startsWithString(statement, "comment on")) {
            try {
                this.parseCommentOn(statement.replaceAll("\"", ""), line);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHCommentOn.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseCommentOn(String statement, String line) {
        String onObject = this.getNameOnly(Token.getTokenAfter(statement, "ON").trim());
        String comment = Token.getStringAfter(line, "IS");
        comment = Token.getValBetweenQuotationMarks(comment);
        if (onObject.trim().equalsIgnoreCase("ALIAS")) {
            onObject = this.getNameOnly(Token.getTokenAfter(statement, "ALIAS").trim());
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            AbstractStorageDesignDB2 storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
            AliasDB2 alias = (AliasDB2)storageDesign.getAliasSet().getByName(onObject);
            if (alias != null) {
                alias.setCommentInRDBMS(comment);
            }
        } else if (onObject.trim().equalsIgnoreCase("COLUMN")) {
            onObject = Token.getTokenAfter(statement, "COLUMN").trim();
            StringTokenizer tokenizer = new StringTokenizer(onObject, ".");
            String tbName = null;
            if (tokenizer.countTokens() == 3) {
                tokenizer.nextToken();
                tbName = tokenizer.nextToken();
                onObject = tokenizer.nextToken();
            } else if (tokenizer.countTokens() == 2) {
                tbName = tokenizer.nextToken();
                onObject = tokenizer.nextToken();
            }
            DesignObject column = null;
            if (tbName != null) {
                Table table = (Table)this.design.getRelationalDesign().getTableSet().getByName(tbName);
                if (table != null) {
                    column = table.getElementByName(onObject);
                } else {
                    TableView view = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(tbName);
                    if (view != null) {
                        column = view.getElementByName(onObject);
                    }
                }
                if (column == null) {
                    column = this.design.getRelationalDesign().getColumnSet().getByName(onObject);
                }
            } else {
                column = this.design.getRelationalDesign().getColumnSet().getByName(onObject);
            }
            if (column != null) {
                column.setCommentInRDBMS(comment);
            }
        } else if (onObject.trim().equalsIgnoreCase("PROCEDURE")) {
            onObject = this.getNameOnly(Token.getTokenAfter(statement, "PROCEDURE").trim());
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            AbstractStorageDesignDB2 storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
            StoredProcedureDB2 proc = (StoredProcedureDB2)storageDesign.getStoredProcedureSet().getByName(onObject);
            if (proc != null) {
                proc.setCommentInRDBMS(comment);
            }
        } else if (onObject.trim().equalsIgnoreCase("TABLE")) {
            onObject = this.getNameOnly(Token.getTokenAfter(statement, "TABLE").trim());
            Table table = (Table)this.design.getRelationalDesign().getTableSet().getByName(onObject);
            TableView view = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(onObject);
            if (table != null) {
                table.setCommentInRDBMS(comment);
            } else if (view != null) {
                view.setCommentInRDBMS(comment);
            }
        } else if (onObject.trim().equalsIgnoreCase("TRIGGER")) {
            onObject = this.getNameOnly(Token.getTokenAfter(statement, "TRIGGER").trim());
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            AbstractStorageDesignDB2 storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
            TriggerDB2 tr = (TriggerDB2)storageDesign.getTriggerSet().getByName(onObject);
            if (tr != null) {
                tr.setCommentInRDBMS(comment);
            }
        }
    }
}

