/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatementsSorter {
    static String FOREIGN = "FOREIGN KEY";
    static String ALTER_TABLE_NO_FK = "ALTER_TABLE_NO_FK";
    static String DIMENSION = "DIMENSION";
    static String TRIGGER = "TRIGGER";
    static String INDEX = "INDEX";
    static String COMMENT = "COMMENT";
    static String MVIEW = "MATERIALIZED VIEW";
    static String TABLESPACE = "TABLESPACE";
    static String ROLE = "ROLE";
    static String USER = "USER";
    static String GRANT = "GRANT";
    static List<String> AFTER_KEYS = new ArrayList<String>();
    static List<String> BEFORE_KEYS = new ArrayList<String>();
    static List<StatementSort> sorters = new ArrayList<StatementSort>();

    public static List<String> sort(List<String> statements) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> nonSorted = new ArrayList<String>();
        for (String st : statements) {
            boolean sorted = StatementsSorter.sort(st, st.toUpperCase(), map, sorters);
            if (sorted) continue;
            nonSorted.add(st);
        }
        for (String key : BEFORE_KEYS) {
            List l = (List)map.get(key);
            if (l == null) continue;
            list.addAll(l);
        }
        list.addAll(nonSorted);
        for (String key : AFTER_KEYS) {
            List l = (List)map.get(key);
            if (l == null) continue;
            list.addAll(l);
        }
        return list;
    }

    static boolean sort(String sourceStatement, String statement, Map<String, List<String>> map, List<StatementSort> sorters) {
        for (StatementSort s : sorters) {
            boolean sorted = s.sort(sourceStatement, statement, map);
            if (!sorted) continue;
            return true;
        }
        return false;
    }

    static boolean sortTriggers(String sourceStatement, String statement, Map<String, List<String>> map) {
        if (statement.startsWith("CREATE OR REPLACE TRIGGER") || statement.startsWith("CREATE TRIGGER")) {
            StatementsSorter.updateMap(sourceStatement, map, TRIGGER);
            return true;
        }
        return false;
    }

    static boolean sortFKs(String sourceStatement, String statement, Map<String, List<String>> map) {
        if ((statement.startsWith("ALTER TABLE") || statement.startsWith("ALTER VIEW")) && statement.indexOf(FOREIGN) > 0) {
            StatementsSorter.updateMap(sourceStatement, map, FOREIGN);
            return true;
        }
        return false;
    }

    static boolean sortAlterTable_NoFK(String sourceStatement, String statement, Map<String, List<String>> map) {
        if ((statement.startsWith("ALTER TABLE") || statement.startsWith("ALTER VIEW")) && statement.indexOf(FOREIGN) <= 0) {
            StatementsSorter.updateMap(sourceStatement, map, ALTER_TABLE_NO_FK);
            return true;
        }
        return false;
    }

    static boolean sortIndexes(String sourceStatement, String statement, Map<String, List<String>> map) {
        if ((statement.startsWith("CREATE INDEX") || statement.startsWith("CREATE UNIQUE INDEX") || statement.startsWith("CREATE BITMAP INDEX")) && !statement.startsWith("CREATE INDEXTYPE)")) {
            StatementsSorter.updateMap(sourceStatement, map, INDEX);
            return true;
        }
        return false;
    }

    static boolean sortDimensions(String sourceStatement, String statement, Map<String, List<String>> map) {
        if (statement.startsWith("CREATE DIMENSION")) {
            StatementsSorter.updateMap(sourceStatement, map, DIMENSION);
            return true;
        }
        return false;
    }

    static boolean sortComments(String sourceStatement, String statement, Map<String, List<String>> map) {
        if (statement.startsWith("COMMENT ON")) {
            StatementsSorter.updateMap(sourceStatement, map, COMMENT);
            return true;
        }
        return false;
    }

    static boolean sortTablespaces(String sourceStatement, String statement, Map<String, List<String>> map) {
        if (statement.startsWith("CREATE TABLESPACE") || statement.startsWith("CREATE SMALLFILE TABLESPACE") || statement.startsWith("CREATE BIGFILE TABLESPACE")) {
            StatementsSorter.updateMap(sourceStatement, map, TABLESPACE);
            return true;
        }
        return false;
    }

    static boolean sortRoles(String sourceStatement, String statement, Map<String, List<String>> map) {
        if (statement.startsWith("CREATE ROLE")) {
            StatementsSorter.updateMap(sourceStatement, map, ROLE);
            return true;
        }
        return false;
    }

    static boolean sortUsers(String sourceStatement, String statement, Map<String, List<String>> map) {
        if (statement.startsWith("CREATE USER")) {
            StatementsSorter.updateMap(sourceStatement, map, USER);
            return true;
        }
        return false;
    }

    static boolean sortGrants(String sourceStatement, String statement, Map<String, List<String>> map) {
        if (statement.startsWith("GRANT ")) {
            StatementsSorter.updateMap(sourceStatement, map, GRANT);
            return true;
        }
        return false;
    }

    static boolean sortMViews(String sourceStatement, String statement, Map<String, List<String>> map) {
        if (statement.startsWith("CREATE MATERIALIZED VIEW") || statement.startsWith("CREATE SNAPSHOT")) {
            StatementsSorter.updateMap(sourceStatement, map, MVIEW);
            return true;
        }
        return false;
    }

    static void updateMap(String statement, Map<String, List<String>> map, String key) {
        List<String> list = map.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            map.put(key, list);
        }
        list.add(statement);
    }

    public static void main(String[] args) {
    }

    static {
        BEFORE_KEYS.add(TABLESPACE);
        BEFORE_KEYS.add(ROLE);
        BEFORE_KEYS.add(USER);
        AFTER_KEYS.add(MVIEW);
        AFTER_KEYS.add(INDEX);
        AFTER_KEYS.add(ALTER_TABLE_NO_FK);
        AFTER_KEYS.add(FOREIGN);
        AFTER_KEYS.add(COMMENT);
        AFTER_KEYS.add(DIMENSION);
        AFTER_KEYS.add(TRIGGER);
        AFTER_KEYS.add(GRANT);
        sorters.add(StatementsSorter::sortMViews);
        sorters.add(StatementsSorter::sortIndexes);
        sorters.add(StatementsSorter::sortAlterTable_NoFK);
        sorters.add(StatementsSorter::sortFKs);
        sorters.add(StatementsSorter::sortComments);
        sorters.add(StatementsSorter::sortDimensions);
        sorters.add(StatementsSorter::sortTriggers);
        sorters.add(StatementsSorter::sortTablespaces);
        sorters.add(StatementsSorter::sortRoles);
        sorters.add(StatementsSorter::sortUsers);
    }

    public static interface StatementSort {
        public boolean sort(String var1, String var2, Map<String, List<String>> var3);
    }
}

