/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.cwddesigner;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.cwddesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.cwddesigner.CWDDesignObj;
import oracle.dbtools.crest.imports.cwddesigner.CWDExtractionHandler;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.xtdmapping.RMDeletedMap;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class CWDRelationalDesign
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "Relational Model";

    public CWDRelationalDesign(CWDExtractionHandler handler, ApplicationView view) {
        super(handler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(List appSystems) throws Exception {
        ArrayList list = new ArrayList();
        for (CWDDesignObj object : appSystems) {
            RelationalDesign physical;
            if (!object.getType().equalsIgnoreCase(OBJECT_TYPE)) continue;
            if (object.isSelected()) {
                physical = (RelationalDesign)object.getModel();
                if (physical.isLoaded()) continue;
                physical.setShouldBeOpen(true);
                this.getDesign().setClosing(true);
                this.getDesign().setClosing(false);
                if (physical.getDesign().isOldRepositoryType()) {
                    physical.load();
                } else {
                    physical.getAppView().getXMLTransformationManager().openDesignPart(physical);
                    RMExtendedMap rxmap = physical.getRMExtendedMap();
                    physical.getAppView().getXMLTransformationManager().transformFromXMLToObject(rxmap, new File(rxmap.getStorageName()), physical.getDesign().isCompressedDesign());
                    RMDeletedMap dxmap = physical.getRMDeletedMap();
                    physical.getAppView().getXMLTransformationManager().transformFromXMLToObject(dxmap, new File(dxmap.getStorageName()), physical.getDesign().isCompressedDesign());
                }
                physical.getDesign().getExtendedMap().distributenMappings(physical);
                if (object.getImportTo() instanceof RelationalDesign) {
                    physical.setImportTo((RelationalDesign)object.getImportTo());
                    continue;
                }
                physical.setImportTo(null);
                continue;
            }
            physical = (RelationalDesign)object.getModel();
            physical.setShouldBeOpen(false);
        }
        return list;
    }

    @Override
    public void generate(List selectedObjects, ImportLogger importLog) throws Exception {
        for (CWDDesignObj object : selectedObjects) {
            if (!object.getType().equalsIgnoreCase(OBJECT_TYPE)) continue;
            RelationalDesign physical = (RelationalDesign)object.getModel();
            if (physical.getImportTo() == null) {
                physical.setName(physical.getName() + "_" + physical.getDesign().getName());
                RelationalDesign newphysical = this.getOldDesign().addRelationalDesign(physical.getName());
                newphysical.setShouldEngineer(physical.getShouldEngineer());
                newphysical.setComment(physical.getComment());
                physical.setImportTo(newphysical);
            }
            this.importNotes(physical, physical.getImportTo());
            importLog.incrementImportedStatements();
        }
    }

    private void importNotes(RelationalDesign physical, RelationalDesign newPhysical) {
        for (int k = 0; k < physical.getNoteSet().size(); ++k) {
            Note newNote;
            Note note = (Note)physical.getNoteSet().getElement(k);
            if (newPhysical.getNoteSet().getByName(note.getName()) != null) {
                if (!this.canImport()) continue;
                String name = this.getPrefix() + note.getName();
                newNote = newPhysical.getNoteSet().createNote(null);
                newNote.copy(newNote);
                newNote.setText(note.getText());
                newNote.setName(name);
                newNote.setImportedDesign(physical.getDesign());
                newNote.setImportedId(note.getObjectID());
                continue;
            }
            newNote = newPhysical.getNoteSet().createNote(null);
            newNote.copy(newNote);
            newNote.setText(note.getText());
            newNote.setImportedDesign(physical.getDesign());
            newNote.setImportedId(note.getObjectID());
        }
    }
}

