/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.headless;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.crest.headless.HeadlessResources;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.headless.HeadlessCommandProcessor;
import oracle.dbtools.raptor.headless.HeadlessCore;
import oracle.dbtools.raptor.headless.HeadlessTask;
import oracle.dbtools.raptor.headless.InvalidCommandArgumentException;

public class DMReportsCommandProcessor
implements HeadlessCommandProcessor {
    private static final String ARG_DESIGN = "-DESIGN";
    private static final String ARG_REL_MODEL = "-RELMODEL";
    private static final String ARG_OUTPUT_PATH = "-OUTPUTPATH";
    private static final String ARG_TYPE = "-TYPE";
    private static final String ARG_TITLE = "-TITLE";
    private static final String ARG_FILE_NAME = "-FILENAME";
    private static final String ARG_TEMPLATE = "-TEMPLATE";
    private static final String ARG_COMPANY_NAME = "-COMPANYNAME";

    public HeadlessTask<Void> parseCommandArguments(HeadlessCore headless, String ... args) throws InvalidCommandArgumentException {
        if (args.length > 0) {
            String designFileName = null;
            String type = null;
            String fileName = null;
            String outputPath = null;
            String title = null;
            String relModelName = null;
            String template = null;
            String companyName = null;
            int a = 0;
            while (a < args.length - 1 && args[a].startsWith("-")) {
                String option = args[a++];
                String value = args[a++];
                if (ARG_DESIGN.equalsIgnoreCase(option)) {
                    designFileName = value;
                    continue;
                }
                if (ARG_REL_MODEL.equalsIgnoreCase(option)) {
                    relModelName = value;
                    continue;
                }
                if (ARG_OUTPUT_PATH.equalsIgnoreCase(option)) {
                    outputPath = value;
                    continue;
                }
                if (ARG_TYPE.equalsIgnoreCase(option)) {
                    type = value;
                    continue;
                }
                if (ARG_TITLE.equalsIgnoreCase(option)) {
                    title = value;
                    continue;
                }
                if (ARG_FILE_NAME.equalsIgnoreCase(option)) {
                    fileName = value;
                    continue;
                }
                if (ARG_TEMPLATE.equalsIgnoreCase(option)) {
                    template = value;
                    continue;
                }
                if (ARG_COMPANY_NAME.equalsIgnoreCase(option)) {
                    companyName = value;
                    continue;
                }
                throw new InvalidCommandArgumentException(HeadlessResources.format("INVALID_ARGUMENT", option));
            }
            if (designFileName == null) {
                throw new InvalidCommandArgumentException(HeadlessResources.format("INVALID_ARGUMENT", ARG_DESIGN));
            }
            if (fileName == null) {
                throw new InvalidCommandArgumentException(HeadlessResources.format("INVALID_ARGUMENT", ARG_FILE_NAME));
            }
            if (outputPath == null) {
                throw new InvalidCommandArgumentException(HeadlessResources.format("INVALID_ARGUMENT", ARG_OUTPUT_PATH));
            }
            if (title == null) {
                throw new InvalidCommandArgumentException(HeadlessResources.format("INVALID_ARGUMENT", ARG_TITLE));
            }
            if (type == null) {
                throw new InvalidCommandArgumentException(HeadlessResources.format("INVALID_ARGUMENT", ARG_TYPE));
            }
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put(ARG_DESIGN, designFileName);
            arguments.put(ARG_TYPE, type);
            arguments.put(ARG_FILE_NAME, fileName);
            arguments.put(ARG_OUTPUT_PATH, outputPath);
            arguments.put(ARG_TITLE, title);
            arguments.put(ARG_REL_MODEL, relModelName);
            arguments.put(ARG_TEMPLATE, template);
            arguments.put(ARG_COMPANY_NAME, companyName);
            return new DMReportsCommandTask(headless, arguments);
        }
        headless.printMessage(new String[]{this.getUsageString()});
        return null;
    }

    public String getUsageString() {
        return HeadlessResources.getString("DM_REPORTS_USAGE_STRING");
    }

    public static class DMReportsCommandTask
    extends HeadlessTask<Void> {
        private HeadlessCore headless;
        private String designFileName = null;
        private String type = null;
        private String fileName = null;
        private String outputPath = null;
        private String title = null;
        private String relModelName = null;
        private String template = null;
        private String companyName = null;

        protected DMReportsCommandTask(HeadlessCore headless, Map<String, String> arguments) {
            super("dmreports");
            this.headless = headless;
            this.designFileName = arguments.get(DMReportsCommandProcessor.ARG_DESIGN);
            this.type = arguments.get(DMReportsCommandProcessor.ARG_TYPE);
            this.fileName = arguments.get(DMReportsCommandProcessor.ARG_FILE_NAME);
            this.outputPath = arguments.get(DMReportsCommandProcessor.ARG_OUTPUT_PATH);
            this.title = arguments.get(DMReportsCommandProcessor.ARG_TITLE);
            this.relModelName = arguments.get(DMReportsCommandProcessor.ARG_REL_MODEL);
            this.template = arguments.get(DMReportsCommandProcessor.ARG_TEMPLATE);
            this.companyName = arguments.get(DMReportsCommandProcessor.ARG_COMPANY_NAME);
        }

        protected Void doWork() throws TaskException {
            System.out.println(this.designFileName);
            System.out.println(this.type);
            System.out.println(this.fileName);
            System.out.println(this.outputPath);
            System.out.println(this.title);
            System.out.println(this.relModelName);
            System.out.println(this.template);
            System.out.println(this.companyName);
            return null;
        }
    }
}

