/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Icon;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.VCSHistoryWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNStorableObjectStatus;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNHistoryWindow
extends VCSHistoryWindow<ISVNLogMessage> {
    protected static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();
    private static final Logger LOGGER = new Logger(SVNHistoryWindow.class);
    private static final String URL_ENCODING_CHARSET = "UTF-8";
    private static SVNHistoryWindow INSTANCE = new SVNHistoryWindow();
    private final LogMessagesComparator LOG_MESSAGES_COMPARATOR = new LogMessagesComparator();
    protected String repositoryUrl = "";
    protected String svnDesignPath = "";

    protected SVNHistoryWindow() {
    }

    public static SVNHistoryWindow getInstance() {
        return INSTANCE;
    }

    @Override
    public VCSClientHelper getVCSClientHelper() {
        return SVN_CLIENT_HELPER;
    }

    @Override
    protected void init(File[] filePaths, Design design) {
        super.init(filePaths, design);
        if (!ApplicationView.getInstance().getCurrentDesign().isSVNVersioned()) {
            return;
        }
        ISVNInfo svnInfo = SVN_CLIENT_HELPER.doInfo(filePaths[0]);
        if (svnInfo == null) {
            return;
        }
        this.repositoryUrl = svnInfo.getRepository().toString();
        this.svnDesignPath = this.resolveSvnDesignPath(svnInfo);
    }

    public boolean isSelectedWorkingCopyRevision() {
        StorableObjectStatus selectedStorableObjectStatus = this.getSelectedStorableObjectStatus();
        File filePath = selectedStorableObjectStatus.getFilePath();
        if (filePath.exists() && SVN_CLIENT_HELPER.isVersioned(filePath)) {
            long fileRevision = SVN_CLIENT_HELPER.doInfo(filePath).getRevision().getNumber();
            return selectedStorableObjectStatus.getRevision() == fileRevision;
        }
        return false;
    }

    public Icon getTabIcon() {
        return VCSIconArb.getIcon((String)"version_history.png");
    }

    protected String resolveSvnDesignPath(ISVNInfo svnInfo) {
        try {
            String relativeSvnPath = URLDecoder.decode(svnInfo.getUrlString(), URL_ENCODING_CHARSET).replace(svnInfo.getRepository().toString(), "");
            String relativeFilePath = svnInfo.getFile().getPath().replace(this.design.getDesignPath(), "").replace(File.separatorChar, '/');
            return relativeSvnPath.replace(relativeFilePath, "");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e);
            return null;
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.repositoryUrl = null;
        this.svnDesignPath = null;
    }

    @Override
    protected InputStream getRevision(String url, Long revision) {
        try {
            return SVN_CLIENT_HELPER.doGetRevision(new SVNUrl(url), revision == null ? SVNRevision.HEAD : SVNRevision.getRevision((String)String.valueOf(revision)));
        }
        catch (ParseException e) {
            LOGGER.warn(e);
        }
        catch (MalformedURLException e) {
            LOGGER.warn(e);
        }
        return null;
    }

    @Override
    protected InputStream getRevision(File file, Long revision) {
        try {
            if (revision == null) {
                return new FileInputStream(file);
            }
            return SVN_CLIENT_HELPER.doGetRevision(file, SVNRevision.getRevision((String)String.valueOf(revision)));
        }
        catch (ParseException e) {
            LOGGER.warn(e);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn(e);
        }
        return null;
    }

    @Override
    protected List<ISVNLogMessage> getLogMessages(String url, Long startRevision, Long endRevision, boolean getChangePaths, boolean addLocalSaved) {
        ArrayList<ISVNLogMessage> result = new ArrayList<ISVNLogMessage>();
        List<ISVNLogMessage> logMessages = null;
        try {
            logMessages = SVN_CLIENT_HELPER.doGetLogMessages(new SVNUrl(url), startRevision, endRevision, false, getChangePaths, 0);
            Collections.sort(logMessages, new Comparator<ISVNLogMessage>(){

                @Override
                public int compare(ISVNLogMessage logMessage1, ISVNLogMessage logMessage2) {
                    return SVNHistoryWindow.this.getRevision(logMessage2).compareTo(SVNHistoryWindow.this.getRevision(logMessage1));
                }
            });
            if (addLocalSaved) {
                result.add(new LocalVersion());
            }
            result.addAll(logMessages);
        }
        catch (MalformedURLException e) {
            LOGGER.error(e);
        }
        return result;
    }

    @Override
    protected List<ISVNLogMessage> getLogMessages(File[] filePaths, Long startRevision, Long endRevision, boolean getChangePaths, boolean addLocalSaved) {
        TreeSet<ISVNLogMessage> result = new TreeSet<ISVNLogMessage>(this.LOG_MESSAGES_COMPARATOR);
        if (addLocalSaved) {
            result.add(new LocalVersion());
        }
        for (File filePath : filePaths) {
            if (SVN_CLIENT_HELPER.getRevision(filePath) <= 0L) continue;
            result.addAll(SVN_CLIENT_HELPER.doGetLogMessages(filePath, startRevision, endRevision, false, getChangePaths, 0));
        }
        return new ArrayList<ISVNLogMessage>(result);
    }

    @Override
    protected Long getRevision(ISVNLogMessage logMessage) {
        SVNRevision.Number revision = logMessage.getRevision();
        return revision == null ? null : Long.valueOf(revision.getNumber());
    }

    @Override
    protected Date getDate(ISVNLogMessage logMessage) {
        return logMessage.getDate();
    }

    @Override
    protected String getAuthor(ISVNLogMessage logMessage) {
        return logMessage.getAuthor();
    }

    @Override
    protected String getComment(ISVNLogMessage logMessage) {
        return logMessage.getMessage();
    }

    @Override
    protected Map<ISVNLogMessage, List<StorableObjectStatus>> parseChangedObjects(List<ISVNLogMessage> logMessages) {
        HashMap<ISVNLogMessage, List<StorableObjectStatus>> result = new HashMap<ISVNLogMessage, List<StorableObjectStatus>>();
        for (ISVNLogMessage logMessage : logMessages) {
            ArrayList<StorableObjectStatus> changedObjects = new ArrayList<StorableObjectStatus>();
            ISVNLogMessageChangePath[] changePathsArray = logMessage.getChangedPaths();
            if (changePathsArray != null) {
                for (ISVNLogMessageChangePath changePath : changePathsArray) {
                    StorableObjectStatus objectStatus = this.parseChangedObject(changePath, logMessage.getRevision().getNumber());
                    if (!StringUtilities.isNotEmpty(objectStatus.getStorableObjectName())) continue;
                    changedObjects.add(objectStatus);
                }
                Collections.sort(changedObjects, new Comparator<StorableObjectStatus>(){

                    @Override
                    public int compare(StorableObjectStatus storableObjectStatus1, StorableObjectStatus storableObjectStatus2) {
                        boolean isPhysicalObject2;
                        String filePath1 = storableObjectStatus1.getFilePath().getPath();
                        String filePath2 = storableObjectStatus2.getFilePath().getPath();
                        String storageDesignPattern = File.separator + "phys";
                        String storageDesignFolderPattern = storageDesignPattern + File.separator;
                        boolean isPhysicalObject1 = filePath1.contains(storageDesignFolderPattern) || filePath1.endsWith(storageDesignPattern);
                        boolean bl = isPhysicalObject2 = filePath2.contains(storageDesignFolderPattern) || filePath2.endsWith(storageDesignPattern);
                        if (isPhysicalObject1 && !isPhysicalObject2) {
                            return 1;
                        }
                        if (!isPhysicalObject1 && isPhysicalObject2) {
                            return -1;
                        }
                        return filePath1.compareTo(filePath2);
                    }
                });
            }
            result.put(logMessage, changedObjects);
        }
        return result;
    }

    protected StorableObjectStatus parseChangedObject(ISVNLogMessageChangePath changePath, Long revision) {
        File localFile = this.resolveLocalFile(changePath);
        String svnPath = changePath.getPath();
        String action = String.valueOf(changePath.getAction());
        SVNStorableObjectStatus objectStatus = new SVNStorableObjectStatus(this.design, localFile, action, null, revision);
        objectStatus.setRepositoryUrl(this.repositoryUrl);
        objectStatus.setPathUrl(svnPath);
        objectStatus.setCopyRevision(changePath.getCopySrcRevision() != null ? Long.valueOf(changePath.getCopySrcRevision().getNumber()) : null);
        objectStatus.setCopyPath(changePath.getCopySrcPath());
        if (objectStatus.isFile()) {
            if (!StringUtilities.isNotEmpty(objectStatus.getStorableObjectName())) {
                String propertyName = null;
                if (localFile.exists()) {
                    propertyName = this.readPropertyName(localFile, objectStatus, revision);
                } else {
                    try {
                        if (!"D".equals(action)) {
                            propertyName = this.readPropertyName(new SVNUrl(this.repositoryUrl + svnPath), objectStatus, revision);
                        }
                    }
                    catch (MalformedURLException e) {
                        LOGGER.error(e);
                    }
                }
                if (StringUtilities.isNotEmpty(propertyName)) {
                    objectStatus.setStorableObjectName(propertyName);
                } else {
                    objectStatus.setStorableObjectName(svnPath);
                }
            }
        } else {
            objectStatus.setStorableObjectName(svnPath);
        }
        return objectStatus;
    }

    protected File resolveLocalFile(ISVNLogMessageChangePath changePath) {
        String svnFile = "";
        svnFile = this.svnDesignPath != null ? changePath.getPath().replace(this.svnDesignPath, "") : changePath.getPath();
        return new File(this.design.getDesignPath() + svnFile);
    }

    protected String readPropertyName(File file, SVNStorableObjectStatus storableObjectStatus, Long revision) {
        return SVN_CLIENT_HELPER.doGetProperty(file, 5);
    }

    protected String readPropertyName(SVNUrl url, SVNStorableObjectStatus storableObjectStatus, Long revision) {
        return SVN_CLIENT_HELPER.doGetProperty(url, 5, revision);
    }

    private class LogMessagesComparator
    implements Comparator<ISVNLogMessage> {
        private LogMessagesComparator() {
        }

        @Override
        public int compare(ISVNLogMessage logMessage1, ISVNLogMessage logMessage2) {
            if (logMessage1 instanceof LocalVersion) {
                return -1;
            }
            if (logMessage2 instanceof LocalVersion) {
                return 1;
            }
            return SVNHistoryWindow.this.getRevision(logMessage2).compareTo(SVNHistoryWindow.this.getRevision(logMessage1));
        }
    }

    private static class LocalVersion
    implements ISVNLogMessage {
        private LocalVersion() {
        }

        public SVNRevision.Number getRevision() {
            return null;
        }

        public String getAuthor() {
            return null;
        }

        public long getTimeMicros() {
            return 0L;
        }

        public long getTimeMillis() {
            return 0L;
        }

        public Date getDate() {
            return null;
        }

        public String getMessage() {
            return null;
        }

        public ISVNLogMessageChangePath[] getChangedPaths() {
            return null;
        }

        public long getNumberOfChildren() {
            return 0L;
        }

        public ISVNLogMessage[] getChildMessages() {
            return null;
        }

        public void addChild(ISVNLogMessage msg) {
        }

        public boolean hasChildren() {
            return false;
        }
    }
}

