/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.git;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.crest.fcp.vcs.git.GitClientHelper;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.net.URLFactory;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WelcomePanel;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITPostUpdate;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITRefSpec;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.wiz.GITPullBranchPanel;
import oracle.jdevimpl.vcs.git.wiz.GITPullRepositoryPanel;
import oracle.jdevimpl.vcs.git.wiz.GITPullSummaryPanel;
import oracle.jdevimpl.vcs.git.wiz.GITRemoteWizard;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitPullResult;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class DMGitPullWizard
extends GITRemoteWizard {
    static final String REMOTE_DEFAULT_CONFIG = "git.remote-default-config";
    static final String DEFAULT_CONFIG = "git.default-remote";
    static final String REMOTE_NAME = "git.remote-name";
    static final String REMOTE_URI = "git.remote-uri";
    static final String REMOTE_BRANCHES = "git.remote-branches";
    static final String LOCAL_ROOT_URL = "git.local-url";
    static final String USE_REMOTE_BRANCHES = "git.use-branches";
    static final String REMOTE_USERNAME = "git.username";
    static final String REMOTE_PASSWORD = "git.password";
    static final String REMOTE_KEY_FILE = "git.keyfile";
    static final String REMOTE_PASSPHRASE = "git.passphrase";
    static final String REMOTE_TAGS = "git.tags";
    private static final String F1_HELP_ID = "f1_git_pull_wizard_1_html";
    static final String MERGE_BRANCH = "git.mergebranch";
    static final String LOCAL_BRANCH = "git.localbranch";
    private Namespace ns;
    private WizardDialog wd;
    private GITPostUpdate _update;
    Map<File, GitClientHelper.FileDescriptor> updated;

    public DMGitPullWizard(GITPostUpdate update) {
        this._update = update;
    }

    public boolean runWizard(Component parent, Context context) throws Exception {
        FSMBuilder fsmBuilder = new FSMBuilder();
        Step welcomeStep = WelcomePanel.newStep((String)Resource.get((String)"WZ_PULL_NAME"), (String)Resource.get((String)"WZ_PULL_HEADER"), (String)Resource.get((String)"WZ_PULL_TEXT"), (String)"GitPullSkipNextTime", (String)F1_HELP_ID);
        fsmBuilder.newStartState(welcomeStep, (Object)"git.repository");
        Step step = new Step(Resource.get((String)"WZ_PULL_REPOSITORY"), GITPullRepositoryPanel.class);
        fsmBuilder.newState((Object)"git.repository", step, (Object)"git.branch");
        step = new Step(Resource.get((String)"WZ_PULL_BRANCH"), GITPullBranchPanel.class);
        fsmBuilder.newState((Object)"git.branch", step, (Object)"git.summary");
        step = new Step(Resource.get((String)"WZ_PULL_SUMMARY"), GITPullSummaryPanel.class);
        fsmBuilder.newFinalState((Object)"git.summary", step);
        try {
            FSM stateMachine = fsmBuilder.getFSM();
            this.ns = this.populate(context);
            if (this.ns == null) {
                return false;
            }
            FSMWizard wiz = new FSMWizard(stateMachine, this.ns);
            wiz.setWelcomePageAdded(true);
            wiz.setFinishPageAdded(true);
            wiz.setWizardTitle(Resource.get((String)"WZ_PULL_TITLE"));
            wiz.setRoadmapVisible(true);
            wiz.setHeaderGradientBackground(new Color[]{new Color(-1), new Color(-3219482)});
            this.wd = this.createWizardDialog(wiz, parent, context);
            if (WizardLauncher.runDialog((JDialog)this.wd)) {
                return true;
            }
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger((String)DMGitPullWizard.class.getName()).log(Level.WARNING, "Pull wizard", e.getMessage());
            throw new GITProcessException(Resource.get((String)"PROCESS_EXCEPTION_PULL_ERROR"), e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Namespace populate(Context context) throws Exception {
        Namespace ns = super.populate(context);
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient((URL)((URL)ns.get(LOCAL_ROOT_URL)));
            ns.put(LOCAL_BRANCH, (Object)GitClientHelper.getActiveBranch(client));
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return ns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean commitWizard(Context context) {
        WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
        wc.show();
        try {
            final Pair<Collection<File>, Collection<File>> result = this.runOperation();
            if (this._update != null) {
                this._update.postUpdate();
            }
            if (((Collection)result.getFirst()).isEmpty() && ((Collection)result.getSecond()).isEmpty()) {
                boolean bl = true;
                return bl;
            }
            if (!((Collection)result.getFirst()).isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GitClientHelper.reportMergeConflicts((Collection)result.getFirst());
                    }
                });
            }
            if (!((Collection)result.getSecond()).isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GitClientHelper.reportMergeFailures((Collection)result.getSecond());
                    }
                });
            }
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger((String)DMGitPullWizard.class.getName()).log(Level.WARNING, "Failed to commit import", e);
            this.getExceptionHandler().handleException(e, (Component)VCSWindowUtils.getCurrentWindow());
        }
        finally {
            wc.hide();
        }
        return false;
    }

    private Pair<Collection<File>, Collection<File>> runOperation() throws GITProcessException {
        String remoteUrl = (String)this.ns.get(REMOTE_URI);
        Map branches = (Map)this.ns.get(USE_REMOTE_BRANCHES);
        String mergeBranch = (String)this.ns.get(MERGE_BRANCH);
        URL localUrl = (URL)this.ns.get(LOCAL_ROOT_URL);
        String username = (String)this.ns.get(REMOTE_USERNAME);
        char[] passwd = (char[])this.ns.get(REMOTE_PASSWORD);
        String keyFile = (String)this.ns.get(REMOTE_KEY_FILE);
        char[] passPhrase = (char[])this.ns.get(REMOTE_PASSPHRASE);
        String remoteName = (String)this.ns.get(REMOTE_NAME);
        boolean restore = false;
        GitClient client = null;
        HashSet<File> reloadFiles = new HashSet<File>();
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get((String)"PULL_OPERATION"));
        final IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor((Component)IdeUtil.getMainWindow(), Resource.get((String)"WZ_PULL_PROGRESS"), (Object)Resource.format((String)"WZ_PULL_FROM_REPOS", (Object[])new Object[]{remoteUrl}), null);
        try {
            Collection conflicts;
            VCSCancellable cancellable = new VCSCancellable(){

                public boolean isCancelled() {
                    return progress.isCanceled();
                }
            };
            progress.start();
            client = GITClientAdaptor.getClient((URL)localUrl);
            monitor.setLog(true);
            monitor.setCancellable(cancellable);
            ArrayList<String> fetchSpec = new ArrayList<String>();
            for (String branch : branches.keySet()) {
                fetchSpec.add(GITRefSpec.getFetchSpec((String)branch.trim(), (String)((String)branches.get(branch)).trim()));
                if (!cancellable.isCancelled()) continue;
                Pair pair = new Pair(Collections.emptyList(), Collections.emptyList());
                return pair;
            }
            restore = GITUtil.authenticator((String)remoteUrl);
            GITClientAdaptor.setAuthentication((GitClient)client, (String)username, (char[])passwd, (String)keyFile, (char[])passPhrase);
            ApplicationView.log("Pull Start");
            GitPullResult result = client.pull(remoteUrl, fetchSpec, mergeBranch, (ProgressMonitor)monitor);
            if (cancellable.isCancelled()) {
                Pair pair = new Pair(Collections.emptyList(), Collections.emptyList());
                return pair;
            }
            Map localbranches = client.getBranches(false, (ProgressMonitor)monitor);
            GitBranch activeBranch = GITUtil.getActiveBranch((Map)localbranches);
            this.updated = this.getUpdatedFiles(client, monitor, result, activeBranch);
            if (this.updated != null && this.updated.size() > 0) {
                GitClientHelper.logUpdatedFiles(this.updated.values());
                reloadFiles.addAll(this.updated.keySet());
            }
            if ((conflicts = result.getMergeResult().getConflicts()) != null && conflicts.size() > 0) {
                reloadFiles.addAll(conflicts);
                List<GitStatus> list = GitClientHelper.getConflictsForFiles(conflicts.toArray(new File[0]));
                GitClientHelper.fixBrokenFiles(list);
            }
            GitClientHelper.logMergeConflicts(result.getMergeResult().getConflicts());
            reloadFiles.addAll(result.getMergeResult().getFailures());
            GitClientHelper.logMergeFailures(result.getMergeResult().getFailures());
            ApplicationView.log("Pull End");
            Pair pair = new Pair((Object)result.getMergeResult().getConflicts(), (Object)result.getMergeResult().getFailures());
            return pair;
        }
        catch (GitException.AuthorizationException e) {
            GITProfile.getQualifiedLogger((String)DMGitPullWizard.class.getName()).warning("Pull Auth " + e.getMessage());
            throw new GITProcessException(Resource.get((String)"WZ_PULL_FAILED"), e.getMessage());
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger((String)DMGitPullWizard.class.getName()).warning("Pull " + e.getMessage());
            throw new GITProcessException(Resource.get((String)"WZ_PULL_FAILED"), e.getMessage());
        }
        finally {
            this.connection(remoteUrl, remoteName, username, passwd, passPhrase);
            this.postUpdate(reloadFiles);
            progress.finish();
            GITUtil.authenricatorRestore((boolean)restore);
            monitor.logCompleted();
            if (client != null) {
                client.release();
            }
        }
    }

    protected Map<File, GitClientHelper.FileDescriptor> getUpdatedFiles(GitClient client, GITCommandProgressMonitor monitor, GitPullResult result, GitBranch activeBranch) throws GitException, GitException.MissingObjectException {
        GitTransportUpdate update;
        Map<File, GitClientHelper.FileDescriptor> updateFiles = null;
        Map fetched = result.getFetchResult();
        if (activeBranch == null) {
            for (String branch : fetched.keySet()) {
                GitTransportUpdate update2 = (GitTransportUpdate)fetched.get(branch);
                updateFiles = GitClientHelper.getModifiedFiles(client, update2.getOldObjectId(), update2.getNewObjectId(), monitor);
            }
        } else if (activeBranch.getTrackedBranch() != null && (update = (GitTransportUpdate)fetched.get(activeBranch.getTrackedBranch().getName())) != null) {
            updateFiles = GitClientHelper.getModifiedFiles(client, update.getOldObjectId(), update.getNewObjectId(), monitor);
        }
        return updateFiles;
    }

    private Collection<File> fileToUpdate(GitClient client, GITCommandProgressMonitor monitor, GitTransportUpdate update) throws GitException, GitException.MissingObjectException {
        return GITUtil.getModifiedFiles((GitClient)client, (String)update.getOldObjectId(), (String)update.getNewObjectId(), (GITCommandProgressMonitor)monitor);
    }

    private void postUpdate(Collection<File> reloadFiles) {
        if (reloadFiles.isEmpty()) {
            return;
        }
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
        final ArrayList<URL> urls = new ArrayList<URL>();
        if (this.updated != null && this.updated.size() > 0) {
            GitClientHelper.updateChangedDesigns(this.updated.values());
        }
        for (File file : reloadFiles) {
            urls.add(URLFactory.newFileURL((File)file));
        }
        profile.getPolicyStatusCache().clear(urls.toArray(new URL[0]));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                VCSBufferUtils.reloadBuffer((URL[])urls.toArray(new URL[0]));
            }
        });
    }
}

