/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.ChooseActionDialog;
import oracle.dbtools.crest.fcp.vcs.DeletedFile;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.Logger;

public class RestoreDeletedFilesDialog
extends ChooseActionDialog {
    private static final String ACTION_RESTORE = Messages.getString("RestoreDeletedFilesDialog.ActionRestore");
    private static final String ACTION_REMOVE = Messages.getString("RestoreDeletedFilesDialog.ActionRemove");
    private static final String[] ACTIONS = new String[]{ACTION_RESTORE, ACTION_REMOVE};
    private static final RestoreDeletedFilesDialog INSTANCE = new RestoreDeletedFilesDialog();
    private static final Logger LOGGER = new Logger(RestoreDeletedFilesDialog.class);
    private Map<DeletedFile, String> deletedFilesActions = new HashMap<DeletedFile, String>();

    public static RestoreDeletedFilesDialog getInstance() {
        return INSTANCE;
    }

    private List<DeletedFile> getDeletedFiles() {
        return ApplicationView.getInstance().getCurrentDesign().getDesignLevelSettings().getDeletedFiles();
    }

    @Override
    protected String getTitle() {
        return Messages.getString("RestoreDeletedFilesDialog.RestoreDeletedFiles");
    }

    @Override
    protected String[] getActions() {
        return ACTIONS;
    }

    @Override
    protected ActionListener getActionsActionListener() {
        return null;
    }

    @Override
    protected ChooseActionDialog.ActionsTableModel getActionsTableModel() {
        return new ChooseActionDialog.ActionsTableModel(){

            @Override
            public int getRowCount() {
                return RestoreDeletedFilesDialog.this.getDeletedFiles().size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (column == 0) {
                    return RestoreDeletedFilesDialog.this.getDeletedFiles().get(row).getLocalFile();
                }
                if (column == 1) {
                    String action = RestoreDeletedFilesDialog.this.deletedFilesActions.get(RestoreDeletedFilesDialog.this.getDeletedFiles().get(row));
                    if (action != null) {
                        return action;
                    }
                    this.setValueAt(ACTION_RESTORE, row, column);
                    return ACTION_RESTORE;
                }
                return super.getValueAt(row, column);
            }

            @Override
            public void setValueAt(Object action, int row, int column) {
                if (column == 1) {
                    DeletedFile deletedFile = RestoreDeletedFilesDialog.this.getDeletedFiles().get(row);
                    RestoreDeletedFilesDialog.this.deletedFilesActions.put(deletedFile, (String)action);
                } else {
                    super.setValueAt(action, row, column);
                }
            }
        };
    }

    @Override
    protected String getActionsTableModelFirstColumnName() {
        return Messages.getString("RestoreDeletedFilesDialog.DeletedFile");
    }

    @Override
    protected DefaultTableCellRenderer getActionsCellRenderer() {
        return null;
    }

    public void processDeletedFiles() {
        this.deletedFilesActions.clear();
        if (this.showDialog()) {
            ArrayList<VersioningTreeNode> nodesForRefreshing = new ArrayList<VersioningTreeNode>();
            boolean shouldSaveDesignLevelSettings = false;
            for (DeletedFile deletedFile : this.deletedFilesActions.keySet()) {
                String action = this.deletedFilesActions.get(deletedFile);
                if (ACTION_REMOVE.equals(action)) {
                    this.getDeletedFiles().remove(deletedFile);
                    shouldSaveDesignLevelSettings = true;
                    continue;
                }
                if (!ACTION_RESTORE.equals(action)) continue;
                StorableObjectStatus storableObjectStatus = deletedFile.getStorableObjectStatus();
                VCS_CLIENT_HELPER.doCopy(storableObjectStatus.getURL(), storableObjectStatus.getFilePath(), storableObjectStatus.getRevision());
                storableObjectStatus.setTextStatus("A");
                nodesForRefreshing.add(new VersioningTreeNode(storableObjectStatus));
                this.getDeletedFiles().remove(deletedFile);
                shouldSaveDesignLevelSettings = true;
            }
            if (!nodesForRefreshing.isEmpty()) {
                VersioningTreeNode.refresh(nodesForRefreshing, false, true);
            }
            if (shouldSaveDesignLevelSettings) {
                ApplicationView.getInstance().getCurrentDesign().saveDesignLevelSettings();
            }
        }
    }
}

