/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public class SearchPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_SEARCHPP";
    private static final String SEARCH_AS_U_TYPE = "search_as_u_type";
    private static final String SEARCH_AS_U_TYPE_START = "search_as_u_type_start";
    private static final String SEARCH_PROFILES_PATHS = "search_profiles_paths";

    protected SearchPreferences(HashStructure hash) {
        super(hash);
    }

    public static SearchPreferences getInstance(PropertyStorage prefs) {
        return new SearchPreferences(SearchPreferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public boolean isSearchAsUType() {
        return this._hash.getBoolean(SEARCH_AS_U_TYPE);
    }

    public void setSearchAsUType(boolean sut) {
        this._hash.putBoolean(SEARCH_AS_U_TYPE, sut);
    }

    public int getSearchAsUTypeStart() {
        return this._hash.getInt(SEARCH_AS_U_TYPE_START);
    }

    public void setSearchAsUTypeStart(int start) {
        this._hash.putInt(SEARCH_AS_U_TYPE_START, start);
    }

    public ListStructure getSearchProfilesPaths() {
        return this._hash.getListStructure(SEARCH_PROFILES_PATHS);
    }

    private boolean contains(String key) {
        return this._hash.containsKey(key);
    }

    public void loadToSettings(Settings settings) {
        if (this.contains(SEARCH_AS_U_TYPE)) {
            settings.setSearchAsUType(this.isSearchAsUType());
        }
        if (this.contains(SEARCH_AS_U_TYPE_START)) {
            settings.setSearchAsUTypeStart(this.getSearchAsUTypeStart());
        }
        settings.getSearchProfilesPaths().clear();
        ListStructure ld = this.getSearchProfilesPaths();
        if (ld != null) {
            for (String path : ld) {
                settings.getSearchProfilesPaths().add(path);
            }
        }
    }

    public void setSearchProfilesPaths(List list) {
        ListStructure ls = ListStructure.newInstance();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ls.add((Object)((String)it.next()));
        }
        this._hash.putListStructure(SEARCH_PROFILES_PATHS, ls);
    }

    public void loadFromSettings(Settings settings) {
        this.setSearchAsUType(settings.isSearchAsUType());
        this.setSearchAsUTypeStart(settings.getSearchAsUTypeStart());
        this.setSearchProfilesPaths(settings.getSearchProfilesPaths());
    }
}

