/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ControllerApplication;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class RecentDesignsPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_RecentDesigns";
    private static final String RECENT_DESIGNS = "recent_files";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);
    private List loadedRecents = new ArrayList();

    protected RecentDesignsPreferences(HashStructure hash) {
        super(hash);
    }

    public static RecentDesignsPreferences getInstance(PropertyStorage prefs) {
        return new RecentDesignsPreferences(RecentDesignsPreferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public void setRecentDesigns(List designs) {
        HashStructure hsBasic = HashStructure.newInstance();
        int counter = 0;
        Iterator it = designs.iterator();
        while (it.hasNext()) {
            ++counter;
            HashStructure hs = HashStructure.newInstance();
            ControllerApplication.Recent action = (ControllerApplication.Recent)it.next();
            String name = action.getDesignName();
            String path = action.getDesignPath();
            hs.putString("name", name);
            hs.putString("path", path);
            hsBasic.putHashStructure(Integer.toString(counter), hs);
        }
        this._hash.putHashStructure(RECENT_DESIGNS, hsBasic);
    }

    public HashStructure getRecentDesigns() {
        return this._hash.getHashStructure(RECENT_DESIGNS);
    }

    private boolean contains(String key) {
        return this._hash.containsKey(key);
    }

    public void loadToSettings(Settings settings, ApplicationView appView) {
        HashStructure hsBasic = this._hash.getHashStructure(RECENT_DESIGNS);
        if (hsBasic != null) {
            settings.getRecentDesigns().clear();
            this.loadedRecents.clear();
            ControllerApplication ca = appView.getController();
            Set stringKeys = hsBasic.keySet();
            TreeSet<Integer> integerKeys = new TreeSet<Integer>();
            Iterator it = stringKeys.iterator();
            while (it.hasNext()) {
                integerKeys.add(new Integer((String)it.next()));
            }
            for (Integer key : integerKeys) {
                HashStructure hs = hsBasic.getHashStructure(Integer.toString(key));
                String name = hs.getString("name");
                String path = hs.getString("path");
                if (!appView.getXMLTransformationManager().designExists(path, name)) continue;
                ControllerApplication.Recent action = new ControllerApplication.Recent(ca);
                action.setDesignName(name);
                action.setDesignPath(path);
                this.loadedRecents.add(action);
            }
        }
        for (MDBAction action : this.loadedRecents) {
            settings.addRecent(action);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }
}

