/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalDB2Preferences;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.panels.TraversableContext;

final class ModelPhysicalDB2PP
extends AbstractPP {
    private static final long serialVersionUID = -5060903693190187620L;
    private JTextField defaultDB2Owner;
    private JTextField defaultDB2Database;
    private JCheckBox chbNewStorageTemplatePerTS;
    private JCheckBox chbNewStorageTemplatePerIndex;
    private JCheckBox chbOneStorageTemplateForTS;
    private JCheckBox chbOneStorageTemplateForIndex;
    private JCheckBox chbNewTSPerTable;
    private JTextField namingRuleTablespaceDB2;
    private JTextField namingRuleStTablespaceDB2;
    private JButton btnAddVariable;
    private JTextField defaultTSStorageTemplateName;
    private JTextField defaultIndexStorageTemplateName;
    private JTextField namingRuleStIndexDB2;
    private static final String dialogName = Messages.getString("OptionsDialog.NameElementProvider");
    private JTextField defaultDB2TriggerName;
    private JTextField defaultDB2SequenceName;
    private JComboBox defaultDB2AutoIncDDL;
    private JComboBox defaultDB2IdentityDDL;
    private static final String NONE = Messages.getString("OptionsDialog.NONE");
    private static final String TRIGGER = Messages.getString("OptionsDialog.TRIGGER");
    private static final String IDENTITYClause = Messages.getString("OptionsDialog.IDENTITYClause");
    private static final String[] defaultAutoIncDDLChoices = new String[]{NONE, TRIGGER};
    private static final String[] defaultIdentityDDLChoices = new String[]{NONE, TRIGGER, IDENTITYClause};

    public ModelPhysicalDB2PP() {
        this.setHelpID("MODEL_PHYSICAL_DB2_PREFS_PANEL");
        JPanel pnTop = new JPanel(new GridBagLayout());
        pnTop.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.General")));
        JLabel label = new JLabel(Messages.getString("OptionsDialog.DefaultOwner"));
        label.setPreferredSize(new Dimension(200, 20));
        this.addItem(pnTop, label, 0, 0, 1, 1, 17, 0, 100);
        this.defaultDB2Owner = new JTextField();
        this.addItem(pnTop, this.defaultDB2Owner, 1, 0, 1, 1, 17, 100, 100);
        label = new JLabel(Messages.getString("OptionsDialog.DefaultDatabaseL"));
        this.addItem(pnTop, label, 0, 1, 1, 1, 17, 0, 100);
        this.defaultDB2Database = new JTextField();
        this.addItem(pnTop, this.defaultDB2Database, 1, 1, 1, 1, 17, 100, 100);
        this.chbNewTSPerTable = new JCheckBox(Messages.getString("OptionsDialog.CreateTableSpaceForEachTable"));
        this.addItem(pnTop, this.chbNewTSPerTable, 0, 2, 1, 1, 17, 0, 100);
        label = new JLabel(Messages.getString("OptionsDialog.NamingRule"), 0);
        this.addItem(pnTop, label, 0, 3, 1, 1, 17, 0, 100);
        this.namingRuleTablespaceDB2 = new JTextField();
        this.addItem(pnTop, this.namingRuleTablespaceDB2, 1, 3, 1, 1, 17, 100, 100);
        this.btnAddVariable = new JButton(Messages.getString("OptionsDialog.AddVariable"));
        this.addItem(pnTop, this.btnAddVariable, 2, 3, 1, 1, 17, 0, 100);
        this.btnAddVariable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[][] tablespaceName = new String[][]{{"{model}", Messages.getString("ModelPhysicaDB2PP.ModelName")}, {"{table}", Messages.getString("ModelPhysicaDB2PP.TableName")}};
                ModelPhysicalDB2PP.this.createDialog(tablespaceName, ModelPhysicalDB2PP.this.namingRuleTablespaceDB2);
            }
        });
        this.chbNewStorageTemplatePerTS = new JCheckBox(Messages.getString("OptionsDialog.CreateStorageTemplateForEachTableSpace"));
        this.addItem(pnTop, this.chbNewStorageTemplatePerTS, 0, 4, 1, 1, 17, 0, 100);
        this.chbNewStorageTemplatePerTS.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ModelPhysicalDB2PP.this.chbOneStorageTemplateForTS.setSelected(false);
                    ModelPhysicalDB2PP.this.defaultTSStorageTemplateName.setEnabled(false);
                }
            }
        });
        label = new JLabel(Messages.getString("OptionsDialog.NamingRule"), 0);
        this.addItem(pnTop, label, 0, 5, 1, 1, 17, 0, 100);
        this.namingRuleStTablespaceDB2 = new JTextField();
        this.addItem(pnTop, this.namingRuleStTablespaceDB2, 1, 5, 1, 1, 17, 100, 100);
        this.btnAddVariable = new JButton(Messages.getString("OptionsDialog.AddVariable"));
        this.addItem(pnTop, this.btnAddVariable, 2, 5, 1, 1, 17, 0, 100);
        this.btnAddVariable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[][] stTemplateName = new String[][]{{"{model}", Messages.getString("ModelPhysicaDB2PP.ModelName")}, {"{tablespace}", Messages.getString("ModelPhysicaDB2PP.TablespaceName")}};
                ModelPhysicalDB2PP.this.createDialog(stTemplateName, ModelPhysicalDB2PP.this.namingRuleStTablespaceDB2);
            }
        });
        this.chbOneStorageTemplateForTS = new JCheckBox(Messages.getString("OptionsDialog.UseOneStorageTemplateForTableSpaces"));
        this.addItem(pnTop, this.chbOneStorageTemplateForTS, 0, 6, 1, 1, 17, 0, 100);
        this.chbOneStorageTemplateForTS.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ModelPhysicalDB2PP.this.chbNewStorageTemplatePerTS.setSelected(false);
                    ModelPhysicalDB2PP.this.defaultTSStorageTemplateName.setEnabled(true);
                } else {
                    ModelPhysicalDB2PP.this.defaultTSStorageTemplateName.setEnabled(false);
                }
            }
        });
        label = new JLabel(Messages.getString("OptionsDialog.StorageTemplateName"), 0);
        this.addItem(pnTop, label, 0, 7, 1, 1, 17, 0, 100);
        this.defaultTSStorageTemplateName = new JTextField();
        this.defaultTSStorageTemplateName.setEnabled(false);
        this.addItem(pnTop, this.defaultTSStorageTemplateName, 1, 7, 1, 1, 17, 100, 100);
        this.chbNewStorageTemplatePerIndex = new JCheckBox(Messages.getString("OptionsDialog.CreateStorageTemplateForEachIndex"));
        this.addItem(pnTop, this.chbNewStorageTemplatePerIndex, 0, 8, 1, 1, 17, 0, 100);
        this.chbNewStorageTemplatePerIndex.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ModelPhysicalDB2PP.this.chbOneStorageTemplateForIndex.setSelected(false);
                    ModelPhysicalDB2PP.this.defaultIndexStorageTemplateName.setEnabled(false);
                }
            }
        });
        label = new JLabel(Messages.getString("OptionsDialog.NamingRule"), 0);
        this.addItem(pnTop, label, 0, 9, 1, 1, 17, 0, 100);
        this.namingRuleStIndexDB2 = new JTextField();
        this.addItem(pnTop, this.namingRuleStIndexDB2, 1, 9, 1, 1, 17, 100, 100);
        this.btnAddVariable = new JButton(Messages.getString("OptionsDialog.AddVariable"));
        this.addItem(pnTop, this.btnAddVariable, 2, 9, 1, 1, 17, 0, 100);
        this.btnAddVariable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[][] indexName = new String[][]{{"{model}", Messages.getString("ModelPhysicaDB2PP.ModelName")}, {"{index}", Messages.getString("ModelPhysicaDB2PP.IndexName")}};
                ModelPhysicalDB2PP.this.createDialog(indexName, ModelPhysicalDB2PP.this.namingRuleStIndexDB2);
            }
        });
        this.chbOneStorageTemplateForIndex = new JCheckBox(Messages.getString("OptionsDialog.UseOneStorageTemplateForIndexes"));
        this.addItem(pnTop, this.chbOneStorageTemplateForIndex, 0, 10, 1, 1, 17, 0, 100);
        this.chbOneStorageTemplateForIndex.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ModelPhysicalDB2PP.this.chbNewStorageTemplatePerIndex.setSelected(false);
                    ModelPhysicalDB2PP.this.defaultIndexStorageTemplateName.setEnabled(true);
                } else {
                    ModelPhysicalDB2PP.this.defaultIndexStorageTemplateName.setEnabled(false);
                }
            }
        });
        label = new JLabel(Messages.getString("OptionsDialog.StorageTemplateName"), 0);
        this.addItem(pnTop, label, 0, 11, 1, 1, 17, 0, 100);
        this.defaultIndexStorageTemplateName = new JTextField();
        this.addItem(pnTop, this.defaultIndexStorageTemplateName, 1, 11, 1, 1, 17, 100, 100);
        this.defaultIndexStorageTemplateName.setEnabled(false);
        JPanel pnAutoIncrementColumnTemplates = new JPanel(new GridBagLayout());
        pnAutoIncrementColumnTemplates.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.AutoIncrementColumnTemplates")));
        this.addItem(pnAutoIncrementColumnTemplates, new JLabel(Messages.getString("OptionsDialog.TriggerName")), 0, 0, 1, 1, 17, 0, 100);
        this.defaultDB2TriggerName = new JTextField();
        this.addItem(pnAutoIncrementColumnTemplates, this.defaultDB2TriggerName, 1, 0, 1, 1, 17, 100, 100);
        JButton btnAddVariable = new JButton(Messages.getString("OptionsDialog.AddVariable"));
        this.addItem(pnAutoIncrementColumnTemplates, btnAddVariable, 2, 0, 1, 1, 17, 0, 100);
        btnAddVariable.addActionListener(new AddVariableActionListener(this.defaultDB2TriggerName));
        this.addItem(pnAutoIncrementColumnTemplates, new JLabel(Messages.getString("OptionsDialog.SequenceName")), 0, 1, 1, 1, 17, 0, 100);
        this.defaultDB2SequenceName = new JTextField();
        this.addItem(pnAutoIncrementColumnTemplates, this.defaultDB2SequenceName, 1, 1, 1, 1, 17, 100, 100);
        btnAddVariable = new JButton(Messages.getString("OptionsDialog.AddVariable"));
        this.addItem(pnAutoIncrementColumnTemplates, btnAddVariable, 2, 1, 1, 1, 17, 0, 100);
        btnAddVariable.addActionListener(new AddVariableActionListener(this.defaultDB2SequenceName));
        this.addItem(pnAutoIncrementColumnTemplates, new JLabel(Messages.getString("OptionsDialog.DefaultAutoIncrementDDL")), 0, 2, 1, 1, 17, 0, 100);
        this.defaultDB2AutoIncDDL = new JComboBox<String>(defaultAutoIncDDLChoices);
        this.addItem(pnAutoIncrementColumnTemplates, this.defaultDB2AutoIncDDL, 1, 2, 1, 1, 17, 100, 100);
        this.addItem(pnAutoIncrementColumnTemplates, new JLabel(Messages.getString("OptionsDialog.DefaultIdentityDDL")), 0, 3, 1, 1, 17, 0, 100);
        this.defaultDB2IdentityDDL = new JComboBox<String>(defaultIdentityDDLChoices);
        this.addItem(pnAutoIncrementColumnTemplates, this.defaultDB2IdentityDDL, 1, 3, 1, 1, 17, 100, 100);
        this.add(pnTop, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
        this.add(pnAutoIncrementColumnTemplates, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    protected String translate(String value, String[] inputValues, String[] outputValues) {
        for (int i = 0; i < inputValues.length; ++i) {
            if (!inputValues[i].equals(value)) continue;
            return outputValues[i];
        }
        return "";
    }

    public void onEntry(TraversableContext tc) {
        this.defaultDB2Owner.setText(settings.getDefaultDB2Owner());
        this.defaultDB2Database.setText(settings.getDefaultDB2Database());
        this.namingRuleTablespaceDB2.setText(settings.getNamingRuleTablespaceDB2());
        this.namingRuleStTablespaceDB2.setText(settings.getNamingRuleStTablespaceDB2());
        this.namingRuleStIndexDB2.setText(settings.getNamingRuleStIndexDB2());
        this.chbNewTSPerTable.setSelected(settings.newDB2TableSpacePerTable());
        this.chbNewStorageTemplatePerTS.setSelected(settings.newDB2StorageTemplatePerTableSpace());
        this.chbNewStorageTemplatePerIndex.setSelected(settings.newDB2StorageTemplatePerIndex());
        this.chbOneStorageTemplateForTS.setSelected(settings.oneDB2StorageTemplatePerTS());
        this.chbOneStorageTemplateForIndex.setSelected(settings.oneDB2StorageTemplatePerIndex());
        if (this.chbOneStorageTemplateForTS.isSelected()) {
            this.defaultTSStorageTemplateName.setText(settings.getDefaultTSStorageTemplateName());
        }
        if (this.chbOneStorageTemplateForIndex.isSelected()) {
            this.defaultIndexStorageTemplateName.setText(settings.getDefaultIndexStorageTemplateName());
        }
        this.defaultDB2TriggerName.setText(settings.getDefaultDB2TriggerName());
        this.defaultDB2SequenceName.setText(settings.getDefaultDB2SequenceName());
        this.defaultDB2AutoIncDDL.setSelectedItem(this.translate(settings.getDefaultDB2AutoIncDDL(), Settings.AUTOINCREMENT_DDL_DB2, defaultAutoIncDDLChoices));
        this.defaultDB2IdentityDDL.setSelectedItem(this.translate(settings.getDefaultDB2IdentityDDL(), Settings.IDENTITY_DDL_DB2, defaultIdentityDDLChoices));
    }

    public void onExit(TraversableContext tc) {
        settings.setDefaultDB2Owner(this.defaultDB2Owner.getText());
        settings.setDefaultDB2Database(this.defaultDB2Database.getText());
        settings.setNamingRuleTablespaceDB2(this.namingRuleTablespaceDB2.getText());
        settings.setNamingRuleStTablespaceDB2(this.namingRuleStTablespaceDB2.getText());
        settings.setNamingRuleStIndexDB2(this.namingRuleStIndexDB2.getText());
        settings.setDefaultTSStorageTemplateName(this.defaultTSStorageTemplateName.getText());
        settings.setDefaultIndexStorageTemplateName(this.defaultIndexStorageTemplateName.getText());
        settings.setNewDB2TableSpacePerTable(this.chbNewTSPerTable.isSelected());
        settings.setNewDB2StorageTemplatePerTableSpace(this.chbNewStorageTemplatePerTS.isSelected());
        settings.setNewDB2StorageTemplatePerIndex(this.chbNewStorageTemplatePerIndex.isSelected());
        settings.setOneDB2StorageTemplatePerTS(this.chbOneStorageTemplateForTS.isSelected());
        settings.setOneDB2StorageTemplatePerIndex(this.chbOneStorageTemplateForIndex.isSelected());
        settings.setDefaultDB2TriggerName(this.defaultDB2TriggerName.getText());
        settings.setDefaultDB2SequenceName(this.defaultDB2SequenceName.getText());
        settings.setDefaultDB2AutoIncDDL(this.translate((String)this.defaultDB2AutoIncDDL.getSelectedItem(), defaultAutoIncDDLChoices, Settings.AUTOINCREMENT_DDL_DB2));
        settings.setDefaultDB2IdentityDDL(this.translate((String)this.defaultDB2IdentityDDL.getSelectedItem(), defaultIdentityDDLChoices, Settings.IDENTITY_DDL_DB2));
        ModelPhysicalDB2Preferences preferences = this.getModelPhysicalDB2Preferences(tc);
        preferences.setDefaultDB2Owner(this.defaultDB2Owner.getText());
        preferences.setDefaultDB2Database(this.defaultDB2Database.getText());
        preferences.setNamingRuleTablespaceDB2(this.namingRuleTablespaceDB2.getText());
        preferences.setNamingRuleStTablespaceDB2(this.namingRuleStTablespaceDB2.getText());
        preferences.setNamingRuleStIndexDB2(this.namingRuleStIndexDB2.getText());
        preferences.setDefaultTSStorageTemplateName(this.defaultTSStorageTemplateName.getText());
        preferences.setDefaultIndexStorageTemplateName(this.defaultIndexStorageTemplateName.getText());
        preferences.setNewTSPerTable(this.chbNewTSPerTable.isSelected());
        preferences.setNewStorageTemplatePerTS(this.chbNewStorageTemplatePerTS.isSelected());
        preferences.setNewStorageTemplatePerIndex(this.chbNewStorageTemplatePerIndex.isSelected());
        preferences.setOneStorageTemplateForTS(this.chbOneStorageTemplateForTS.isSelected());
        preferences.setOneStorageTemplateForIndex(this.chbOneStorageTemplateForIndex.isSelected());
        preferences.setDefaultDB2TriggerName(this.defaultDB2TriggerName.getText());
        preferences.setDefaultDB2SequenceName(this.defaultDB2SequenceName.getText());
        preferences.setDefaultDB2AutoIncDDL(settings.getDefaultDB2AutoIncDDL());
        preferences.setDefaultDB2IdentityDDL(settings.getDefaultDB2IdentityDDL());
    }

    private ModelPhysicalDB2Preferences getModelPhysicalDB2Preferences(TraversableContext tc) {
        return ModelPhysicalDB2Preferences.getInstance(tc.getPropertyStorage());
    }

    @Override
    protected String getDialogName() {
        return dialogName;
    }

    private class AddVariableActionListener
    implements ActionListener {
        private JTextField textField;

        private AddVariableActionListener(JTextField textField) {
            this.textField = textField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[][] tablespaceName = new String[][]{{"{table}", Messages.getString("ModelPhysicalDB2PP.TableName")}, {"{table abbr}", Messages.getString("ModelPhysicalDB2PP.TableAbbreviation")}, {"{column}", Messages.getString("ModelPhysicalDB2PP.ColumnName")}, {"{column abbr}", Messages.getString("ModelPhysicalDB2PP.ColumnAbbreviation")}};
            ModelPhysicalDB2PP.this.createDialog(tablespaceName, this.textField);
        }
    }
}

