/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.ModelPreferences;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.options.PreferredDomain;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.panels.TraversableContext;

final class ModelPP
extends AbstractPP {
    private static final long serialVersionUID = -3301108398757985657L;
    private JComboBox cbDefaultRDBMSSite;
    private JComboBox cbFKColumnOnNewFKOption;
    private JComboBox cbDefaultRDBMSType;
    private ButtonGroup columnDefaultdataTypeGroup = null;
    private JCheckBox chbNullsAllowed;
    private JCheckBox chbAlloSimilarTypesFK;
    private JTabbedPane tabbed;
    private DefaultListModel allLogicalTypesModel;
    private JList allLogicalTypesList;
    private JScrollPane allLogicalTypesScrollPane;
    private JButton buttonLogicalTypeAdd;
    private JButton buttonLogicalTypeRemove;
    private DefaultListModel preferredLogicalTypesModel;
    private JList preferredLogicalTypesList;
    private JScrollPane preferredLogicalTypesScrollPane;
    private JScrollPane allDomainsScrollPane;
    private JButton buttonDomainAdd;
    private JButton buttonDomainRemove;
    private JScrollPane preferredDomainsScrollPane;
    private JPanel allDomainsTablePanel;
    private JTable allDomainsTable;
    private JTable preferredDomainsTable;
    private List<PreferredDomain> allDomainsContainerList;
    private List<PreferredDomain> preferredDomainsContainerList;
    private boolean addToAllDomains = false;
    private List<PreferredDomain> designLevelPreferredDomainsList;
    private JPanel mainPanel;
    private JPanel northPanel;
    private GUIConfiguration configuration;
    private static String[] newFKChoices = new String[]{Messages.getString("OptionsDialog.ExistingByTemplate"), oracle.dbtools.crest.model.Messages.getString("ModelIdObjectSelection.NewColumn")};

    public ModelPP() {
        this.setHelpID("MODEL_PREFS_PANEL");
        this.mainPanel = new JPanel(new GridBagLayout());
        this.northPanel = new JPanel(new GridBagLayout());
        this.configuration = GUIConfiguration.getInstance();
        this.createRDBMSPanel();
        this.createColumnDefaultsPanel();
        JPanel allowSimTypesPanel = new JPanel(new GridBagLayout());
        allowSimTypesPanel.setBorder(BorderFactory.createTitledBorder(oracle.dbtools.crest.model.Messages.getString("ImpA_FKAssociation.FKColumns")));
        String hint = Messages.getString("OptionsDialog.AllowSimilarTypesFKHint");
        this.chbAlloSimilarTypesFK = new JCheckBox(Messages.getString("OptionsDialog.AllowSimilarTypesFK"));
        this.chbAlloSimilarTypesFK.setToolTipText(hint);
        allowSimTypesPanel.add((Component)this.chbAlloSimilarTypesFK, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel pnNewFKColumn = new JPanel(new GridBagLayout());
        JLabel lbNewFK = new JLabel(Messages.getString("OptionsDialog.OnNewForeignkey"));
        lbNewFK.setPreferredSize(new Dimension(150, 20));
        this.cbFKColumnOnNewFKOption = new JComboBox<String>(newFKChoices);
        pnNewFKColumn.add((Component)lbNewFK, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnNewFKColumn.add((Component)this.cbFKColumnOnNewFKOption, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnNewFKColumn.add((Component)new JLabel(" "), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setBG(this.cbFKColumnOnNewFKOption);
        allowSimTypesPanel.add((Component)pnNewFKColumn, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel southPanel = new JPanel(new GridBagLayout());
        southPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.PreferredDomainsLT")));
        this.tabbed = new JTabbedPane();
        this.createPreferredLogicalTypesPanel(this.tabbed);
        this.createPreferredDomainsPanel(this.tabbed);
        southPanel.add((Component)this.tabbed, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.northPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)allowSimTypesPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)southPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void onEntry(TraversableContext tc) {
        RDBMSSite site;
        RDBMSType type;
        this.cbDefaultRDBMSType.removeAllItems();
        Iterator items = Design.getDefaultRDBMSTypeSet().iterator();
        while (items.hasNext()) {
            type = (RDBMSType)items.next();
            this.cbDefaultRDBMSType.addItem(type);
        }
        this.cbDefaultRDBMSSite.removeAllItems();
        items = this.getCurrentDesign().getRDBMSSiteSet().iterator();
        while (items.hasNext()) {
            site = (RDBMSSite)items.next();
            this.cbDefaultRDBMSSite.addItem(site);
        }
        this.cbDefaultRDBMSType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ModelPP.this.cbDefaultRDBMSType.getSelectedItem() != null) {
                    RDBMSSite[] allSites = (RDBMSSite[])ModelPP.this.getCurrentDesign().getRDBMSSiteSet().toArray();
                    ModelPP.this.cbDefaultRDBMSSite.removeAllItems();
                    for (int i = 0; i < allSites.length; ++i) {
                        RDBMSSite siteItem = allSites[i];
                        if (!siteItem.getType().getName().equals(ModelPP.this.cbDefaultRDBMSType.getSelectedItem().toString())) continue;
                        ModelPP.this.cbDefaultRDBMSSite.addItem(siteItem);
                    }
                }
            }
        });
        type = Design.getDefaultRDBMSTypeSet().get(settings.getDefaultRDBMSType());
        site = this.getCurrentDesign().getRDBMSSiteSet().getDefaultRDBMSSite(settings);
        this.cbDefaultRDBMSType.setSelectedItem(type);
        this.cbDefaultRDBMSSite.setSelectedItem(site);
        this.chbNullsAllowed.setSelected(settings.getNullsAllowed());
        this.chbAlloSimilarTypesFK.setSelected(settings.isAllowSimilarTypesFK());
        if (settings.getFkColumnOnNewFKOption() == Settings.ON_NEW_FK_EXIST_BY_TEMPLATE) {
            this.cbFKColumnOnNewFKOption.setSelectedItem(newFKChoices[0]);
        } else {
            this.cbFKColumnOnNewFKOption.setSelectedItem(newFKChoices[1]);
        }
        Enumeration<AbstractButton> columnDefaultdataTypeGroupEnumeration = this.columnDefaultdataTypeGroup.getElements();
        while (columnDefaultdataTypeGroupEnumeration.hasMoreElements()) {
            JRadioButton rb = (JRadioButton)columnDefaultdataTypeGroupEnumeration.nextElement();
            if (!rb.getText().trim().equalsIgnoreCase(settings.getColumnDefaultDatatype().trim())) continue;
            rb.setSelected(true);
        }
        this.allLogicalTypesModel.clear();
        this.preferredLogicalTypesModel.clear();
        Iterator it = this.getCurrentDesign().getLogicalDatatypeSet().iterator();
        while (it.hasNext()) {
            LogicalDatatype lt0 = (LogicalDatatype)it.next();
            List<LogicalDatatype> settingsPreferredLogicalTypesList = settings.getPreferredLogicaltypes();
            if (settingsPreferredLogicalTypesList.size() > 0) {
                for (LogicalDatatype lt1 : settingsPreferredLogicalTypesList) {
                    if (!lt0.getObjectID().equalsIgnoreCase(lt1.getObjectID())) {
                        if (this.allLogicalTypesModel.contains(lt0) || this.preferredLogicalTypesModel.contains(lt0)) continue;
                        this.allLogicalTypesModel.addElement(lt0);
                        continue;
                    }
                    this.preferredLogicalTypesModel.addElement(lt0);
                    if (!this.allLogicalTypesModel.contains(lt0)) continue;
                    this.allLogicalTypesModel.removeElement(lt0);
                }
                continue;
            }
            this.allLogicalTypesModel.addElement(lt0);
        }
        this.preferredDomainsContainerList.clear();
        this.allDomainsContainerList.clear();
        List<PreferredDomain> settingsPreferreddomainsList = settings.getPreferredDomains();
        Iterator allDesignDomainsDesignIterator = this.getCurrentDesign().getDomainSet().iterator();
        while (allDesignDomainsDesignIterator.hasNext()) {
            Domain obj = (Domain)allDesignDomainsDesignIterator.next();
            PreferredDomain pd0 = new PreferredDomain();
            pd0.setObjectId(obj.getObjectID());
            pd0.setName(obj.getName());
            pd0.setFileName(obj.getFileName());
            if (settingsPreferreddomainsList.size() > 0) {
                for (PreferredDomain pd : settingsPreferreddomainsList) {
                    if (!pd0.getObjectId().equalsIgnoreCase(pd.getObjectId())) {
                        if (this.allDomainsContainerList.contains(pd0) || this.preferredDomainsContainerList.contains(pd0)) continue;
                        this.allDomainsContainerList.add(pd0);
                        continue;
                    }
                    this.preferredDomainsContainerList.add(pd0);
                    if (!this.allDomainsContainerList.contains(pd0)) continue;
                    this.allDomainsContainerList.remove(pd0);
                }
                continue;
            }
            this.allDomainsContainerList.add(pd0);
        }
        this.designLevelPreferredDomainsList = new ArrayList<PreferredDomain>();
        block7: for (PreferredDomain pd : settingsPreferreddomainsList) {
            for (PreferredDomain pd0 : this.preferredDomainsContainerList) {
                if (!pd0.getObjectId().equalsIgnoreCase(pd.getObjectId())) {
                    if (this.designLevelPreferredDomainsList.contains(pd)) continue;
                    this.designLevelPreferredDomainsList.add(pd);
                    continue;
                }
                if (!this.designLevelPreferredDomainsList.contains(pd)) continue block7;
                this.designLevelPreferredDomainsList.remove(pd);
                continue block7;
            }
        }
        this.preferredDomainsTable.updateUI();
        this.allDomainsTable.updateUI();
    }

    public void onExit(TraversableContext tc) {
        ModelPreferences preferences = this.getModelPreferences(tc);
        settings.setDefaultRDBMSType(((RDBMSType)this.cbDefaultRDBMSType.getSelectedItem()).getType());
        settings.setDefaultRDBMSSite(((RDBMSSite)this.cbDefaultRDBMSSite.getSelectedItem()).getObjectID());
        settings.setNullsAllowed(this.chbNullsAllowed.isSelected());
        settings.setAllowSimilarTypesFK(this.chbAlloSimilarTypesFK.isSelected());
        if (this.cbFKColumnOnNewFKOption.getSelectedItem().equals(newFKChoices[0])) {
            settings.setFkColumnOnNewFKOption(Settings.ON_NEW_FK_EXIST_BY_TEMPLATE);
            preferences.setFKColumnOnNewOption(Settings.ON_NEW_FK_EXIST_BY_TEMPLATE);
        } else {
            settings.setFkColumnOnNewFKOption(Settings.ON_NEW_FK_NEW_COLUMN);
            preferences.setFKColumnOnNewOption(Settings.ON_NEW_FK_NEW_COLUMN);
        }
        preferences.setDefaultRDBMSType(((RDBMSType)this.cbDefaultRDBMSType.getSelectedItem()).getType());
        preferences.setDefaultRDBMSSite(((RDBMSSite)this.cbDefaultRDBMSSite.getSelectedItem()).getObjectID());
        preferences.setNullsAllowed(this.chbNullsAllowed.isSelected());
        preferences.setAllowSimilarTypesFK(this.chbAlloSimilarTypesFK.isSelected());
        Enumeration<AbstractButton> columnDefaultdataTypeGroupEnumeration = this.columnDefaultdataTypeGroup.getElements();
        while (columnDefaultdataTypeGroupEnumeration.hasMoreElements()) {
            JRadioButton rb = (JRadioButton)columnDefaultdataTypeGroupEnumeration.nextElement();
            if (!rb.isSelected()) continue;
            settings.setColumnDefaultDatatype(rb.getText());
            preferences.setColumnDefaultDatatype(rb.getText());
        }
        settings.getPreferredLogicaltypes().clear();
        ArrayList<LogicalDatatype> prefTypes = new ArrayList<LogicalDatatype>();
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < this.preferredLogicalTypesList.getModel().getSize(); ++i) {
            LogicalDatatype item = (LogicalDatatype)this.preferredLogicalTypesList.getModel().getElementAt(i);
            al.add(item.getObjectID());
            prefTypes.add(item);
        }
        settings.setPreferredLogicaltypes(al);
        preferences.setPreferredLogicaltypes(prefTypes);
        settings.getPreferredDomains().clear();
        ArrayList<PreferredDomain> dom = new ArrayList<PreferredDomain>();
        for (int i = 0; i < this.preferredDomainsContainerList.size(); ++i) {
            PreferredDomain item = this.preferredDomainsContainerList.get(i);
            dom.add(item);
        }
        dom.addAll(this.designLevelPreferredDomainsList);
        settings.setPreferredDomains(dom);
        preferences.setPreferredDomains(dom);
        ArrayList<Domain> dom1 = new ArrayList<Domain>();
        for (int i = 0; i < this.preferredDomainsContainerList.size(); ++i) {
            PreferredDomain item = this.preferredDomainsContainerList.get(i);
            Iterator allDesignDomainsDesignIterator = this.getCurrentDesign().getDomainSet().iterator();
            while (allDesignDomainsDesignIterator.hasNext()) {
                Domain obj = (Domain)allDesignDomainsDesignIterator.next();
                if (!item.getObjectId().equalsIgnoreCase(obj.getObjectID())) continue;
                dom1.add(obj);
            }
        }
        settings.setPrefDomains(dom1);
    }

    private void createRDBMSPanel() {
        JPanel rdbmsPanel = new JPanel(new GridBagLayout());
        rdbmsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.RDBMSSettings")));
        this.initDefaultRDBMSType(rdbmsPanel);
        this.initDefaultRDBMSSite(rdbmsPanel);
        this.getApplicationView();
        if (!ApplicationView.IS_VIEWER) {
            this.northPanel.add((Component)rdbmsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private void initDefaultRDBMSType(JPanel rdbmsPanel) {
        JLabel label = new JLabel(Messages.getString("OptionsDialog.DefaultRDBMSType"));
        label.setPreferredSize(new Dimension(150, 20));
        this.cbDefaultRDBMSType = new JComboBox();
        this.cbDefaultRDBMSType.setMaximumRowCount(20);
        rdbmsPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        rdbmsPanel.add((Component)this.cbDefaultRDBMSType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        rdbmsPanel.add((Component)new JLabel(" "), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setBG(this.cbDefaultRDBMSType);
    }

    private void initDefaultRDBMSSite(JPanel rdbmsPanel) {
        JLabel label = new JLabel(Messages.getString("OptionsDialog.DefaultRDBMSSite"));
        label.setPreferredSize(new Dimension(150, 20));
        this.cbDefaultRDBMSSite = new JComboBox();
        this.cbDefaultRDBMSSite.setMaximumRowCount(20);
        rdbmsPanel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        rdbmsPanel.add((Component)this.cbDefaultRDBMSSite, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setBG(this.cbDefaultRDBMSSite);
    }

    private void createColumnDefaultsPanel() {
        JPanel colPanel = new JPanel(new GridBagLayout());
        colPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.ColumnsAttributesDefaults")));
        this.chbNullsAllowed = new JCheckBox(Messages.getString("OptionsDialog.NullsAllowed"));
        this.addItem(colPanel, this.chbNullsAllowed, 0, 0, 2, 1, 17, 0, 1);
        this.addItem(colPanel, new JLabel(""), 2, 0, 1, 1, 17, 1, 1);
        this.initColumnDataType(colPanel);
        this.northPanel.add((Component)colPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, -1));
    }

    private void initColumnDataType(JPanel colPanel) {
        JLabel dtColumn = new JLabel(Messages.getString("OptionsDialog.Datatype"));
        JRadioButton rbDomain = new JRadioButton(Messages.getString("OptionsDialog.Domain"));
        JRadioButton rbLogical = new JRadioButton(Messages.getString("OptionsDialog.Logical"));
        JRadioButton rbDistinct = new JRadioButton(Messages.getString("OptionsDialog.Distinct"));
        JRadioButton rbStructured = new JRadioButton(Messages.getString("OptionsDialog.Structured"));
        JRadioButton rbCollection = new JRadioButton(Messages.getString("OptionsDialog.Collection"));
        rbDomain.setSelected(true);
        this.columnDefaultdataTypeGroup = new ButtonGroup();
        this.columnDefaultdataTypeGroup.add(rbDomain);
        this.columnDefaultdataTypeGroup.add(rbLogical);
        this.columnDefaultdataTypeGroup.add(rbDistinct);
        this.columnDefaultdataTypeGroup.add(rbStructured);
        this.columnDefaultdataTypeGroup.add(rbCollection);
        JPanel pnRadioGroup = new JPanel(new FlowLayout(0));
        pnRadioGroup.add(rbDomain);
        pnRadioGroup.add(rbLogical);
        pnRadioGroup.add(rbDistinct);
        pnRadioGroup.add(rbStructured);
        pnRadioGroup.add(rbCollection);
        this.addItem(colPanel, dtColumn, 0, 1, 1, 1, 17, 0, 100);
        this.addItem(colPanel, pnRadioGroup, 1, 1, 1, 1, 17, 0, 100);
    }

    private void createPreferredDomainsPanel(JTabbedPane main) {
        JPanel cPanel = new JPanel(new GridBagLayout());
        JPanel plPanel = new JPanel(new GridBagLayout());
        this.initAllDomains(plPanel);
        this.initPreferredDomainsAddRemoveButtons(plPanel);
        this.initPreferredDomains(plPanel);
        cPanel.add((Component)plPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        main.add(Messages.getString("OptionsDialog.PreferredDomains"), cPanel);
    }

    private void initAllDomains(JPanel containerPanel) {
        this.allDomainsTablePanel = new JPanel(new GridBagLayout());
        this.allDomainsTablePanel.setPreferredSize(new Dimension(100, 100));
        this.allDomainsTablePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.AllDomains")));
        this.allDomainsContainerList = new ArrayList<PreferredDomain>();
        this.allDomainsTable = new JTable(new AllDomainsTableModel());
        this.allDomainsScrollPane = new JScrollPane(this.allDomainsTable);
        this.allDomainsTablePanel.add((Component)this.allDomainsScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.allDomainsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ModelPP.this.allDomainsTable.getSelectedRow() == -1) {
                    ModelPP.this.buttonDomainAdd.setEnabled(false);
                } else {
                    ModelPP.this.buttonDomainAdd.setEnabled(true);
                }
            }
        });
        this.allDomainsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ModelPP.this.buttonDomainAdd.doClick();
                }
            }
        });
        Iterator it = this.getCurrentDesign().getDomainSet().iterator();
        while (it.hasNext()) {
            Domain obj = (Domain)it.next();
            PreferredDomain pd = new PreferredDomain();
            pd.setObjectId(obj.getObjectID());
            pd.setName(obj.getName());
            pd.setFileName(obj.getFileName());
            this.allDomainsContainerList.add(pd);
        }
        containerPanel.add((Component)this.allDomainsTablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initPreferredDomains(JPanel containerPanel) {
        this.preferredDomainsContainerList = new ArrayList<PreferredDomain>();
        this.preferredDomainsTable = new JTable(new PreferredDomainsTableModel());
        JPanel preferredDomainsTablePanel = new JPanel(new GridBagLayout());
        preferredDomainsTablePanel.setPreferredSize(new Dimension(100, 100));
        preferredDomainsTablePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.PreferredDomains")));
        this.preferredDomainsScrollPane = new JScrollPane(this.preferredDomainsTable);
        preferredDomainsTablePanel.add((Component)this.preferredDomainsScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.preferredDomainsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ModelPP.this.preferredDomainsTable.getSelectedRow() == -1) {
                    ModelPP.this.buttonDomainRemove.setEnabled(false);
                } else {
                    ModelPP.this.buttonDomainRemove.setEnabled(true);
                }
            }
        });
        this.preferredDomainsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ModelPP.this.buttonDomainRemove.doClick();
                }
            }
        });
        containerPanel.add((Component)preferredDomainsTablePanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initPreferredDomainsAddRemoveButtons(JPanel containerPanel) {
        this.buttonDomainAdd = new JButton(this.configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonDomainAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonDomainAdd.addActionListener(new AddToPreferredDomains());
        this.buttonDomainAdd.setEnabled(false);
        this.buttonDomainAdd.setToolTipText(Messages.getString("OptionsDialog.Add"));
        this.buttonDomainRemove = new JButton(this.configuration.getIcon("MOVE_LEFT_ICON"));
        this.buttonDomainRemove.setPreferredSize(new Dimension(32, 32));
        this.buttonDomainRemove.setEnabled(false);
        this.buttonDomainRemove.addActionListener(new RemoveFromPreferredDomains());
        this.buttonDomainRemove.setToolTipText(Messages.getString("OptionsDialog.Remove"));
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(this.buttonDomainAdd);
        verticalBox.add(this.buttonDomainRemove);
        verticalBox.add(Box.createVerticalGlue());
        containerPanel.add((Component)verticalBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void createPreferredLogicalTypesPanel(JTabbedPane main) {
        JPanel cPanel = new JPanel(new GridBagLayout());
        JPanel plPanel = new JPanel(new GridBagLayout());
        this.initAllLogicalTypes(plPanel);
        this.initPreferredLogicalTypesAddRemoveButtons(plPanel);
        this.initPreferredLogicalTypes(plPanel);
        cPanel.add((Component)plPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        main.add(Messages.getString("OptionsDialog.PreferredLogicalTypes"), cPanel);
    }

    private void initAllLogicalTypes(JPanel containerPanel) {
        JPanel allLogicalTypesListPanel = new JPanel(new GridBagLayout());
        allLogicalTypesListPanel.setPreferredSize(new Dimension(100, 100));
        allLogicalTypesListPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.AllLogicalTypes")));
        this.allLogicalTypesModel = new DefaultListModel();
        this.allLogicalTypesList = new JList(this.allLogicalTypesModel);
        this.allLogicalTypesScrollPane = new JScrollPane(this.allLogicalTypesList);
        allLogicalTypesListPanel.add((Component)this.allLogicalTypesScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.allLogicalTypesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ModelPP.this.allLogicalTypesList.getSelectedIndex() == -1) {
                    ModelPP.this.buttonLogicalTypeAdd.setEnabled(false);
                } else {
                    ModelPP.this.buttonLogicalTypeAdd.setEnabled(true);
                }
            }
        });
        this.allLogicalTypesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ModelPP.this.buttonLogicalTypeAdd.doClick();
                }
            }
        });
        Iterator it = this.getCurrentDesign().getLogicalDatatypeSet().iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            this.allLogicalTypesModel.addElement(obj);
        }
        containerPanel.add((Component)allLogicalTypesListPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initPreferredLogicalTypes(JPanel containerPanel) {
        JPanel preferredLogicalTypesListPanel = new JPanel(new GridBagLayout());
        preferredLogicalTypesListPanel.setPreferredSize(new Dimension(100, 100));
        preferredLogicalTypesListPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.PreferredLogicalTypes")));
        this.preferredLogicalTypesModel = new DefaultListModel();
        this.preferredLogicalTypesList = new JList(this.preferredLogicalTypesModel);
        this.preferredLogicalTypesScrollPane = new JScrollPane(this.preferredLogicalTypesList);
        preferredLogicalTypesListPanel.add((Component)this.preferredLogicalTypesScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.preferredLogicalTypesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ModelPP.this.preferredLogicalTypesList.getSelectedIndex() == -1) {
                    ModelPP.this.buttonLogicalTypeRemove.setEnabled(false);
                } else {
                    ModelPP.this.buttonLogicalTypeRemove.setEnabled(true);
                }
            }
        });
        this.preferredLogicalTypesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ModelPP.this.buttonLogicalTypeRemove.doClick();
                }
            }
        });
        containerPanel.add((Component)preferredLogicalTypesListPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initPreferredLogicalTypesAddRemoveButtons(JPanel containerPanel) {
        this.buttonLogicalTypeAdd = new JButton(this.configuration.getIcon("MOVE_RIGHT_ICON"));
        this.buttonLogicalTypeAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonLogicalTypeAdd.addActionListener(new AddToPreferredLogicalTypes());
        this.buttonLogicalTypeAdd.setEnabled(false);
        this.buttonLogicalTypeAdd.setToolTipText(Messages.getString("OptionsDialog.Add"));
        this.buttonLogicalTypeRemove = new JButton(this.configuration.getIcon("MOVE_LEFT_ICON"));
        this.buttonLogicalTypeRemove.setPreferredSize(new Dimension(32, 32));
        this.buttonLogicalTypeRemove.setEnabled(false);
        this.buttonLogicalTypeRemove.addActionListener(new RemoveFromPreferredLogicalTypes());
        this.buttonLogicalTypeRemove.setToolTipText(Messages.getString("OptionsDialog.Remove"));
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(this.buttonLogicalTypeAdd);
        verticalBox.add(this.buttonLogicalTypeRemove);
        verticalBox.add(Box.createVerticalGlue());
        containerPanel.add((Component)verticalBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public DefaultListModel sort(DefaultListModel list) {
        for (int k = 0; k < list.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                if (list.get(i).toString().compareTo(list.get(i - 1).toString()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private ModelPreferences getModelPreferences(TraversableContext tc) {
        return ModelPreferences.getInstance(tc.getPropertyStorage());
    }

    private class RemoveFromPreferredLogicalTypes
    implements ActionListener {
        private RemoveFromPreferredLogicalTypes() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = ModelPP.this.preferredLogicalTypesList.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                if (ModelPP.this.allLogicalTypesModel.contains(selected[i])) continue;
                ModelPP.this.preferredLogicalTypesModel.removeElement(selected[i]);
                ModelPP.this.allLogicalTypesModel.addElement(selected[i]);
            }
            ModelPP.this.sort(ModelPP.this.allLogicalTypesModel);
        }
    }

    private class AddToPreferredLogicalTypes
    implements ActionListener {
        private AddToPreferredLogicalTypes() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = ModelPP.this.allLogicalTypesList.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                if (ModelPP.this.preferredLogicalTypesModel.contains(selected[i])) continue;
                ModelPP.this.preferredLogicalTypesModel.addElement(selected[i]);
                ModelPP.this.allLogicalTypesModel.removeElement(selected[i]);
            }
            ModelPP.this.sort(ModelPP.this.preferredLogicalTypesModel);
        }
    }

    private class PreferredDomainsTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("OptionsDialog.Name"), Messages.getString("OptionsDialog.File")};

        private PreferredDomainsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return ModelPP.this.preferredDomainsContainerList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            PreferredDomain domain = ModelPP.this.preferredDomainsContainerList.get(row);
        }

        @Override
        public Object getValueAt(int row, int col) {
            PreferredDomain domain = ModelPP.this.preferredDomainsContainerList.get(row);
            if (col == 0) {
                return domain.getName();
            }
            if (col == 1) {
                return domain.getFileName();
            }
            return "";
        }
    }

    private class AllDomainsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1669068155779350823L;
        final String[] COL_NAMES = new String[]{Messages.getString("OptionsDialog.Name"), Messages.getString("OptionsDialog.File")};

        private AllDomainsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return ModelPP.this.allDomainsContainerList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            PreferredDomain domain = ModelPP.this.allDomainsContainerList.get(row);
        }

        @Override
        public Object getValueAt(int row, int col) {
            PreferredDomain domain = ModelPP.this.allDomainsContainerList.get(row);
            if (col == 0) {
                return domain.getName();
            }
            if (col == 1) {
                return domain.getFileName();
            }
            return "";
        }
    }

    private class RemoveFromPreferredDomains
    implements ActionListener {
        private RemoveFromPreferredDomains() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i1 = -1;
            int i2 = -1;
            int[] selected = ModelPP.this.preferredDomainsTable.getSelectedRows();
            ArrayList<PreferredDomain> removeList = new ArrayList<PreferredDomain>();
            for (int i = 0; i < selected.length; ++i) {
                PreferredDomain current = ModelPP.this.preferredDomainsContainerList.get(selected[i]);
                if (ModelPP.this.allDomainsContainerList.size() > 0) {
                    for (PreferredDomain pd : ModelPP.this.allDomainsContainerList) {
                        if (!current.getObjectId().equalsIgnoreCase(pd.getObjectId())) {
                            ModelPP.this.addToAllDomains = true;
                            continue;
                        }
                        ModelPP.this.allDomainsContainerList.remove(current);
                        ModelPP.this.addToAllDomains = false;
                        break;
                    }
                } else {
                    ModelPP.this.addToAllDomains = true;
                }
                if (ModelPP.this.addToAllDomains) {
                    ModelPP.this.allDomainsContainerList.add(current);
                    removeList.add(current);
                    ModelPP.this.addToAllDomains = false;
                    if (i1 == -1) {
                        i1 = ModelPP.this.allDomainsContainerList.lastIndexOf(current);
                    }
                }
                i2 = ModelPP.this.allDomainsContainerList.lastIndexOf(current);
            }
            ModelPP.this.allDomainsTable.setRowSelectionInterval(i1, i2);
            ModelPP.this.allDomainsTable.updateUI();
            ModelPP.this.preferredDomainsTable.clearSelection();
            ModelPP.this.preferredDomainsContainerList.removeAll(removeList);
            ModelPP.this.preferredDomainsTable.updateUI();
        }
    }

    private class AddToPreferredDomains
    implements ActionListener {
        private AddToPreferredDomains() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i1 = -1;
            int i2 = -1;
            int[] selected = ModelPP.this.allDomainsTable.getSelectedRows();
            ArrayList<PreferredDomain> removeList = new ArrayList<PreferredDomain>();
            for (int i = 0; i < selected.length; ++i) {
                PreferredDomain current = ModelPP.this.allDomainsContainerList.get(selected[i]);
                if (!ModelPP.this.preferredDomainsContainerList.contains(current)) {
                    ModelPP.this.preferredDomainsContainerList.add(current);
                    removeList.add(current);
                    if (i1 == -1) {
                        i1 = ModelPP.this.preferredDomainsContainerList.lastIndexOf(current);
                    }
                }
                i2 = ModelPP.this.preferredDomainsContainerList.lastIndexOf(current);
            }
            ModelPP.this.allDomainsContainerList.removeAll(removeList);
            ModelPP.this.allDomainsTable.clearSelection();
            ModelPP.this.allDomainsTable.updateUI();
            ModelPP.this.preferredDomainsTable.setRowSelectionInterval(i1, i2);
            ModelPP.this.preferredDomainsTable.updateUI();
        }
    }
}

