/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class ModelLogicalPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_ModelLogicalPP";
    private static final String SO = "source_optional";
    private static final String TO = "target_optional";
    private static final String PK_IR = "pk_identifying_relation";
    private static final String FK_S = "keep_fk_names_syncronized";
    private static final String PK_NOTES = "propagate_pk_attr_notes";
    private static final String CRE_SK = "def_create_surrogate_key";
    private static final String USE_SK = "def_use_surrogate_key";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    private ModelLogicalPreferences(HashStructure hash) {
        super(hash);
    }

    public static ModelLogicalPreferences getInstance(PropertyStorage prefs) {
        return new ModelLogicalPreferences(ModelLogicalPreferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public void setSourceOptional(boolean sourceOptional) {
        this._hash.putBoolean(SO, sourceOptional);
    }

    public boolean getSourceOptional() {
        return this._hash.getBoolean(SO);
    }

    public void setTargetOptional(boolean targetOptional) {
        this._hash.putBoolean(TO, targetOptional);
    }

    public boolean getTargetOptional() {
        return this._hash.getBoolean(TO);
    }

    public void setUseFirstUniqueForIdentifyingRelation(boolean useFirstUniqueForIdentifyingRelation) {
        this._hash.putBoolean(PK_IR, useFirstUniqueForIdentifyingRelation);
    }

    public boolean getUseFirstUniqueForIdentifyingRelation() {
        return this._hash.getBoolean(PK_IR);
    }

    public void setKeepFKNamesSynchronized(boolean keepFKNamesSynchronized) {
        this._hash.putBoolean(FK_S, keepFKNamesSynchronized);
    }

    public boolean getKeepFKNamesSynchronized() {
        return this._hash.getBoolean(FK_S);
    }

    public void setPropagatePKAttrNotes(boolean propagatePKAttrNotes) {
        this._hash.putBoolean(PK_NOTES, propagatePKAttrNotes);
    }

    public boolean getPropagatePKAttrNotes() {
        return this._hash.getBoolean(PK_NOTES);
    }

    public void setUseSurrogateKey(boolean useSK) {
        this._hash.putBoolean(USE_SK, useSK);
    }

    public void setCreateSurrogateKey(boolean createSK) {
        this._hash.putBoolean(CRE_SK, createSK);
    }

    private boolean contains(String key) {
        return this._hash.containsKey(key);
    }

    public void loadToSettings(Settings settings) {
        if (this.contains(SO)) {
            settings.setSourceOptional(this.getSourceOptional());
        }
        if (this.contains(TO)) {
            settings.setTargetOptional(this.getTargetOptional());
        }
        if (this.contains(PK_IR)) {
            settings.setUseFirstUniqueForIdentifyingRelation(this.getUseFirstUniqueForIdentifyingRelation());
        }
        if (this.contains(FK_S)) {
            settings.setKeepFKNamesSynchronized(this.getKeepFKNamesSynchronized());
        }
        if (this.contains(PK_NOTES)) {
            settings.setPropagatePKAttrNotes(this.getPropagatePKAttrNotes());
        }
        if (this.contains(CRE_SK)) {
            settings.setDefaultCreateSurrogateKey(this._hash.getBoolean(CRE_SK));
        }
        if (this.contains(USE_SK)) {
            settings.setDefaultUseSurrogateKey(this._hash.getBoolean(USE_SK));
        }
    }

    public void loadFromSettings(Settings settings) {
        this.setKeepFKNamesSynchronized(settings.isKeepFKNamesSynchronized());
        this.setPropagatePKAttrNotes(settings.isPropagatePKAttrNotes());
        this.setSourceOptional(settings.isSourceOptional());
        this.setTargetOptional(settings.isTargetOptional());
        this.setUseFirstUniqueForIdentifyingRelation(settings.isUseFirstUniqueForIdentifyingRelation());
        this.setCreateSurrogateKey(settings.isDefaultCreateSurrogateKey());
        this.setUseSurrogateKey(settings.isDefaultUseSurrogateKey());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }
}

