/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class DiagramPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_DiagramPP";
    private static final String ST = "synchronize_tree";
    private static final String GS = "grid_size";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    protected DiagramPreferences(HashStructure hash) {
        super(hash);
    }

    public static DiagramPreferences getInstance(PropertyStorage prefs) {
        return new DiagramPreferences(DiagramPreferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public boolean isSynchronizeWithTree() {
        return this._hash.getBoolean(ST);
    }

    public void setSynchronizeWithTree(boolean synchronizeWithTree) {
        this._hash.putBoolean(ST, synchronizeWithTree);
    }

    public int getGridSize() {
        return this._hash.getInt(GS);
    }

    public void setGridSize(int gridSize) {
        this._hash.putInt(GS, gridSize);
    }

    private boolean contains(String key) {
        return this._hash.containsKey(key);
    }

    public void loadToSettings(Settings settings) {
        if (this.contains(ST)) {
            settings.setSynchronizeTree(this.isSynchronizeWithTree());
        }
        if (this.contains(GS)) {
            settings.setGridSize(this.getGridSize());
        }
    }

    public void loadFromSettings(Settings settings) {
        this.setSynchronizeWithTree(settings.synchronizeTree());
        this.setGridSize(settings.getGridSize());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }
}

