/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.browser.NavigationTreeRenderer;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.model.Displayable;
import oracle.ide.model.Locatable;

public class DisplayableLocatableNode
extends DefaultMutableTreeNode
implements Displayable,
Locatable {
    private static final Logger LOGGER = new Logger(DisplayableLocatableNode.class);
    protected File filePath;
    protected Class objectClass;
    protected URL url;
    protected StorableObject storableObject;
    String toolTipText = null;

    public DisplayableLocatableNode(StorableObject storableObject) {
        this(storableObject.getName(), new File(storableObject instanceof ModelIDObject ? ((ModelIDObject)storableObject).getSegmentedStorageName() : storableObject.getStorageName()), storableObject.getClass());
        this.setStorableObject(storableObject);
    }

    public DisplayableLocatableNode(String url) {
        this.setURL(url);
    }

    public DisplayableLocatableNode(File file) {
        this.setFileURL(file.getPath());
        this.setFilePath(file);
    }

    public DisplayableLocatableNode(String name, File filePath, Class objectClass) {
        super(name);
        this.setFilePath(filePath);
        this.setObjectClass(objectClass);
        if (filePath != null) {
            this.setFileURL(filePath.getPath());
        }
    }

    public StorableObject getStorableObject() {
        return this.storableObject;
    }

    public void setStorableObject(StorableObject storableObject) {
        this.storableObject = storableObject;
    }

    public File getFilePath() {
        return this.filePath;
    }

    public void setFilePath(File filePath) {
        this.filePath = filePath;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Class objectClass) {
        this.objectClass = objectClass;
    }

    protected void setFileURL(String url) {
        this.setURL("file://" + url);
    }

    protected void setURL(String url) {
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            LOGGER.error(e);
        }
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    public String getShortLabel() {
        return super.toString();
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return NavigationTreeRenderer.getIcon(this.objectClass);
    }

    public String getToolTipText() {
        if (this.toolTipText == null && this.filePath != null) {
            return this.filePath.getPath();
        }
        return null;
    }

    public static DisplayableLocatableNode[] convert(File[] filePaths) {
        if (filePaths == null) {
            return null;
        }
        DisplayableLocatableNode[] result = new DisplayableLocatableNode[filePaths.length];
        for (int i = 0; i < filePaths.length; ++i) {
            result[i] = new DisplayableLocatableNode(filePaths[i]);
        }
        return result;
    }

    public static File[] convertToFileArray(Locatable[] nodes, boolean expandSelection) {
        List<File> result = DisplayableLocatableNode.convertToFileList(nodes, expandSelection);
        return result.toArray(new File[0]);
    }

    public static List<File> convertToFileList(Locatable[] nodes, boolean expandSelection) {
        ArrayList<File> result = new ArrayList<File>();
        if (nodes != null && nodes.length > 0) {
            for (int i = 0; i < nodes.length; ++i) {
                StorableObject storableObject;
                DisplayableLocatableNode node = (DisplayableLocatableNode)nodes[i];
                File file = node.getFilePath();
                if (!file.exists() && (file.toString().endsWith(".xml") || file.toString().endsWith(".dmd"))) {
                    file = new File(file.toString() + "z");
                }
                if (file.exists()) {
                    result.add(file);
                }
                if (!expandSelection || (storableObject = node.getStorableObject()) == null || !(storableObject instanceof Design)) continue;
                Design design = (Design)storableObject;
                String designFolder = design.getStoragePath();
                DisplayableLocatableNode.addFolderEntries(new File(designFolder), result);
            }
        }
        return result;
    }

    private static void addFolderEntries(File folder, List<File> files) {
        File[] folderEntries = folder.listFiles();
        for (int i = 0; i < folderEntries.length; ++i) {
            File folderEntry = folderEntries[i];
            if (folderEntry.isDirectory()) {
                DisplayableLocatableNode.addFolderEntries(folderEntry, files);
                continue;
            }
            if (!VCSClientHelper.accept(folderEntry)) continue;
            files.add(folderEntry);
        }
    }

    public void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
    }
}

