/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.fcp.Icons;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.browser.BrowserPanel;
import oracle.dbtools.crest.util.Extension;
import oracle.ide.Context;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Node;
import oracle.ide.model.Workspace;

public class BrowserDockable
extends DockableWindow {
    public static final String VIEW_NAME = "DM_BROWSER";
    public static final ViewId VIEW_ID = new ViewId("EXTDockable", "DM_BROWSER");
    private JPanel jpanel;
    private HelpInfo helpInfo;
    private Component browser = null;

    public BrowserDockable() {
        super(VIEW_ID.getId());
    }

    public Component getBrowser() {
        return this.browser;
    }

    public int getDefaultVisibility(Layout layout) {
        if (!Extension.isDataModeler()) {
            return 0;
        }
        return 1;
    }

    public Component getGUI() {
        return this.getPanel();
    }

    public String getTitleName() {
        return Messages.getString("BrowserDockable.DataModelingBrowser");
    }

    public String getTabName() {
        return this.getTitleName();
    }

    private JPanel getPanel() {
        if (this.jpanel == null) {
            this.jpanel = new JPanel(new BorderLayout());
        }
        return this.jpanel;
    }

    public Icon getTabIcon() {
        return Icons.getBrowserIcon();
    }

    public void setBrowser(Component browser) {
        if (this.browser != browser) {
            if (this.browser != null) {
                this.getPanel().remove(this.browser);
            }
            this.getPanel().add(browser);
            this.browser = browser;
            this.getPanel().updateUI();
        }
    }

    public void clearBrowser() {
        if (this.browser != null) {
            this.getPanel().remove(this.browser);
            this.browser = null;
            this.getPanel().updateUI();
        }
    }

    public HelpInfo getHelpInfo() {
        if (this.helpInfo == null) {
            this.helpInfo = new HelpInfo("BROWSER_PANEL");
        }
        return this.helpInfo;
    }

    public Context getContext(EventObject event) {
        Context ctx = super.getContext(event);
        TreePath p = BrowserPanel.getTree().getSelectionPath();
        if (p != null) {
            Design d = null;
            for (int k = p.getPathCount() - 1; k >= 0; --k) {
                Object obj = p.getPathComponent(k);
                if (!(obj instanceof ModelIDObject)) continue;
                d = ((ModelIDObject)obj).getDesign();
                break;
            }
            if (d != null && d.hasWorkspaceSet()) {
                Workspace w = d.getWorkspace();
                ctx.setWorkspace(w);
                ctx.setNode((Node)Design.getDMDesignNode(w.getURL()));
            }
        }
        return ctx;
    }
}

