/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Table;

public class RSTableConstraints
extends RSGeneral {
    public static void export(Map map, Connection connection, Table table) throws Exception {
        int count = 0;
        String query = "INSERT INTO DMRS_TABLE_CONSTRAINTS (Table_ID, Table_OVID, Sequence, Constraint_ID, Constraint_OVID, Constraint_Name, Text, Table_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator it = table.getCheckConstraints().iterator();
        int seq = 0;
        while (it.hasNext()) {
            TableLevelConstraint constraint = (TableLevelConstraint)it.next();
            if ("".equals(constraint.getRule())) continue;
            ++seq;
            Object constraintName = constraint.getName();
            if (constraintName == null || ((String)constraintName).equals("")) {
                constraintName = table.getName() + "_CK" + String.valueOf(seq);
            }
            stmt.setString(1, table.getObjectID());
            stmt.setString(2, (String)map.get(table.getObjectID()));
            stmt.setInt(3, seq);
            stmt.setString(4, constraint.getID());
            stmt.setString(5, RSTableConstraints.getOrCreateOVID(map, constraint.getID()));
            stmt.setString(6, (String)constraintName);
            stmt.setString(7, constraint.getRule());
            stmt.setString(8, table.getName());
            stmt.setString(9, (String)map.get(table.getDesign().getObjectID()));
            stmt.addBatch();
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }
}

