/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSSpatialDimension;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;

public class RSSpatialColumnDefinition
extends RSGeneral {
    public static void export(Map map, Connection connection, Table table) throws Exception {
        ArrayList<SpatialColumnDefObject> list = new ArrayList<SpatialColumnDefObject>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_SPATIAL_COLUMN_DEFINITION (Table_ID, Table_OVID, Definition_ID, Definition_OVID, Definition_Name, Table_Name, Column_ID, Column_OVID, Column_Name, Use_Function, Function_Expression, Coordinate_System_ID, Has_Spatial_Index, Spatial_Index_ID, Spatial_Index_OVID, Spatial_Index_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        for (SpatialColumnDefObject sd2 : table.getSpatialDefinitions()) {
            String sdid = String.valueOf(sd2.getId());
            String ovid = RSSpatialColumnDefinition.getOrCreateOVID(map, sdid);
            stmt.setString(1, table.getObjectID());
            stmt.setString(2, (String)map.get(table.getObjectID()));
            stmt.setString(3, sdid);
            stmt.setString(4, ovid);
            stmt.setString(5, sd2.getName());
            stmt.setString(6, table.getName());
            if (sd2.getSpatialColumn() != null) {
                stmt.setString(7, sd2.getSpatialColumn().getObjectID());
                stmt.setString(8, (String)map.get(sd2.getSpatialColumn().getObjectID()));
                stmt.setString(9, sd2.getSpatialColumn().getName());
            } else {
                stmt.setString(7, null);
                stmt.setString(8, null);
                stmt.setString(9, null);
            }
            stmt.setString(10, sd2.isFunction() ? "Y" : "N");
            stmt.setString(11, sd2.getFuncExpression());
            stmt.setString(12, sd2.getSystemID());
            if (sd2.getSpatialIndex() != null) {
                stmt.setString(13, "Y");
                stmt.setString(14, sd2.getSpatialIndex().getObjectID());
                stmt.setString(15, (String)map.get(sd2.getSpatialIndex().getObjectID()));
                stmt.setString(16, sd2.getSpatialIndex().getName());
            } else {
                stmt.setString(13, "N");
                stmt.setString(14, null);
                stmt.setString(15, null);
                stmt.setString(16, null);
            }
            stmt.setString(17, (String)map.get(table.getDesign().getObjectID()));
            stmt.addBatch();
            list.add(sd2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (SpatialColumnDefObject sd2 : list) {
                RSSpatialDimension.export(map, connection, sd2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (SpatialColumnDefObject sd : list) {
                RSSpatialDimension.export(map, connection, sd);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

