/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;

public class RSRelationships
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, LogicalDesign model, String modelOVID) throws Exception {
        ArrayList<Relation> list = new ArrayList<Relation>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_RELATIONSHIPS (Relationship_Name, Model_ID, Model_OVID, Object_ID, OVID, Import_ID, Source_Entity_Name, Target_Entity_Name, Source_Label, Target_Label, SourceTo_Target_Cardinality, TargetTo_Source_Cardinality, Source_Optional, Target_Optional, Dominant_Role, Identifying, Source_ID, Source_OVID, Target_ID, Target_OVID, Number_Of_Attributes, Transferable, In_Arc, Arc_ID, Model_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator it = model.getRelationSet().iterator();
        while (it.hasNext()) {
            Relation relation2 = (Relation)it.next();
            String ovid = RSRelationships.getOrCreateOVID(map, relation2.getObjectID());
            stmt.setString(1, relation2.getName());
            stmt.setString(2, model.getObjectID());
            stmt.setString(3, modelOVID);
            stmt.setString(4, relation2.getObjectID());
            stmt.setString(5, ovid);
            stmt.setString(6, relation2.getImportedId());
            stmt.setString(7, relation2.getSourceEntity().getName());
            stmt.setString(8, relation2.getTargetEntity().getName());
            stmt.setString(9, relation2.getNameOnSource());
            stmt.setString(10, relation2.getNameOnTarget());
            stmt.setString(11, relation2.getTargetCardinality().toString());
            stmt.setString(12, relation2.getSourceCardinality().toString());
            stmt.setString(13, relation2.isOptionalSource() ? "Y" : "N");
            stmt.setString(14, relation2.isOptionalTarget() ? "Y" : "N");
            stmt.setString(15, relation2.getDominantRole().getName());
            stmt.setString(16, relation2.isIdentifying() ? "Y" : "N");
            stmt.setString(17, relation2.getSourceEntity().getObjectID());
            stmt.setString(18, (String)map.get(relation2.getSourceEntity().getObjectID()));
            stmt.setString(19, relation2.getTargetEntity().getObjectID());
            stmt.setString(20, (String)map.get(relation2.getTargetEntity().getObjectID()));
            int[] pkEndPoint = relation2.getPKProviderEndPoint();
            if (pkEndPoint.length > 0) {
                stmt.setInt(21, relation2.getOtherEndPoint(pkEndPoint[0]));
            } else {
                stmt.setInt(21, 0);
            }
            stmt.setString(22, relation2.isTransferable() ? "Y" : "N");
            stmt.setString(23, relation2.inArc() ? "Y" : "N");
            stmt.setString(24, relation2.getArc() != null ? relation2.getArc().getObjectID() : null);
            stmt.setString(25, model.getName());
            stmt.setString(26, (String)map.get(design.getObjectID()));
            stmt.addBatch();
            list.add(relation2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (Relation relation2 : list) {
                RSObjectNotes.export(map, connection, relation2);
                RSComments.export(map, connection, relation2);
                RSCommentsInRDBMS.export(map, connection, relation2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (Relation relation : list) {
                RSObjectNotes.export(map, connection, relation);
                RSComments.export(map, connection, relation);
                RSCommentsInRDBMS.export(map, connection, relation);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

