/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;

public class RSRaggedHierLinks
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<RaggedHLink> list = new ArrayList<RaggedHLink>(1000);
        int count = 0;
        ArrayList<RaggedHLink> linksCollection = new ArrayList<RaggedHLink>();
        String query = "INSERT INTO DMRS_RAGGED_HIER_LINKS (Ragged_Hier_Link_ID, Ragged_Hier_Link_Name, Ragged_Hier_Link_OVID, Model_ID, Model_Name, Model_OVID, Parent_Level_ID, Parent_Level_Name, Parent_Level_OVID, Child_Level_ID, Child_Level_Name, Child_Level_OVID, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        for (MultidimensionalDesign model : design.getMultidimensionalDesigns()) {
            String modelOVID = (String)map.get(model.getObjectID());
            String designOVID = (String)map.get(model.getDesign().getObjectID());
            linksCollection.clear();
            Iterator it = model.getRaggedHLinkSet().iterator();
            while (it.hasNext()) {
                RaggedHLink link2 = (RaggedHLink)it.next();
                String linkOVID = RSRaggedHierLinks.getOrCreateOVID(map, link2.getObjectID());
                linksCollection.add(link2);
                Level parent = link2.getParentLevel();
                Level child = link2.getChildLevel();
                stmt.setString(1, link2.getObjectID());
                stmt.setString(2, link2.getName());
                stmt.setString(3, linkOVID);
                stmt.setString(4, model.getObjectID());
                stmt.setString(5, model.getName());
                stmt.setString(6, modelOVID);
                if (parent != null) {
                    stmt.setString(7, parent.getObjectID());
                    stmt.setString(8, parent.getName());
                    stmt.setString(9, RSRaggedHierLinks.getOrCreateOVID(map, parent.getObjectID()));
                } else {
                    stmt.setString(7, null);
                    stmt.setString(8, null);
                    stmt.setString(9, null);
                }
                if (child != null) {
                    stmt.setString(10, child.getObjectID());
                    stmt.setString(11, child.getName());
                    stmt.setString(12, RSRaggedHierLinks.getOrCreateOVID(map, child.getObjectID()));
                } else {
                    stmt.setString(10, null);
                    stmt.setString(11, null);
                    stmt.setString(12, null);
                }
                stmt.setString(13, link2.getDescription());
                stmt.setString(14, designOVID);
                stmt.addBatch();
                list.add(link2);
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
                for (RaggedHLink link2 : list) {
                    RSObjectNotes.export(map, connection, link2);
                    RSComments.export(map, connection, link2);
                    RSDynamicProperties.export(design, map, connection, link2);
                }
                list.clear();
            }
            RSRaggedHierLinks.exportAttributes(map, connection, linksCollection, designOVID);
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (RaggedHLink link : list) {
                RSObjectNotes.export(map, connection, link);
                RSComments.export(map, connection, link);
                RSDynamicProperties.export(design, map, connection, link);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }

    private static void exportAttributes(Map map, Connection connection, List links, String designOVID) throws Exception {
        int count = 0;
        String attrQuery = "INSERT INTO DMRS_RAGGED_HIER_LINK_ATTRS (Ragged_Hier_Link_ID, Ragged_Hier_Link_Name, Ragged_Hier_Link_OVID, Attribute_ID, Attribute_Name, Attribute_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement attrStmt = connection.prepareStatement(attrQuery);
        for (RaggedHLink link : links) {
            for (Attribute attr : link.getChildToParentAttributes()) {
                String attrOVID = (String)map.get(attr.getObjectID());
                attrStmt.setString(1, link.getObjectID());
                attrStmt.setString(2, link.getName());
                attrStmt.setString(3, (String)map.get(link.getObjectID()));
                attrStmt.setString(4, attr.getObjectID());
                attrStmt.setString(5, attr.getName());
                attrStmt.setString(6, attrOVID);
                attrStmt.setString(7, designOVID);
                attrStmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                attrStmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            attrStmt.executeBatch();
        }
        attrStmt.close();
        attrStmt = null;
    }
}

