/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.util.GUID;

public class RSNotes
extends RSGeneral {
    public static void export(Map map, Connection connection, DesignPart dp) throws Exception {
        ArrayList<Note> list = new ArrayList<Note>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_Notes (Object_ID, OVID, Object_Name, Model_OVID, Model_ID, Model_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator it = dp.getNoteSet().iterator();
        while (it.hasNext()) {
            Note note2 = (Note)it.next();
            String ovid = new GUID().toString();
            map.put(note2.getObjectID(), ovid);
            stmt.setString(1, note2.getObjectID());
            stmt.setString(2, ovid);
            stmt.setString(3, note2.getName());
            stmt.setString(4, (String)map.get(dp.getObjectID()));
            stmt.setString(5, dp.getObjectID());
            stmt.setString(6, dp.getName());
            stmt.setString(7, (String)map.get(note2.getDesign().getObjectID()));
            stmt.addBatch();
            list.add(note2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (Note note2 : list) {
                RSComments.export(map, connection, note2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (Note note : list) {
                RSComments.export(map, connection, note);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

