/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.Design;

public class RSLocations
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<BILocation> list = new ArrayList<BILocation>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_LOCATIONS (Location_ID, Location_OVID, Location_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Loc_Address, Loc_City, Loc_Post_Code, Loc_Area, Loc_Country, Loc_Type, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        BusinessInfoDesign info = design.getBusinessInfoDesign();
        String designOVID = (String)map.get(design.getObjectID());
        String infoOVID = (String)map.get(design.getObjectID());
        Iterator it = info.getLocationSet().iterator();
        while (it.hasNext()) {
            BILocation loc2 = (BILocation)it.next();
            String locOVID = RSLocations.getOrCreateOVID(map, loc2.getObjectID());
            stmt.setString(1, loc2.getObjectID());
            stmt.setString(2, locOVID);
            stmt.setString(3, loc2.getName());
            stmt.setString(4, info.getObjectID());
            stmt.setString(5, infoOVID);
            stmt.setString(6, info.getName());
            stmt.setString(7, loc2.getAddress());
            stmt.setString(8, loc2.getCity());
            stmt.setString(9, loc2.getPostCode());
            stmt.setString(10, loc2.getArea());
            stmt.setString(11, loc2.getCountry());
            stmt.setString(12, loc2.getLocationType());
            stmt.setString(13, designOVID);
            stmt.addBatch();
            list.add(loc2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (BILocation loc2 : list) {
                RSComments.export(map, connection, loc2);
                RSDynamicProperties.export(design, map, connection, loc2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (BILocation loc : list) {
                RSComments.export(map, connection, loc);
                RSDynamicProperties.export(design, map, connection, loc);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

