/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.ProcessModel;

public class RSFlows
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Flow> list = new ArrayList<Flow>(1000);
        int count = 0;
        ArrayList<Flow> flowsCollection = new ArrayList<Flow>();
        String query = "INSERT INTO DMRS_FLOWS (Flow_ID, Flow_OVID, Flow_Name, Diagram_ID, Diagram_OVID, Diagram_Name, Event_ID, Event_OVID, Event_Name, Source_ID, Source_OVID, Source_Name, Destination_ID, Destination_OVID, Destination_Name, Parent_ID, Parent_OVID, Parent_Name, Source_Type, Destination_Type, System_Objective, Logging, Op_Create, Op_Read, Op_Update, Op_Delete, CRUD_Code, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        ProcessModel processModel = design.getProcessModel();
        for (DataFlowDesign dfd : processModel.getDataFlowDesigns()) {
            String dfdOVID = RSFlows.getOrCreateOVID(map, dfd.getObjectID());
            Iterator fit = dfd.getFlowSet().iterator();
            flowsCollection.clear();
            while (fit.hasNext()) {
                Flow flow2 = (Flow)fit.next();
                String flowOVID = RSFlows.getOrCreateOVID(map, flow2.getObjectID());
                flowsCollection.add(flow2);
                Event ev = flow2.getEvent();
                AbstractProcessObject src = flow2.getSource();
                AbstractProcessObject dest = flow2.getDestination();
                AbstractProcessObject par = flow2.getParentObject();
                stmt.setString(1, flow2.getObjectID());
                stmt.setString(2, flowOVID);
                stmt.setString(3, flow2.getName());
                stmt.setString(4, dfd.getObjectID());
                stmt.setString(5, dfdOVID);
                stmt.setString(6, !"".equals(dfd.getName()) ? dfd.getName() : dfd.getObjectTypeName());
                if (ev != null) {
                    stmt.setString(7, ev.getObjectID());
                    stmt.setString(8, RSFlows.getOrCreateOVID(map, ev.getObjectID()));
                    stmt.setString(9, ev.getName());
                } else {
                    stmt.setString(7, null);
                    stmt.setString(8, null);
                    stmt.setString(9, null);
                }
                if (src != null) {
                    stmt.setString(10, src.getObjectID());
                    stmt.setString(11, RSFlows.getOrCreateOVID(map, src.getObjectID()));
                    stmt.setString(12, src.getName());
                    stmt.setString(19, src.getObjectTypeName());
                } else {
                    stmt.setString(10, null);
                    stmt.setString(11, null);
                    stmt.setString(12, null);
                    stmt.setString(19, null);
                }
                if (dest != null) {
                    stmt.setString(13, dest.getObjectID());
                    stmt.setString(14, RSFlows.getOrCreateOVID(map, dest.getObjectID()));
                    stmt.setString(15, dest.getName());
                    stmt.setString(20, dest.getObjectTypeName());
                } else {
                    stmt.setString(13, null);
                    stmt.setString(14, null);
                    stmt.setString(15, null);
                    stmt.setString(20, null);
                }
                if (par != null) {
                    stmt.setString(16, par.getObjectID());
                    stmt.setString(17, RSFlows.getOrCreateOVID(map, par.getObjectID()));
                    stmt.setString(18, par.getName());
                } else {
                    stmt.setString(16, null);
                    stmt.setString(17, null);
                    stmt.setString(18, null);
                }
                stmt.setString(21, flow2.getSystemObjective());
                stmt.setString(22, flow2.isLogging() ? "Y" : "N");
                stmt.setString(23, flow2.isOpCreate() ? "Y" : "N");
                stmt.setString(24, flow2.isOpRead() ? "Y" : "N");
                stmt.setString(25, flow2.isOpUpdate() ? "Y" : "N");
                stmt.setString(26, flow2.isOpDelete() ? "Y" : "N");
                Object crud = "";
                if (flow2.isOpCreate()) {
                    crud = "C";
                }
                if (flow2.isOpRead()) {
                    crud = (String)crud + "R";
                }
                if (flow2.isOpUpdate()) {
                    crud = (String)crud + "U";
                }
                if (flow2.isOpDelete()) {
                    crud = (String)crud + "D";
                }
                stmt.setString(27, (String)crud);
                stmt.setString(28, (String)map.get(design.getObjectID()));
                stmt.addBatch();
                list.add(flow2);
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
                for (Flow flow2 : list) {
                    RSObjectNotes.export(map, connection, flow2);
                    RSComments.export(map, connection, flow2);
                    RSDynamicProperties.export(design, map, connection, flow2);
                }
                list.clear();
            }
            RSFlows.exportFlowsIS(map, connection, flowsCollection, design);
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (Flow flow : list) {
                RSObjectNotes.export(map, connection, flow);
                RSComments.export(map, connection, flow);
                RSDynamicProperties.export(design, map, connection, flow);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }

    private static void exportFlowsIS(Map map, Connection connection, List flows, Design design) throws Exception {
        int count = 0;
        String infoQuery = "INSERT INTO DMRS_FLOW_INFO_STRUCTURES (Flow_ID, Flow_OVID, Flow_Name, Info_Structure_ID, Info_Structure_OVID, Info_Structure_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement infoStmt = connection.prepareStatement(infoQuery);
        for (Flow flow : flows) {
            for (InfoStructure infoStructure : flow.getInfoStructures()) {
                String infoStructureOVID = (String)map.get(infoStructure.getObjectID());
                infoStmt.setString(1, flow.getObjectID());
                infoStmt.setString(2, (String)map.get(flow.getObjectID()));
                infoStmt.setString(3, flow.getName());
                infoStmt.setString(4, infoStructure.getObjectID());
                infoStmt.setString(5, infoStructureOVID);
                infoStmt.setString(6, infoStructure.getName());
                infoStmt.setString(7, (String)map.get(design.getObjectID()));
                infoStmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                infoStmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            infoStmt.executeBatch();
        }
        infoStmt.close();
        infoStmt = null;
    }
}

