/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.ProcessModel;

public class RSExternalDatas
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<ExternalData> list = new ArrayList<ExternalData>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_EXTERNAL_DATAS (External_Data_ID, External_Data_OVID, External_Data_Name, Model_ID, Model_OVID, Model_Name, Logical_Type_ID, Logical_Type_OVID, Logical_Type_Name, Record_Structure_Type_ID, Record_Structure_Type_OVID, Record_Structure_Type_Name, Starting_Pos, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        ProcessModel processModel = design.getProcessModel();
        Iterator it = processModel.getExternalDataSet().iterator();
        while (it.hasNext()) {
            ExternalData ext2 = (ExternalData)it.next();
            String extOVID = RSExternalDatas.getOrCreateOVID(map, ext2.getObjectID());
            stmt.setString(1, ext2.getObjectID());
            stmt.setString(2, extOVID);
            stmt.setString(3, ext2.getName());
            stmt.setString(4, processModel.getObjectID());
            stmt.setString(5, (String)map.get(processModel.getObjectID()));
            stmt.setString(6, processModel.getName());
            if (!ext2.isStructured()) {
                stmt.setString(7, ext2.getType() != null ? ext2.getType().getObjectID() : "");
                stmt.setString(8, ext2.getType() != null ? (String)map.get(ext2.getType().getObjectID()) : "");
                stmt.setString(9, ext2.getType() != null ? ext2.getType().getName() : "");
                stmt.setString(10, null);
                stmt.setString(11, null);
                stmt.setString(12, null);
            } else {
                stmt.setString(7, null);
                stmt.setString(8, null);
                stmt.setString(9, null);
                stmt.setString(10, ext2.getRecordStructure() != null ? ext2.getRecordStructure().getObjectID() : "");
                stmt.setString(11, ext2.getRecordStructure() != null ? RSExternalDatas.getOrCreateOVID(map, ext2.getRecordStructure().getObjectID()) : "");
                stmt.setString(12, ext2.getRecordStructure() != null ? ext2.getRecordStructure().getName() : "");
            }
            stmt.setInt(13, ext2.getStartingPos());
            stmt.setString(14, ext2.getDescription());
            stmt.setString(15, (String)map.get(design.getObjectID()));
            stmt.addBatch();
            list.add(ext2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (ExternalData ext2 : list) {
                RSComments.export(map, connection, ext2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (ExternalData ext : list) {
                RSComments.export(map, connection, ext);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

