/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSExistenceDependanciesColumns;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.util.GUID;

public class RSExistenceDependencies
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        String query = "INSERT INTO DMRS_EXISTENCE_DEP (Object_OVID, Dependency_Name, Table_OVID, Generation_Level, Discriminator_Column_OVID, Discriminator_Column_Name, Model_Name, Model_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        for (RelationalDesign model : design.getRelationalDesigns()) {
            String modelOVID = (String)map.get(model.getObjectID());
            Iterator it = model.getTableSet().iterator();
            while (it.hasNext()) {
                Table table = (Table)it.next();
                if (table.getExistDependencyConstraintName().equals("") || table.getExistDependencyConstraintName() == null || table.getDiscriminatorColumn() == null) continue;
                String ovid = new GUID().toString();
                stmt.setString(1, ovid);
                stmt.setString(2, table.getExistDependencyConstraintName());
                stmt.setString(3, (String)map.get(table.getObjectID()));
                stmt.setString(4, table.getExistDependencyGenerationLevel());
                stmt.setString(5, table.getDiscriminatorColumn() != null ? (String)map.get(table.getDiscriminatorColumn().getObjectID()) : "");
                stmt.setString(6, table.getDiscriminatorColumn() != null ? table.getDiscriminatorColumn().getName() : "");
                stmt.setString(7, model.getName());
                stmt.setString(8, (String)map.get(model.getObjectID()));
                stmt.setString(9, (String)map.get(design.getObjectID()));
                stmt.executeUpdate();
                RSExistenceDependanciesColumns.export(design, map, connection, table, ovid);
            }
        }
        stmt.close();
        stmt = null;
    }
}

