/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;

public class RSEntityArcs
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, LogicalDesign model, String modelOVID) throws Exception {
        ArrayList<Arc> list = new ArrayList<Arc>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_ENTITY_ARCS (Object_OVID, Object_ID, Arc_Name, Entity_ID,Model_Name, Model_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator it = model.getArcSet().iterator();
        while (it.hasNext()) {
            Arc arc2 = (Arc)it.next();
            if (arc2.getEntity() == null) continue;
            String ovid = RSEntityArcs.getOrCreateOVID(map, arc2.getObjectID());
            stmt.setString(1, ovid);
            stmt.setString(2, arc2.getObjectID());
            stmt.setString(3, arc2.getName());
            stmt.setString(4, arc2.getEntity().getObjectID());
            stmt.setString(5, model.getName());
            stmt.setString(6, modelOVID);
            stmt.setString(7, (String)map.get(design.getObjectID()));
            stmt.addBatch();
            list.add(arc2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (Arc arc2 : list) {
                RSObjectNotes.export(map, connection, arc2);
                RSComments.export(map, connection, arc2);
                RSCommentsInRDBMS.export(map, connection, arc2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (Arc arc : list) {
                RSObjectNotes.export(map, connection, arc);
                RSComments.export(map, connection, arc);
                RSCommentsInRDBMS.export(map, connection, arc);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

