/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.Design;

public class RSEmails
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList list = new ArrayList(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_EMAILS (Email_ID, Email_OVID, Email_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Email_Address, Email_Type, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        BusinessInfoDesign info = design.getBusinessInfoDesign();
        String designOVID = (String)map.get(design.getObjectID());
        String infoOVID = (String)map.get(design.getObjectID());
        Iterator it = info.getEmailSet().iterator();
        while (it.hasNext()) {
            BIEmail email2 = (BIEmail)it.next();
            String emailOVID = RSEmails.getOrCreateOVID(map, email2.getObjectID());
            stmt.setString(1, email2.getObjectID());
            stmt.setString(2, emailOVID);
            stmt.setString(3, email2.getName());
            stmt.setString(4, info.getObjectID());
            stmt.setString(5, infoOVID);
            stmt.setString(6, info.getName());
            stmt.setString(7, email2.getEmailAddress());
            stmt.setString(8, email2.getType());
            stmt.setString(9, designOVID);
            stmt.addBatch();
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (BIEmail email2 : list) {
                RSComments.export(map, connection, email2);
                RSDynamicProperties.export(design, map, connection, email2);
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (BIEmail email : list) {
                RSComments.export(map, connection, email);
                RSDynamicProperties.export(design, map, connection, email);
            }
        }
        stmt.close();
        stmt = null;
    }
}

