/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.RepaintManager;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDiagramElements;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.DPVMainPanel;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.printing.PDFExporter;
import oracle.dbtools.crest.swingui.process.DPVProcess;
import oracle.dbtools.crest.swingui.process.DPVTransformation;
import oracle.dbtools.crest.util.dmweb.DiagramToSVG;
import oracle.dbtools.crest.util.logging.Logger;

public class RSDiagrams
extends RSGeneral {
    private static int openedDiagramscounter = 0;
    private static Map<DesignPartViewPlaceHolder, Boolean> diagramsToBeClosedList = new HashMap<DesignPartViewPlaceHolder, Boolean>();
    private static DesignPartViewPlaceHolder lastDiagram = null;
    private static String modelExtraFilesDirName = "";
    private static LinkedHashMap dpvToSVGSuffixMap = new LinkedHashMap();
    private static final Logger LOGGER = new Logger(RSDiagrams.class);

    /*
     * WARNING - void declaration
     */
    public static void export(Design design, Map map, Connection connection, boolean exportDiagramsAsPDF, boolean exportDiagramsAsSVG, String reportsPath, boolean clearDiagrams) throws Exception {
        File file;
        String s;
        String[] filesList;
        DesignPartViewPlaceHolder ph;
        String query = "INSERT INTO DMRS_Diagrams (Diagram_Name, Object_ID, OVID, Diagram_Type, Is_Display, Visible, Master_Diagram_ID, Master_Diagram_OVID, Model_ID, Model_OVID, Model_Name, Notation, Show_All_Details, Show_Names_Only, Show_Elements, Show_Datatype, Show_Keys, Autoroute, Box_In_box, Master_Diagram_Name, Diagram_SVG, Diagram_PDF, Subview_ID, Subview_OVID, Subview_Name, Display_ID, Display_OVID, Display_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        ArrayList<DesignPartView> tempList = new ArrayList<DesignPartView>();
        HashMap<DesignPartView, DesignPart> list = new HashMap<DesignPartView, DesignPart>();
        boolean mainViewVisible = false;
        boolean displayViewVisible = false;
        LogicalDesign logicalModel = design.getLogicalDesign();
        mainViewVisible = RSDiagrams.ensureMainViewVisible(logicalModel);
        if (exportDiagramsAsPDF || exportDiagramsAsSVG) {
            RSDiagrams.showDisplays(logicalModel.getMainView());
        }
        list.put(logicalModel.getMainView(), logicalModel);
        for (DesignPartView dpv : RSDiagrams.getDisplays(logicalModel.getMainView())) {
            list.put(dpv, logicalModel);
        }
        tempList.add(logicalModel.getMainView());
        tempList.addAll(RSDiagrams.getDisplays(logicalModel.getMainView()));
        Iterator<Object> it = logicalModel.getLogicalDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder ph2 = (DesignPartViewPlaceHolder)it.next();
            if (exportDiagramsAsPDF || exportDiagramsAsSVG) {
                RSDiagrams.showDisplays(ph2.getDesignPartView());
            }
            list.put(ph2.getDesignPartView(), logicalModel);
            for (DesignPartView dpv : RSDiagrams.getDisplays(ph2.getDesignPartView())) {
                list.put(dpv, logicalModel);
            }
            tempList.add(ph2.getDesignPartView());
            tempList.addAll(RSDiagrams.getDisplays(ph2.getDesignPartView()));
        }
        modelExtraFilesDirName = logicalModel.getName().replaceAll("[^a-zA-Z1-9_]", "_") + "_" + logicalModel.getShortObjectID();
        lastDiagram = tempList.size() > 0 ? (DesignPartViewPlaceHolder)((DesignPartView)tempList.get(tempList.size() - 1)).getPlaceHolder() : null;
        File modelExtraFilesDir = new File(reportsPath, modelExtraFilesDirName);
        if (modelExtraFilesDir.exists() && clearDiagrams) {
            String[] filesList2 = modelExtraFilesDir.list();
            for (int i = 0; i < filesList2.length; ++i) {
                File file2 = new File(modelExtraFilesDir, filesList2[i]);
                file2.delete();
            }
        }
        int seq = 1;
        for (DesignPartView dpv : tempList) {
            ph = (DesignPartViewPlaceHolder)dpv.getPlaceHolder();
            if (ph != null) {
                RSDiagrams.generatePDF(dpv, ph, RSDiagrams.getDiagramName(dpv), modelExtraFilesDir, ph.getVisible());
            }
            String string = "__dg_rm_" + seq;
            dpvToSVGSuffixMap.put(dpv, string);
            ++seq;
        }
        tempList.clear();
        for (MultidimensionalDesign mud : design.getMultidimensionalDesigns()) {
            if (!mud.isLoaded()) continue;
            mainViewVisible = RSDiagrams.ensureMainViewVisible(mud);
            if (exportDiagramsAsPDF || exportDiagramsAsSVG) {
                RSDiagrams.showDisplays(mud.getMainView());
            }
            list.put(mud.getMainView(), mud);
            tempList.add(mud.getMainView());
            modelExtraFilesDirName = mud.getName().replaceAll("[^a-zA-Z1-9_]", "_") + "_" + mud.getShortObjectID();
            lastDiagram = tempList.size() > 0 ? (DesignPartViewPlaceHolder)((DesignPartView)tempList.get(tempList.size() - 1)).getPlaceHolder() : null;
            modelExtraFilesDir = new File(reportsPath, modelExtraFilesDirName);
            if (modelExtraFilesDir.exists() && clearDiagrams) {
                void var20_27;
                filesList = modelExtraFilesDir.list();
                boolean bl = false;
                while (var20_27 < filesList.length) {
                    File file3 = new File(modelExtraFilesDir, filesList[var20_27]);
                    file3.delete();
                    ++var20_27;
                }
            }
            seq = 1;
            for (DesignPartView designPartView : tempList) {
                DesignPartViewPlaceHolder ph3 = (DesignPartViewPlaceHolder)designPartView.getPlaceHolder();
                if (ph3 != null) {
                    RSDiagrams.generatePDF(designPartView, ph3, RSDiagrams.getDiagramName(designPartView), modelExtraFilesDir, ph3.getVisible());
                }
                s = "__dg_rm_" + seq;
                dpvToSVGSuffixMap.put(designPartView, s);
                ++seq;
            }
            tempList.clear();
        }
        for (RelationalDesign rel : design.getRelationalDesigns()) {
            if (!rel.isLoaded()) continue;
            mainViewVisible = RSDiagrams.ensureMainViewVisible(rel);
            if (exportDiagramsAsPDF || exportDiagramsAsSVG) {
                RSDiagrams.showDisplays(rel.getMainView());
            }
            list.put(rel.getMainView(), rel);
            for (DesignPartView dpv : RSDiagrams.getDisplays(rel.getMainView())) {
                list.put(dpv, rel);
            }
            tempList.add(rel.getMainView());
            tempList.addAll(RSDiagrams.getDisplays(rel.getMainView()));
            Iterator sbit = rel.getDesignSubviews().iterator();
            while (sbit.hasNext()) {
                DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)sbit.next();
                if (exportDiagramsAsPDF || exportDiagramsAsSVG) {
                    RSDiagrams.showDisplays(designPartViewPlaceHolder.getDesignPartView());
                }
                list.put(designPartViewPlaceHolder.getDesignPartView(), rel);
                for (DesignPartView dpv : RSDiagrams.getDisplays(designPartViewPlaceHolder.getDesignPartView())) {
                    list.put(dpv, rel);
                }
                tempList.add(designPartViewPlaceHolder.getDesignPartView());
                tempList.addAll(RSDiagrams.getDisplays(designPartViewPlaceHolder.getDesignPartView()));
            }
            modelExtraFilesDirName = rel.getName().replaceAll("[^a-zA-Z1-9_]", "_") + "_" + rel.getShortObjectID();
            lastDiagram = tempList.size() > 0 ? (DesignPartViewPlaceHolder)((DesignPartView)tempList.get(tempList.size() - 1)).getPlaceHolder() : null;
            modelExtraFilesDir = new File(reportsPath, modelExtraFilesDirName);
            if (modelExtraFilesDir.exists() && clearDiagrams) {
                String[] stringArray = modelExtraFilesDir.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    file = new File(modelExtraFilesDir, stringArray[i]);
                    file.delete();
                }
            }
            seq = 1;
            for (DesignPartView dpv : tempList) {
                DesignPartViewPlaceHolder ph5 = (DesignPartViewPlaceHolder)dpv.getPlaceHolder();
                if (ph5 != null) {
                    RSDiagrams.generatePDF(dpv, ph5, RSDiagrams.getDiagramName(dpv), modelExtraFilesDir, ph5.getVisible());
                }
                String s3 = "__dg_rm_" + seq;
                dpvToSVGSuffixMap.put(dpv, s3);
                ++seq;
            }
            tempList.clear();
        }
        DataTypesDesign dataTypesDesign = design.getDataTypesDesign();
        mainViewVisible = RSDiagrams.ensureMainViewVisible(dataTypesDesign);
        if (exportDiagramsAsPDF || exportDiagramsAsSVG) {
            RSDiagrams.showDisplays(design.getDataTypesDesign().getMainView());
        }
        list.put(dataTypesDesign.getMainView(), dataTypesDesign);
        for (DesignPartView dpv : RSDiagrams.getDisplays(dataTypesDesign.getMainView())) {
            list.put(dpv, logicalModel);
        }
        tempList.add(dataTypesDesign.getMainView());
        tempList.addAll(RSDiagrams.getDisplays(dataTypesDesign.getMainView()));
        it = dataTypesDesign.getDesignSubviews().iterator();
        while (it.hasNext()) {
            ph = (DesignPartViewPlaceHolder)it.next();
            if (exportDiagramsAsPDF || exportDiagramsAsSVG) {
                RSDiagrams.showDisplays(ph.getDesignPartView());
            }
            list.put(ph.getDesignPartView(), dataTypesDesign);
            for (DesignPartView designPartView : RSDiagrams.getDisplays(ph.getDesignPartView())) {
                list.put(designPartView, dataTypesDesign);
            }
            tempList.add(ph.getDesignPartView());
            tempList.addAll(RSDiagrams.getDisplays(ph.getDesignPartView()));
        }
        modelExtraFilesDirName = dataTypesDesign.getName().replaceAll("[^a-zA-Z1-9_]", "_") + "_" + dataTypesDesign.getShortObjectID();
        lastDiagram = tempList.size() > 0 ? (DesignPartViewPlaceHolder)((DesignPartView)tempList.get(tempList.size() - 1)).getPlaceHolder() : null;
        modelExtraFilesDir = new File(reportsPath, modelExtraFilesDirName);
        if (modelExtraFilesDir.exists() && clearDiagrams) {
            void var20_34;
            filesList = modelExtraFilesDir.list();
            boolean bl = false;
            while (var20_34 < filesList.length) {
                File file4 = new File(modelExtraFilesDir, filesList[var20_34]);
                file4.delete();
                ++var20_34;
            }
        }
        seq = 1;
        for (DesignPartView dpv : tempList) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)dpv.getPlaceHolder();
            if (designPartViewPlaceHolder != null) {
                RSDiagrams.generatePDF(dpv, designPartViewPlaceHolder, RSDiagrams.getDiagramName(dpv), modelExtraFilesDir, designPartViewPlaceHolder.getVisible());
            }
            String s4 = "__dg_rm_" + seq;
            dpvToSVGSuffixMap.put(dpv, s4);
            ++seq;
        }
        tempList.clear();
        ProcessModel pm = design.getProcessModel();
        for (DataFlowDesign dataFlowDesign : pm.getDataFlowDesigns()) {
            if (dataFlowDesign.getTopLevelDataFlowDesign() == null) continue;
            mainViewVisible = RSDiagrams.ensureMainViewVisible(dataFlowDesign);
            list.put(dataFlowDesign.getMainView(), pm);
            tempList.add(dataFlowDesign.getMainView());
            RSObjectNotes.export(map, connection, dataFlowDesign);
            RSComments.export(map, connection, dataFlowDesign);
        }
        modelExtraFilesDirName = pm.getName().replaceAll("[^a-zA-Z1-9_]", "_") + "_" + pm.getShortObjectID();
        lastDiagram = tempList.size() > 0 ? (DesignPartViewPlaceHolder)((DesignPartView)tempList.get(tempList.size() - 1)).getPlaceHolder() : null;
        modelExtraFilesDir = new File(reportsPath, modelExtraFilesDirName);
        if (modelExtraFilesDir.exists() && clearDiagrams) {
            String[] stringArray = modelExtraFilesDir.list();
            for (int i = 0; i < stringArray.length; ++i) {
                file = new File(modelExtraFilesDir, stringArray[i]);
                file.delete();
            }
        }
        seq = 1;
        for (DesignPartView designPartView : tempList) {
            DesignPartViewPlaceHolder ph7 = (DesignPartViewPlaceHolder)designPartView.getPlaceHolder();
            if (ph7 != null) {
                RSDiagrams.generatePDF(designPartView, ph7, RSDiagrams.getDiagramName(designPartView), modelExtraFilesDir, ph7.getVisible());
            }
            s = "__dg_rm_" + seq;
            dpvToSVGSuffixMap.put(designPartView, s);
            ++seq;
        }
        tempList.clear();
        it = design.getProcessModel().getTransformationPackageSet().iterator();
        while (it.hasNext()) {
            TransformationPackage transformationPackage = (TransformationPackage)it.next();
            for (TransformationTask tmt : transformationPackage.getTransformationTaskSet()) {
                mainViewVisible = RSDiagrams.ensureMainViewVisible(tmt);
                list.put(tmt.getMainView(), design.getProcessModel());
                tempList.add(tmt.getMainView());
            }
        }
        modelExtraFilesDirName = design.getProcessModel().getName().replaceAll("[^a-zA-Z1-9_]", "_") + "_" + design.getProcessModel().getShortObjectID();
        lastDiagram = tempList.size() > 0 ? (DesignPartViewPlaceHolder)((DesignPartView)tempList.get(tempList.size() - 1)).getPlaceHolder() : null;
        modelExtraFilesDir = new File(reportsPath, modelExtraFilesDirName);
        if (modelExtraFilesDir.exists() && clearDiagrams) {
            String[] stringArray = modelExtraFilesDir.list();
            for (int i = 0; i < stringArray.length; ++i) {
                file = new File(modelExtraFilesDir, stringArray[i]);
                file.delete();
            }
        }
        seq = 1;
        for (DesignPartView designPartView : tempList) {
            DesignPartViewPlaceHolder ph8 = (DesignPartViewPlaceHolder)designPartView.getPlaceHolder();
            if (ph8 != null) {
                RSDiagrams.generatePDF(designPartView, ph8, RSDiagrams.getDiagramName(designPartView), modelExtraFilesDir, ph8.getVisible());
            }
            s = "__dg_rm_" + seq;
            dpvToSVGSuffixMap.put(designPartView, s);
            ++seq;
        }
        tempList.clear();
        for (Map.Entry entry : list.entrySet()) {
            DesignPartView dpv = (DesignPartView)entry.getKey();
            if (dpv.getDPVId() == null) continue;
            DesignPart dp = (DesignPart)entry.getValue();
            String shortObjID = dp.getShortObjectID();
            stmt.setString(1, RSDiagrams.getDiagramNameNoReplace(dpv));
            stmt.setString(2, dpv.getDPVId());
            stmt.setString(3, RSDiagrams.getOrCreateOVID(map, dpv.getDPVId()));
            stmt.setString(4, dpv.isMainDiagram() ? "MainView" : "Subview");
            stmt.setString(5, dpv.isDisplay() ? "Y" : "N");
            stmt.setString(6, dpv.getMainPanel().isVisible() ? "Y" : "N");
            stmt.setString(7, dpv.isDisplay() ? dpv.getMasterDPV().getDPVId() : null);
            stmt.setString(8, dpv.isDisplay() ? RSDiagrams.getOrCreateOVID(map, dpv.getMasterDPV().getDPVId()) : null);
            stmt.setString(9, dpv.getDesignPart().getObjectID());
            stmt.setString(10, (String)map.get(dpv.getDesignPart().getObjectID()));
            stmt.setString(11, dpv.getDesignPart().getName());
            String not = "Barker";
            if (dpv.getNotation() == 0) {
                not = "Bachman";
            } else if (dpv.getNotation() == 2) {
                not = "IE";
            }
            stmt.setString(12, not);
            stmt.setString(13, dpv.showAllDetails() ? "Y" : "N");
            stmt.setString(14, dpv.isShowNamesOnly() ? "Y" : "N");
            stmt.setString(15, dpv.showElements() ? "Y" : "N");
            stmt.setString(16, dpv.showDatatype() ? "Y" : "N");
            stmt.setString(17, dpv.showKeys() ? "Y" : "N");
            stmt.setString(18, dpv.isAutoRoute() ? "Y" : "N");
            stmt.setString(19, dpv.isBoxInBox() ? "Y" : "N");
            stmt.setString(20, dpv.isDisplay() ? RSDiagrams.getDiagramNameNoReplace(dpv.getMasterDPV()) : null);
            if (exportDiagramsAsSVG) {
                String sfx = (String)dpvToSVGSuffixMap.get(dpv);
                if (sfx != null && !sfx.equals("") && dpv.getTopViews().size() > 0) {
                    String svg = DiagramToSVG.getSVGForDiagram(dpv, true, sfx);
                    BufferedReader reader = new BufferedReader(new StringReader(svg));
                    stmt.setCharacterStream(21, (Reader)reader, svg.length());
                } else {
                    stmt.setObject(21, null);
                }
            } else {
                stmt.setObject(21, null);
            }
            FileInputStream is = null;
            if (exportDiagramsAsPDF) {
                modelExtraFilesDirName = dp.getName().replaceAll("[^a-zA-Z1-9_]", "_") + "_" + shortObjID;
                File pdf = new File(reportsPath + "/" + (String)modelExtraFilesDirName + "/" + RSDiagrams.getDiagramName(dpv) + ".pdf");
                if (pdf.exists()) {
                    is = new FileInputStream(pdf);
                    stmt.setBinaryStream(22, (InputStream)is, (int)pdf.length());
                } else {
                    stmt.setObject(22, null);
                }
            } else {
                stmt.setObject(22, null);
            }
            stmt.setString(23, dpv.isMainDiagram() ? null : dpv.getDPVId());
            stmt.setString(24, dpv.isMainDiagram() ? null : RSDiagrams.getOrCreateOVID(map, dpv.getDPVId()));
            stmt.setString(25, dpv.isMainDiagram() ? null : RSDiagrams.getDiagramNameNoReplace(dpv));
            stmt.setString(26, dpv.isDisplay() ? dpv.getDPVId() : null);
            stmt.setString(27, dpv.isDisplay() ? RSDiagrams.getOrCreateOVID(map, dpv.getDPVId()) : null);
            stmt.setString(28, dpv.isDisplay() ? RSDiagrams.getDiagramNameNoReplace(dpv) : null);
            stmt.setString(29, (String)map.get(design.getObjectID()));
            stmt.executeUpdate();
            if (is != null) {
                is.close();
            }
            RSDiagramElements.export(map, connection, dpv);
        }
        stmt.close();
        stmt = null;
        if (exportDiagramsAsPDF) {
            RSDiagrams.clearPDF();
        }
    }

    public static String getDiagramName(DesignPartView dpv) {
        String name = "";
        if (dpv instanceof DPVProcess || dpv instanceof DPVTransformation) {
            name = dpv.getDesignPart().getName();
            if (name == null || "".equals(name)) {
                name = dpv.getDesignPart().getObjectTypeName();
            }
        } else {
            name = dpv.getName();
            if ((name == null || "".equals(name)) && ((name = dpv.getDesignPart().getName()) == null || "".equals(name))) {
                name = dpv.getDesignPart().getObjectTypeName();
            }
        }
        return name.replaceAll("[^a-zA-Z1-9_]", "_");
    }

    public static String getDiagramNameNoReplace(DesignPartView dpv) {
        String name = "";
        if (dpv instanceof DPVProcess || dpv instanceof DPVTransformation) {
            name = dpv.getDesignPart().getName();
            if (name == null || "".equals(name)) {
                name = dpv.getDesignPart().getObjectTypeName();
            }
        } else {
            name = dpv.getName();
            if ((name == null || "".equals(name)) && ((name = dpv.getDesignPart().getName()) == null || "".equals(name))) {
                name = dpv.getDesignPart().getObjectTypeName();
            }
        }
        return name;
    }

    private static boolean ensureMainViewVisible(DesignPart designPart) {
        boolean nowVisible = designPart.isMainViewVisible();
        if (designPart.isLoaded() && designPart.isVisible()) {
            designPart.setMainViewVisible(true);
        }
        return nowVisible;
    }

    private static boolean ensureDisplayViewVisible(DesignPartViewPlaceHolder placeHolder) {
        placeHolder.setVisibleNoLater(true);
        boolean nowVisible = placeHolder.getVisible();
        return nowVisible;
    }

    protected static List getDisplays(DesignPartView dpv) {
        ArrayList<DesignPartView> list = new ArrayList<DesignPartView>();
        Iterator it = dpv.getDisplays().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder phd = (DesignPartViewPlaceHolder)it.next();
            list.add(phd.getDesignPartView());
        }
        return list;
    }

    protected static void clearPDF() {
        File tempFile = new File(System.getProperty("java.io.tmpdir"), "diagram.pdf");
        if (tempFile.exists()) {
            boolean bl = tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generatePDF(DesignPartView dpv, DesignPartViewPlaceHolder ph, String diagramName, File modelExtraFilesDir, boolean isVisible) {
        AbstractDiagram diagram = null;
        RepaintManager currentManager = null;
        double scale = 0.0;
        boolean forceClose = false;
        OutputStream ostream = null;
        try {
            if (openedDiagramscounter == 3) {
                for (Map.Entry<DesignPartViewPlaceHolder, Boolean> pairs : diagramsToBeClosedList.entrySet()) {
                    DesignPartViewPlaceHolder ph0 = pairs.getKey();
                    Boolean wasVisible = pairs.getValue();
                    if (wasVisible.booleanValue()) continue;
                    ph0.setVisibleNoLater(false);
                }
                diagramsToBeClosedList.clear();
                diagramsToBeClosedList.put(ph, isVisible);
                openedDiagramscounter = 0;
            }
            ++openedDiagramscounter;
            diagramsToBeClosedList.put(ph, isVisible);
            if (lastDiagram != null && lastDiagram == ph) {
                forceClose = true;
            }
            boolean success = false;
            success = !modelExtraFilesDir.exists() ? modelExtraFilesDir.mkdir() : true;
            if (success) {
                File tempFile = new File(modelExtraFilesDir + "/" + diagramName + ".pdf");
                if (tempFile.exists()) {
                    return;
                }
                RSDiagrams.ensureDisplayViewVisible(ph);
                diagram = dpv.getWorkSpace();
                scale = diagram.getScale();
                ((Diagram)diagram).actualSize();
                currentManager = RepaintManager.currentManager(diagram);
                currentManager.setDoubleBufferingEnabled(false);
                PDFExporter.diagramToPDF((Diagram)diagram, tempFile.getAbsolutePath());
            }
        }
        catch (Throwable e) {
            LOGGER.error("Exception when export PDF to reporting repository (" + diagramName + ")" + e);
        }
        finally {
            if (forceClose) {
                for (Map.Entry<DesignPartViewPlaceHolder, Boolean> pairs : diagramsToBeClosedList.entrySet()) {
                    DesignPartViewPlaceHolder ph0 = pairs.getKey();
                    Boolean wasVisible = pairs.getValue();
                    if (wasVisible.booleanValue()) continue;
                    ph0.setVisibleNoLater(false);
                }
                diagramsToBeClosedList.clear();
                openedDiagramscounter = 0;
            }
            if (currentManager != null) {
                currentManager.setDoubleBufferingEnabled(true);
            }
            if (diagram != null) {
                diagram.setScale(scale);
            }
            try {
                if (ostream != null) {
                    ostream.flush();
                    ostream.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("RSDiagrams.generatePDF() Can not close output stream when creating PDF diagram (" + diagramName + ")" + e);
            }
        }
    }

    private static void showDisplays(DesignPartView dpv) {
        if (dpv != null) {
            DesignPartView.NamedTabbedPane pane = dpv.getTabbedPane();
            TreeMap<String, DesignPartView> dpvMap = new TreeMap<String, DesignPartView>();
            Component[] dpvComps = pane.getComponents();
            for (int i = 0; i < dpvComps.length; ++i) {
                if (!(dpvComps[i] instanceof DPVMainPanel)) continue;
                DesignPartView dpvComp = ((DPVMainPanel)dpvComps[i]).getDesignPartView();
                dpvMap.put(dpvComp.getDPVId(), dpvComp);
            }
            if (dpvMap.containsKey(dpv.getDPVId())) {
                Component c = pane.getSelectedComponent();
                pane.setSelectedComponent(dpv.getMainPanel());
                Iterator itd = dpv.getDisplays().iterator();
                while (itd.hasNext()) {
                    DesignPartViewPlaceHolder phd = (DesignPartViewPlaceHolder)itd.next();
                    String dpvKey = phd.getDesignPartView().getDPVId();
                    if (!dpvMap.containsKey(dpvKey)) continue;
                    pane.setSelectedComponent(((DesignPartView)dpvMap.get(dpvKey)).getMainPanel());
                }
                pane.setSelectedComponent(c);
            }
        }
    }
}

