/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBSchemaUDBv81
extends AbstractSSBUDB {
    private StorageDesign storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SchemaUDBv81 && ((SchemaUDBv81)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        SchemaUDBv81 schema = (SchemaUDBv81)object;
        this.storageDesign = schema.getStorageDesign();
        this.appendComment(buffer, schema);
        this.appendCreate(buffer, schema);
        this.appendAuthorizationObject(buffer, schema, prettyPrint);
        SSBSchemaUDBv81.appendNewLine(buffer, prettyPrint, 0);
        SSBSchemaUDBv81.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateSchema();
        if (schema.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(buffer, schema, prettyPrint);
        }
    }

    private void appendCommentOn(StringBuffer buffer, SchemaUDBv81 schema, boolean prettyPrint) {
        SSBSchemaUDBv81.appendNewLine(buffer, prettyPrint, 0);
        SSBSchemaUDBv81.appendStringWithSpace(buffer, "COMMENT ON");
        SSBSchemaUDBv81.appendStringWithSpace(buffer, "SCHEMA");
        StorageDesignUDB storageDesign = (StorageDesignUDB)this.getStorageDesign(schema);
        SSBSchemaUDBv81.appendStringWithSpace(buffer, storageDesign.getFormatedName(schema.getLongName()));
        SSBSchemaUDBv81.appendStringWithSpace(buffer, "IS");
        SSBSchemaUDBv81.appendString(buffer, '\'');
        SSBSchemaUDBv81.appendString(buffer, schema.getCommentInRDBMS());
        SSBSchemaUDBv81.appendStringWithSpace(buffer, '\'');
        SSBSchemaUDBv81.appendNewLine(buffer, prettyPrint, 0);
        SSBSchemaUDBv81.appendLineFinisher(buffer, prettyPrint);
    }

    protected void appendCreate(StringBuffer buffer, SchemaUDBv81 schema) {
        this.appendCreate(buffer);
        SSBSchemaUDBv81.appendStringWithSpace(buffer, "SCHEMA");
        SSBSchemaUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(schema.getName()));
    }

    protected void appendAuthorizationObject(StringBuffer buffer, SchemaUDBv81 schema, boolean prettyPrint) {
        if (schema.getOwner() != null && !schema.getOwner().isNullInstance()) {
            SSBSchemaUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBSchemaUDBv81.appendStringWithSpace(buffer, "AUTHORIZATION");
            StorageDesignUDB storageDesign = (StorageDesignUDB)this.getStorageDesign(schema);
            SSBSchemaUDBv81.appendStringWithSpace(buffer, storageDesign.getFormatedName(schema.getOwner().getName()));
        }
    }
}

