/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.v81.BufferPoolUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBBufferPoolUDBv81
extends AbstractSSBUDB {
    private static final String EXCEPT_ON_DBPARTITIONNUMS = "EXCEPT ON DBPARTITIONNUMS";
    private static final String PAGESIZE = "PAGESIZE";
    private static final String EXTENDED_STORAGE = "EXTENDED STORAGE";
    public static final String ALL_DBPARTITIONNUMS = "ALL DBPARTITIONNUMS";
    private StorageDesign storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof BufferPoolUDBv81 && ((BufferPoolUDBv81)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        BufferPoolUDBv81 bufferpool = (BufferPoolUDBv81)object;
        this.storageDesign = bufferpool.getStorageDesign();
        this.appendCreate(buffer, bufferpool);
        this.appendCreateImmediate(buffer, bufferpool);
        this.appendDBPartitionGroups(buffer, bufferpool, prettyPrint);
        this.appendSize(buffer, bufferpool, prettyPrint);
        this.appendPageSize(buffer, bufferpool, prettyPrint);
        this.appendExtendedStorage(buffer, bufferpool, prettyPrint);
        SSBBufferPoolUDBv81.appendNewLine(buffer, prettyPrint, 0);
        DDLFileMaker.incrementCreateBufferPool();
        SSBBufferPoolUDBv81.appendLineFinisher(buffer, prettyPrint);
    }

    protected void appendCreate(StringBuffer buffer, BufferPoolUDBv81 bufferpool) {
        this.appendCreate(buffer);
        SSBBufferPoolUDBv81.appendStringWithSpace(buffer, "BUFFERPOOL");
        SSBBufferPoolUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(bufferpool.getName()));
    }

    private void appendCreateImmediate(StringBuffer buffer, BufferPoolUDBv81 bufferpool) {
        if ("NO".equalsIgnoreCase(bufferpool.getCreateImmediate())) {
            SSBBufferPoolUDBv81.appendStringWithSpace(buffer, "DEFERRED");
        } else {
            SSBBufferPoolUDBv81.appendStringWithSpace(buffer, "IMMEDIATE");
        }
    }

    protected void appendDBPartitionGroups(StringBuffer buffer, BufferPoolUDBv81 bufferpool, boolean prettyPrint) {
        if (!bufferpool.getScope().equalsIgnoreCase("") && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBBufferPoolUDBv81.appendNewLine(buffer, prettyPrint, 1);
            if (bufferpool.getScope().equalsIgnoreCase("")) {
                SSBBufferPoolUDBv81.appendStringWithSpace(buffer, ALL_DBPARTITIONNUMS);
            } else {
                SSBBufferPoolUDBv81.appendStringWithSpace(buffer, "DATABASE");
                SSBBufferPoolUDBv81.appendStringWithSpace(buffer, "PARTITION");
                SSBBufferPoolUDBv81.appendStringWithSpace(buffer, "GROUP");
                SSBBufferPoolUDBv81.appendStringWithSpace(buffer, bufferpool.getScope());
            }
        }
    }

    protected void appendSize(StringBuffer buffer, BufferPoolUDBv81 bufferpool, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBBufferPoolUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBBufferPoolUDBv81.appendStringWithSpace(buffer, "SIZE");
            SSBBufferPoolUDBv81.appendStringWithSpace(buffer, bufferpool.getSize());
            if (!bufferpool.getNodesWithDiffSize().equalsIgnoreCase("") && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                SSBBufferPoolUDBv81.appendStringWithSpace(buffer, EXCEPT_ON_DBPARTITIONNUMS);
                SSBBufferPoolUDBv81.appendStringWithSpace(buffer, '(');
                SSBBufferPoolUDBv81.appendStringWithSpace(buffer, bufferpool.getNodesWithDiffSize());
                SSBBufferPoolUDBv81.appendStringWithSpace(buffer, ')');
            }
        }
    }

    protected void appendPageSize(StringBuffer buffer, BufferPoolUDBv81 bufferpool, boolean prettyPrint) {
        if (bufferpool.getPageSize() > 0 && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBBufferPoolUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBBufferPoolUDBv81.appendStringWithSpace(buffer, PAGESIZE);
            SSBBufferPoolUDBv81.appendStringWithSpace(buffer, bufferpool.getPageSize());
            SSBBufferPoolUDBv81.appendStringWithSpace(buffer, 'K');
        }
    }

    protected void appendExtendedStorage(StringBuffer buffer, BufferPoolUDBv81 bufferpool, boolean prettyPrint) {
        if (bufferpool.getExtendedStorage() && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBBufferPoolUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBBufferPoolUDBv81.appendStringWithSpace(buffer, EXTENDED_STORAGE);
        }
    }
}

