/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.StoredProcedureUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBStoredProcedureUDBv71
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        StoredProcedureUDBv71 proc = (StoredProcedureUDBv71)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        this.appendComment(buffer, proc);
        this.appendCreate(buffer, proc);
        this.appendBody(buffer, proc, prettyPrint);
        SSBStoredProcedureUDBv71.appendNewLine(buffer, prettyPrint, 0);
        SSBStoredProcedureUDBv71.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateProc();
        if (proc.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(buffer, proc, prettyPrint);
        }
    }

    private void appendCommentOn(StringBuffer buffer, StoredProcedureUDBv71 proc, boolean prettyPrint) {
        SSBStoredProcedureUDBv71.appendNewLine(buffer, prettyPrint, 0);
        SSBStoredProcedureUDBv71.appendStringWithSpace(buffer, "COMMENT ON");
        SSBStoredProcedureUDBv71.appendStringWithSpace(buffer, "PROCEDURE");
        SSBStoredProcedureUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(proc.getLongNameDDL()));
        SSBStoredProcedureUDBv71.appendStringWithSpace(buffer, "IS");
        SSBStoredProcedureUDBv71.appendString(buffer, '\'');
        SSBStoredProcedureUDBv71.appendString(buffer, proc.getCommentInRDBMS());
        SSBStoredProcedureUDBv71.appendStringWithSpace(buffer, '\'');
        SSBStoredProcedureUDBv71.appendNewLine(buffer, prettyPrint, 0);
        SSBStoredProcedureUDBv71.appendLineFinisher(buffer, prettyPrint);
    }

    private void appendCreate(StringBuffer buffer, StoredProcedureUDBv71 proc) {
        this.appendCreate(buffer);
        SSBStoredProcedureUDBv71.appendStringWithSpace(buffer, "PROCEDURE");
        if (proc.getOwner() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBStoredProcedureUDBv71.appendString(buffer, this.storageDesign.getFormatedName(proc.getSchema().getName()));
            SSBStoredProcedureUDBv71.appendString(buffer, ".");
        }
        SSBStoredProcedureUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(proc.getName()));
    }

    private void appendBody(StringBuffer buffer, StoredProcedureUDBv71 proc, boolean prettyPrint) {
        SSBStoredProcedureUDBv71.appendNewLine(buffer, prettyPrint, 1);
        if (!proc.getBody().trim().equalsIgnoreCase("")) {
            SSBStoredProcedureUDBv71.appendStringWithSpace(buffer, proc.getBody());
        } else {
            SSBStoredProcedureUDBv71.appendStringWithSpace(buffer, " -- Empty body");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof StoredProcedureUDBv71 && ((StoredProcedureUDBv71)object).isMarkedGenerate();
    }
}

