/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.udb.PrivilegesUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;

public class SSBSchemaPrivilegesUDBv71
extends AbstractSSBUDB {
    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        PrivilegesUDB priv = (PrivilegesUDB)object;
        if (!(priv.getUser() == null && priv.getGroup() == null || "".equalsIgnoreCase(priv.getSystemPrivileges()))) {
            StorageDesignUDB storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
            SSBSchemaPrivilegesUDBv71.appendStringWithSpace(buffer, "GRANT");
            SSBSchemaPrivilegesUDBv71.appendStringWithSpace(buffer, priv.getSystemPrivileges());
            SSBSchemaPrivilegesUDBv71.appendStringWithSpace(buffer, "ON");
            SSBSchemaPrivilegesUDBv71.appendStringWithSpace(buffer, "SCHEMA");
            SSBSchemaPrivilegesUDBv71.appendStringWithSpace(buffer, storageDesign.getFormatedName(priv.getSchema().getName()));
            SSBSchemaPrivilegesUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBSchemaPrivilegesUDBv71.appendStringWithSpace(buffer, "TO");
            if (priv.getUser() != null) {
                if (!priv.getUser().getName().equalsIgnoreCase("PUBLIC")) {
                    SSBSchemaPrivilegesUDBv71.appendStringWithSpace(buffer, "USER");
                }
                SSBSchemaPrivilegesUDBv71.appendStringWithSpace(buffer, storageDesign.getFormatedName(priv.getUser().getName()));
            } else {
                SSBSchemaPrivilegesUDBv71.appendStringWithSpace(buffer, "GROUP");
                SSBSchemaPrivilegesUDBv71.appendStringWithSpace(buffer, storageDesign.getFormatedName(priv.getGroup().getName()));
            }
            if ("YES".equalsIgnoreCase(priv.getGrantOption())) {
                SSBSchemaPrivilegesUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBSchemaPrivilegesUDBv71.appendStringWithSpace(buffer, "WITH GRANT OPTION");
            }
            SSBSchemaPrivilegesUDBv71.appendNewLine(buffer, prettyPrint, 0);
            SSBSchemaPrivilegesUDBv71.appendLineFinisher(buffer, prettyPrint);
            SSBSchemaPrivilegesUDBv71.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof PrivilegesUDB;
    }
}

