/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.FKProxyUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBFKUDBv71
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof RelationalObjectProxy && !((RelationalObjectProxy)object).getStorageDesign().isOpen()) {
            if (object instanceof FKProxyUDBv71) {
                return ((RelationalObjectProxy)object).getObject().isMarkedGenerate();
            }
        } else if (object instanceof FKIndexAssociation) {
            return ((FKIndexAssociation)object).isMarkedGenerate();
        }
        return object instanceof FKProxyUDBv71 && ((FKProxyUDBv71)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        FKProxyUDBv71 fkproxy;
        if (object instanceof FKIndexAssociation) {
            FKIndexAssociation fk = (FKIndexAssociation)object;
            RelationalDesign rd = (RelationalDesign)fk.getDesignPart();
            this.storageDesign = (StorageDesignUDB)this.getStorageDesign();
            fkproxy = (FKProxyUDBv71)this.storageDesign.getFKProxySet().getProxy(fk.getObjectID());
            if (fkproxy == null && (fkproxy = (FKProxyUDBv71)this.storageDesign.getFKProxySet().getProxy(fk.getLocalFKIndex().getObjectID())) == null) {
                return;
            }
        } else {
            fkproxy = (FKProxyUDBv71)object;
            this.storageDesign = (StorageDesignUDB)fkproxy.getStorageDesign();
        }
        if (fkproxy.getFKTable() instanceof Table) {
            TableProxyUDB tableProxy = (TableProxyUDB)fkproxy.getStorageDesign().getTableProxySet().getProxy(fkproxy.getTable().getObjectID());
            SSBFKUDBv71.appendNewLine(buffer, prettyPrint, 0);
            this.appendBeforeAlterScript(buffer, prettyPrint, (ContainerObject)tableProxy.getObject());
            SSBFKUDBv71.appendStringWithSpace(buffer, "ALTER");
            SSBFKUDBv71.appendStringWithSpace(buffer, "TABLE");
            SSBFKUDBv71.appendString(buffer, this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
            SSBFKUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBFKUDBv71.appendStringWithSpace(buffer, "ADD");
            SSBFKUDBv71.appendStringWithSpace(buffer, "CONSTRAINT");
            SSBFKUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkproxy.getName()));
            SSBFKUDBv71.appendString(buffer, "FOREIGN KEY");
            SSBFKUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBFKUDBv71.appendStringWithSpace(buffer, '(');
            SSBFKUDBv71.appendNewLine(buffer, prettyPrint, 0);
            SSBFKUDBv71.appendString(buffer, fkproxy.getColumns(this.storageDesign));
            SSBFKUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBFKUDBv71.appendStringWithSpace(buffer, ')');
            this.appendReferences(buffer, fkproxy, prettyPrint);
            this.appendOnDelete(buffer, fkproxy, prettyPrint);
            this.appendOnUpdate(buffer, fkproxy, prettyPrint);
            SSBFKUDBv71.appendNewLine(buffer, prettyPrint, 0);
            SSBFKUDBv71.appendLineFinisher(buffer, prettyPrint);
            SSBFKUDBv71.appendNewLine(buffer, prettyPrint, 0);
            SSBFKUDBv71.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementAlterTable();
            this.appendAfterAlterScript(buffer, prettyPrint, (ContainerObject)tableProxy.getObject());
        }
    }

    private void appendReferences(StringBuffer buffer, FKProxyUDBv71 fk, boolean prettyPrint) {
        SSBFKUDBv71.appendNewLine(buffer, prettyPrint, 1);
        SSBFKUDBv71.appendStringWithSpace(buffer, "REFERENCES");
        TableProxyUDB tableProxy = (TableProxyUDB)fk.getStorageDesign().getTableProxySet().getProxy(fk.getFKTable().getObjectID());
        SSBFKUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
        SSBFKUDBv71.appendNewLine(buffer, prettyPrint, 1);
        SSBFKUDBv71.appendStringWithSpace(buffer, '(');
        SSBFKUDBv71.appendNewLine(buffer, prettyPrint, 0);
        SSBFKUDBv71.appendString(buffer, fk.getReferenceColumns(this.storageDesign));
        SSBFKUDBv71.appendNewLine(buffer, prettyPrint, 1);
        SSBFKUDBv71.appendString(buffer, ')');
    }

    private void appendOnDelete(StringBuffer buffer, FKProxyUDBv71 fk, boolean prettyPrint) {
        FKIndexAssociation fkass = ((Index)fk.getObject()).getFKAssociation();
        String onDelete = fkass.getDeleteRule();
        if (onDelete.equalsIgnoreCase("SET DEFAULT")) {
            onDelete = fkass.isMandatory() ? "RESTRICT" : "SET NULL";
        }
        SSBFKUDBv71.appendNewLine(buffer, prettyPrint, 1);
        SSBFKUDBv71.appendStringWithSpace(buffer, "ON");
        SSBFKUDBv71.appendStringWithSpace(buffer, "DELETE");
        SSBFKUDBv71.appendString(buffer, onDelete);
    }

    private void appendOnUpdate(StringBuffer buffer, FKProxyUDBv71 fk, boolean prettyPrint) {
        SSBFKUDBv71.appendNewLine(buffer, prettyPrint, 1);
        SSBFKUDBv71.appendStringWithSpace(buffer, "ON");
        SSBFKUDBv71.appendStringWithSpace(buffer, "UPDATE");
        SSBFKUDBv71.appendString(buffer, fk.getOnUpdate());
    }
}

