/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.storage.udb.MethodParamProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.MethodProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;

public class SSBMethodUDB
extends AbstractSSBUDB {
    @Override
    public boolean canHandle(Object object) {
        return object instanceof MethodProxyUDB || object instanceof Method;
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        MethodProxyUDB methodProxy;
        if (!(object instanceof Method) && object instanceof MethodProxyUDB && !(methodProxy = (MethodProxyUDB)object).getStructuredType().isPredefined()) {
            SSBMethodUDB.appendNewLine(buffer, prettyPrint, 0);
            this.appendComment(buffer, methodProxy);
            this.appendDefinition(buffer, methodProxy, prettyPrint);
            SSBMethodUDB.appendNewLine(buffer, prettyPrint, 0);
            SSBMethodUDB.appendLineFinisher(buffer, prettyPrint);
        }
    }

    private void appendDefinition(StringBuffer buffer, MethodProxyUDB methodProxy, boolean prettyPrint) {
        SSBMethodUDB.appendNewLine(buffer, prettyPrint, 0);
        SSBMethodUDB.appendStringWithSpace(buffer, "CREATE");
        if (!"".equalsIgnoreCase(methodProxy.getSpecificName())) {
            SSBMethodUDB.appendStringWithSpace(buffer, "SPECIFIC");
            SSBMethodUDB.appendStringWithSpace(buffer, "METHOD");
            SSBMethodUDB.appendStringWithSpace(buffer, methodProxy.getStorageDesign().getFormatedName(methodProxy.getSpecificName()));
        } else {
            SSBMethodUDB.appendStringWithSpace(buffer, "METHOD");
            SSBMethodUDB.appendStringWithSpace(buffer, methodProxy.getStorageDesign().getFormatedName(methodProxy.getName()));
            if (methodProxy.getParams().size() > 0) {
                SSBMethodUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBMethodUDB.appendStringWithSpace(buffer, '(');
                Iterator it = methodProxy.getParams().iterator();
                while (it.hasNext()) {
                    MethodParamProxyUDB param = (MethodParamProxyUDB)it.next();
                    SSBMethodUDB.appendNewLine(buffer, prettyPrint, 1);
                    SSBMethodUDB.appendString(buffer, ' ');
                    SSBMethodUDB.appendStringWithSpace(buffer, param.getName());
                    SSBMethodUDB.appendStringWithSpace(buffer, param.getMethodParam().getDataType());
                    if (param.isAsLocator()) {
                        SSBMethodUDB.appendStringWithSpace(buffer, "AS LOCATOR");
                    }
                    if (!it.hasNext()) continue;
                    SSBMethodUDB.appendStringWithSpace(buffer, ',');
                }
                SSBMethodUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBMethodUDB.appendStringWithSpace(buffer, ')');
            }
            if (!"".equalsIgnoreCase(methodProxy.getReturnValue())) {
                SSBMethodUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBMethodUDB.appendStringWithSpace(buffer, "RETURNS");
                SSBMethodUDB.appendStringWithSpace(buffer, methodProxy.getReturnValue());
            }
            SSBMethodUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBMethodUDB.appendStringWithSpace(buffer, "FOR");
            StructuredTypeProxyUDB typeProxy = (StructuredTypeProxyUDB)methodProxy.getStorageDesign().getProxy(methodProxy.getStructuredType());
            if (typeProxy.getSchema() != null && typeProxy.getAppView().getSettings().isIncludeSchemaInDDL()) {
                this.appendString(buffer, typeProxy.getSchema());
                SSBMethodUDB.appendString(buffer, '.');
            }
            SSBMethodUDB.appendStringWithSpace(buffer, typeProxy.getName());
        }
        if ("SQL".equalsIgnoreCase(methodProxy.getLanguage())) {
            if (!"".equalsIgnoreCase(methodProxy.getSqlMethodBody())) {
                SSBMethodUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBMethodUDB.appendStringWithSpace(buffer, "RETURN");
                SSBMethodUDB.appendStringWithSpace(buffer, methodProxy.getSqlMethodBody());
            }
        } else {
            if (!"".equalsIgnoreCase(methodProxy.getExt_R_Name())) {
                SSBMethodUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBMethodUDB.appendStringWithSpace(buffer, "EXTERNAL");
                SSBMethodUDB.appendStringWithSpace(buffer, "NAME");
                SSBMethodUDB.appendStringWithSpace(buffer, methodProxy.getExt_R_Name());
            }
            if (!"".equalsIgnoreCase(methodProxy.getExt_R_TransformGroup())) {
                SSBMethodUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBMethodUDB.appendStringWithSpace(buffer, "TRANSFORM");
                SSBMethodUDB.appendStringWithSpace(buffer, "GROUP");
                SSBMethodUDB.appendStringWithSpace(buffer, methodProxy.getExt_R_TransformGroup());
            }
        }
    }
}

