/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.LoginSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserSetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserSqlServerv2k5;

public class SSBLoginSqlServerv2k5
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        LoginSqlServerv2k5 login = (LoginSqlServerv2k5)object;
        this.storageDesign = login.getStorageDesign();
        this.appendComment(buffer, login);
        if (login.getAuthentication().equalsIgnoreCase("WINDOWS")) {
            this.appendGrantLogin(buffer, login, prettyPrint);
            this.appendDefaultDB(buffer, login, prettyPrint);
            this.appendDefaultLanguage(buffer, login, prettyPrint);
        } else {
            this.appendAddLogin(buffer, login, prettyPrint);
        }
        this.appendGrantUsersDBAccess(buffer, login, prettyPrint);
        UserSetSqlServerv2k5 users = (UserSetSqlServerv2k5)((StorageDesignSqlServerv2k5)login.getStorageDesign()).getUserSet();
        for (int i = 0; i < login.getUserSet().size(); ++i) {
            this.appendPrivileges(buffer, (UserSqlServerv2k5)users.getByName((String)login.getUserSet().get(i)), prettyPrint);
        }
    }

    private void appendGrantLogin(StringBuffer buffer, LoginSqlServerv2k5 login, boolean prettyPrint) {
        SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
        SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "sp_grantlogin");
        SSBLoginSqlServerv2k5.appendString(buffer, '\'');
        SSBLoginSqlServerv2k5.appendString(buffer, login.getName());
        SSBLoginSqlServerv2k5.appendString(buffer, '\'');
        SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "GO");
        SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
    }

    private void appendDefaultDB(StringBuffer buffer, LoginSqlServerv2k5 login, boolean prettyPrint) {
        if (login.getDefaultDatabase() != null) {
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
            SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "sp_defaultdb");
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            SSBLoginSqlServerv2k5.appendString(buffer, login.getName());
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            this.appendComma(buffer);
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            this.appendString(buffer, login.getDefaultDatabase());
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "GO");
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
            SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "sp_defaultdb");
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            SSBLoginSqlServerv2k5.appendString(buffer, login.getName());
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            this.appendComma(buffer);
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            SSBLoginSqlServerv2k5.appendString(buffer, "master");
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "GO");
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendDefaultLanguage(StringBuffer buffer, LoginSqlServerv2k5 login, boolean prettyPrint) {
        if (login.getLanguage() != null) {
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
            SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "sp_defaultlanguage");
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            SSBLoginSqlServerv2k5.appendString(buffer, login.getName());
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            this.appendComma(buffer);
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            SSBLoginSqlServerv2k5.appendString(buffer, login.getLanguage());
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "GO");
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendAddLogin(StringBuffer buffer, LoginSqlServerv2k5 login, boolean prettyPrint) {
        if (login.getDefaultDatabase() != null) {
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
            SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "sp_addlogin");
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            SSBLoginSqlServerv2k5.appendString(buffer, login.getName());
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            this.appendComma(buffer);
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            SSBLoginSqlServerv2k5.appendString(buffer, login.decodePassword());
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            this.appendComma(buffer);
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            SSBLoginSqlServerv2k5.appendString(buffer, login.getDefaultDatabase().getName());
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            if (login.getLanguage() != null) {
                this.appendComma(buffer);
                SSBLoginSqlServerv2k5.appendString(buffer, '\'');
                SSBLoginSqlServerv2k5.appendString(buffer, login.getLanguage());
                SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            }
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "GO");
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        } else {
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "-- Invalid login (without specified DB)");
            SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(login.getName()));
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendGrantUsersDBAccess(StringBuffer buffer, LoginSqlServerv2k5 login, boolean prettyPrint) {
        UserSetSqlServerv2k5 users = (UserSetSqlServerv2k5)((StorageDesignSqlServerv2k5)login.getStorageDesign()).getUserSet();
        UserSqlServerv2k5 u = null;
        for (String user : login.getUserSet()) {
            u = (UserSqlServerv2k5)users.getByName(user);
            if (u != null && u.getDatabase() != null && !u.getDatabase().isNullInstance()) {
                SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "USE");
                SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, u.getDatabase().getName());
                SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "GO");
                SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            }
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
            SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "sp_grantdbaccess");
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            SSBLoginSqlServerv2k5.appendString(buffer, login.getName());
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            this.appendComma(buffer);
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            SSBLoginSqlServerv2k5.appendString(buffer, user);
            SSBLoginSqlServerv2k5.appendString(buffer, '\'');
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "GO");
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendPrivileges(StringBuffer buffer, UserSqlServerv2k5 user, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(user.getSystemPrivileges())) {
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            if (user.getDatabase() != null && !user.getDatabase().isNullInstance()) {
                SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "USE");
                this.appendStringWithSpace(buffer, user.getDatabase());
                SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBLoginSqlServerv2k5.appendString(buffer, "GO");
                SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            }
            SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "GRANT");
            if (user.getPrivilegesSet().contains("ALL")) {
                SSBLoginSqlServerv2k5.appendString(buffer, "ALL");
            } else {
                SSBLoginSqlServerv2k5.appendString(buffer, user.getSystemPrivileges());
            }
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBLoginSqlServerv2k5.appendStringWithSpace(buffer, "TO");
            this.appendString(buffer, user);
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k5.appendString(buffer, "GO");
            SSBLoginSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof LoginSqlServerv2k5 && ((LoginSqlServerv2k5)object).getBeforeDefaults() && ((LoginSqlServerv2k5)object).isMarkedGenerate();
    }
}

