/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.TriggerSqlServerv2k;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTriggerSqlServerv2k
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        TriggerSqlServerv2k trigger = (TriggerSqlServerv2k)object;
        this.storageDesign = trigger.getStorageDesign();
        this.appendComment(buffer, trigger);
        if (!trigger.getActions().trim().equalsIgnoreCase("")) {
            SSBTriggerSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            this.appendCreate(buffer, trigger);
            this.appendOnTable(buffer, trigger);
            this.appendWithEncription(buffer, trigger, prettyPrint);
            this.appendTriggeringTime(buffer, trigger, prettyPrint);
            this.appendAction(buffer, trigger);
            this.appendReplication(buffer, trigger, prettyPrint);
            SSBTriggerSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, "AS");
            this.appendTriggeredAction(buffer, trigger, prettyPrint);
            SSBTriggerSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, "GO");
            SSBTriggerSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementCreateTrigger();
            this.appendSetTriggerOrder(buffer, trigger, prettyPrint);
            if (trigger.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendTriggerComment(buffer, trigger, prettyPrint);
            }
        } else {
            SSBTriggerSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, "-- invalid trigger: without action");
        }
    }

    private void appendTriggerComment(StringBuffer buffer, TriggerSqlServerv2k trigger, boolean prettyPrint) {
        String comment = trigger.getCommentInRDBMS();
        if (comment != null && !comment.trim().equalsIgnoreCase("")) {
            SSBTriggerSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTriggerSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTriggerSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, "'MS_Description'");
            SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTriggerSqlServerv2k.appendString(buffer, '\'');
            SSBTriggerSqlServerv2k.appendString(buffer, comment);
            SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, ',');
            if (trigger != null && trigger.getOwner() != null) {
                SSBTriggerSqlServerv2k.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k.appendString(buffer, "USER");
                SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, ',');
                SSBTriggerSqlServerv2k.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k.appendString(buffer, trigger.getOwner().getName());
                SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, ',');
            }
            if (trigger.getTable() != null) {
                SSBTriggerSqlServerv2k.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k.appendString(buffer, "TABLE");
                SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, ',');
                SSBTriggerSqlServerv2k.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(trigger.getTable().getLongNameDDL()));
                SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, ',');
            } else if (trigger.getView() != null) {
                SSBTriggerSqlServerv2k.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k.appendString(buffer, "VIEW");
                SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, ',');
                SSBTriggerSqlServerv2k.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(trigger.getView().getLongNameDDL()));
                SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, ',');
            }
            SSBTriggerSqlServerv2k.appendString(buffer, '\'');
            SSBTriggerSqlServerv2k.appendString(buffer, "TRIGGER");
            SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBTriggerSqlServerv2k.appendString(buffer, '\'');
            SSBTriggerSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(trigger.getName()));
            SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBTriggerSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBTriggerSqlServerv2k.appendString(buffer, "GO");
            SSBTriggerSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendCreate(StringBuffer buffer, TriggerSqlServerv2k trigger) {
        this.appendCreate(buffer);
        SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, "TRIGGER");
        if (trigger.getOwner() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBTriggerSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(trigger.getOwner().getName()));
            SSBTriggerSqlServerv2k.appendString(buffer, '.');
        }
        SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(trigger.getName()));
    }

    private void appendOnTable(StringBuffer buffer, TriggerSqlServerv2k trigger) {
        SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, "ON");
        if (trigger.getTable() != null) {
            SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(trigger.getTable()));
        } else {
            SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(trigger.getView()));
        }
    }

    private void appendWithEncription(StringBuffer buffer, TriggerSqlServerv2k trigger, boolean prettyPrint) {
        if (trigger.getEncription().equalsIgnoreCase("YES") && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTriggerSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, "WITH");
            SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, "ENCRYPTION");
        }
    }

    private void appendTriggeringTime(StringBuffer buffer, TriggerSqlServerv2k trigger, boolean prettyPrint) {
        SSBTriggerSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, "AFTER");
        }
        SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, trigger.getTriggerTime());
    }

    private void appendAction(StringBuffer buffer, TriggerSqlServerv2k trigger) {
        for (int i = 0; i < trigger.getActionSet().size(); ++i) {
            if (i > 0) {
                this.appendComma(buffer);
            }
            this.appendStringWithSpace(buffer, trigger.getActionSet().elementAt(i));
        }
    }

    private void appendReplication(StringBuffer buffer, TriggerSqlServerv2k trigger, boolean prettyPrint) {
        if (trigger.getForReplication().equalsIgnoreCase("NO")) {
            SSBTriggerSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, "NOT FOR REPLICATION");
        }
    }

    private void appendTriggeredAction(StringBuffer buffer, TriggerSqlServerv2k trigger, boolean prettyPrint) {
        SSBTriggerSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        if (trigger.getBody().equalsIgnoreCase("")) {
            SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, "-- Empty body");
        } else {
            SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, trigger.getBody());
        }
    }

    private void appendSetTriggerOrder(StringBuffer buffer, TriggerSqlServerv2k trigger, boolean prettyPrint) {
        if (!trigger.getExecutionOrder().equalsIgnoreCase(TriggerSqlServer.EXECUTION_ORDERS[0])) {
            Iterator it = trigger.getActionSet().iterator();
            while (it.hasNext()) {
                SSBTriggerSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, "sp_settriggerorder");
                SSBTriggerSqlServerv2k.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k.appendString(buffer, trigger.getName());
                SSBTriggerSqlServerv2k.appendString(buffer, '\'');
                this.appendComma(buffer);
                SSBTriggerSqlServerv2k.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k.appendString(buffer, trigger.getExecutionOrder());
                SSBTriggerSqlServerv2k.appendString(buffer, '\'');
                this.appendComma(buffer);
                SSBTriggerSqlServerv2k.appendString(buffer, '\'');
                this.appendString(buffer, it.next());
                SSBTriggerSqlServerv2k.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBTriggerSqlServerv2k.appendStringWithSpace(buffer, "GO");
                SSBTriggerSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TriggerSqlServerv2k && ((TriggerSqlServerv2k)object).isMarkedGenerate() && (((TriggerSqlServer)object).getTable() != null || ((TriggerSqlServer)object).getView() != null);
    }
}

