/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.FKProxyOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBFKOraclev9i
extends AbstractSSBOracle {
    private StorageDesignOracle storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        FKProxyOraclev9i fkproxy;
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        if (object instanceof FKIndexAssociation) {
            FKIndexAssociation fk = (FKIndexAssociation)object;
            RelationalDesign rd = (RelationalDesign)fk.getDesignPart();
            this.storageDesign = (StorageDesignOracle)this.getStorageDesign();
            fkproxy = (FKProxyOraclev9i)this.storageDesign.getFKProxySet().getProxy(fk.getObjectID());
            if (fkproxy == null && (fkproxy = (FKProxyOraclev9i)this.storageDesign.getFKProxySet().getProxy(fk.getLocalFKIndex().getObjectID())) == null) {
                return;
            }
        } else {
            fkproxy = (FKProxyOraclev9i)object;
            this.storageDesign = (StorageDesignOracle)fkproxy.getStorageDesign();
        }
        if (fkproxy.getIndex().getElements().length > 0) {
            this.appendComment(oldbuffer, fkproxy);
            TableProxyOracle tableProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(fkproxy.getTable().getObjectID());
            this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
            String fkName = fkproxy.getName();
            if (fkName.length() > tableProxy.getMaxNameLength()) {
                SSBFKOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBFKOraclev9i.appendStringWithSpace(oldbuffer, "--  ERROR: FK name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                SSBFKOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                DDLFileMaker.incrementErrors();
            }
            SSBFKOraclev9i.appendStringWithSpace(buffer, "ALTER");
            SSBFKOraclev9i.appendStringWithSpace(buffer, "TABLE");
            SSBFKOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
            advancedComment = buffer.toString();
            SSBFKOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev9i.appendStringWithSpace(buffer, "ADD");
            if (!fkName.startsWith("SYS_")) {
                SSBFKOraclev9i.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBFKOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkproxy));
            }
            SSBFKOraclev9i.appendStringWithSpace(buffer, "FOREIGN KEY");
            SSBFKOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev9i.appendStringWithSpace(buffer, '(');
            SSBFKOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBFKOraclev9i.appendString(buffer, fkproxy.getColumns(this.storageDesign));
            SSBFKOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev9i.appendStringWithSpace(buffer, ')');
            this.appendReferences(buffer, fkproxy, prettyPrint);
            this.appendOnDelete(buffer, fkproxy, prettyPrint);
            this.appendConstraintState(buffer, fkproxy, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBFKOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBFKOraclev9i.appendLineFinisher(buffer, prettyPrint);
            SSBFKOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementAlterTable();
            if ((fkproxy.getRely().equals("YES") || this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) && fkproxy.getValidate().equals("NO")) {
                SSBFKOraclev9i.appendStringWithSpace(buffer, "ALTER");
                SSBFKOraclev9i.appendStringWithSpace(buffer, "TABLE");
                SSBFKOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                SSBFKOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBFKOraclev9i.appendStringWithSpace(buffer, "MODIFY");
                SSBFKOraclev9i.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBFKOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkproxy));
                advancedComment = buffer.toString();
                if (fkproxy.getRely().equals("YES")) {
                    SSBFKOraclev9i.appendStringWithSpace(buffer, "RELY");
                } else {
                    SSBFKOraclev9i.appendStringWithSpace(buffer, "NORELY");
                }
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBFKOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBFKOraclev9i.appendLineFinisher(buffer, prettyPrint);
                SSBFKOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                DDLFileMaker.incrementAlterTable();
            }
            this.appendExceptionTable(oldbuffer, fkproxy, prettyPrint);
            this.appendAfterAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
        } else {
            SSBFKOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            oldbuffer.append("-- Error - Foreign Key ");
            oldbuffer.append(this.storageDesign.getFormatedName(fkproxy));
            oldbuffer.append(" has no columns");
            SSBFKOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendExceptionTable(StringBuffer oldbuffer, FKProxyOraclev9i fk, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        if (fk.getExceptionsTable() != null && "YES".equalsIgnoreCase(fk.getEnable())) {
            SSBFKOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBFKOraclev9i.appendStringWithSpace(buffer, "ALTER");
            SSBFKOraclev9i.appendStringWithSpace(buffer, "TABLE");
            SSBFKOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(fk.getTableProxy()));
            advancedComment = buffer.toString();
            SSBFKOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev9i.appendStringWithSpace(buffer, "MODIFY");
            SSBFKOraclev9i.appendStringWithSpace(buffer, "CONSTRAINT");
            SSBFKOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk));
            SSBFKOraclev9i.appendStringWithSpace(buffer, "ENABLE EXCEPTIONS INTO");
            SSBFKOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(fk.getExceptionsTable()));
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBFKOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBFKOraclev9i.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementAlterTable();
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof FKProxyOraclev9i) {
            if (!((FKProxyOraclev9i)object).getStorageDesign().isOpen()) {
                return ((FKProxyOraclev9i)object).getObject().isMarkedGenerate();
            }
            return ((FKProxyOraclev9i)object).isMarkedGenerate();
        }
        if (object instanceof FKIndexAssociation) {
            return ((FKIndexAssociation)object).isMarkedGenerate();
        }
        return false;
    }

    private void appendReferences(StringBuffer buffer, FKProxyOraclev9i fk, boolean prettyPrint) {
        SSBFKOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        FKContainer refTable = fk.getFKTable();
        if (refTable != null) {
            SSBFKOraclev9i.appendStringWithSpace(buffer, "REFERENCES");
            ModelIDObject refTableObject = this.storageDesign.getTableProxySet().getProxy(refTable.getObjectID());
            if (refTableObject == null) {
                refTableObject = refTable;
            }
            SSBFKOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(refTableObject));
            boolean refStructType = false;
            if (fk.getFKTable().isBST()) {
                ColumnProxy[] columnProxies = fk.getColumnProxies();
                for (int i = 0; i < columnProxies.length; ++i) {
                    Column column = columnProxies[i].getColumn();
                    if (!column.isReference() || column.getUse() != 3) continue;
                    refStructType = true;
                }
            }
            if (!refStructType) {
                SSBFKOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBFKOraclev9i.appendStringWithSpace(buffer, '(');
                SSBFKOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBFKOraclev9i.appendString(buffer, fk.getReferenceColumns(this.storageDesign));
                SSBFKOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBFKOraclev9i.appendStringWithSpace(buffer, ')');
            }
        } else {
            FKIndexAssociation fkIndexAssociation = fk.getIndex().getFKAssociation();
            String formattedTableLongName = fkIndexAssociation.getFormattedReferredTableLongName();
            if (!formattedTableLongName.isEmpty()) {
                SSBFKOraclev9i.appendStringWithSpace(buffer, "REFERENCES");
                SSBFKOraclev9i.appendStringWithSpace(buffer, formattedTableLongName);
                SSBFKOraclev9i.appendStringWithSpace(buffer, '(');
                SSBFKOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(fkIndexAssociation.getReferredColumnNames()));
                SSBFKOraclev9i.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendOnDelete(StringBuffer buffer, FKProxyOraclev9i fk, boolean prettyPrint) {
        FKIndexAssociation fkass = ((Index)fk.getObject()).getFKAssociation();
        String onDelete = fkass.getDeleteRule();
        if (onDelete.equalsIgnoreCase("SET DEFAULT")) {
            onDelete = fkass.isMandatory() ? "RESTRICT" : "SET NULL";
        }
        if (!onDelete.equalsIgnoreCase("RESTRICT") && !onDelete.equalsIgnoreCase("NO ACTION")) {
            SSBFKOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev9i.appendStringWithSpace(buffer, "ON");
            SSBFKOraclev9i.appendStringWithSpace(buffer, "DELETE");
            SSBFKOraclev9i.appendStringWithSpace(buffer, onDelete);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            // empty if block
        }
    }

    private void appendConstraintState(StringBuffer buffer, FKProxyOraclev9i fk, boolean prettyPrint) {
        if (this.storageDesign.isOpen()) {
            SSBFKOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            if ("NO".equalsIgnoreCase(fk.getDeferrable())) {
                SSBFKOraclev9i.appendStringWithSpace(buffer, "NOT");
                SSBFKOraclev9i.appendStringWithSpace(buffer, "DEFERRABLE");
            } else {
                SSBFKOraclev9i.appendStringWithSpace(buffer, "DEFERRABLE");
                if ("DEFERRED".equalsIgnoreCase(fk.getInitially())) {
                    SSBFKOraclev9i.appendStringWithSpace(buffer, "INITIALLY");
                    SSBFKOraclev9i.appendStringWithSpace(buffer, "DEFERRED");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBFKOraclev9i.appendStringWithSpace(buffer, "INITIALLY");
                    SSBFKOraclev9i.appendStringWithSpace(buffer, "IMMEDIATE");
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if ("YES".equalsIgnoreCase(fk.getEnable())) {
                    SSBFKOraclev9i.appendStringWithSpace(buffer, "ENABLE");
                } else {
                    SSBFKOraclev9i.appendStringWithSpace(buffer, "DISABLE");
                }
                if ("YES".equalsIgnoreCase(fk.getValidate())) {
                    SSBFKOraclev9i.appendStringWithSpace(buffer, "VALIDATE");
                } else {
                    SSBFKOraclev9i.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            } else {
                if (!"YES".equalsIgnoreCase(fk.getEnable())) {
                    SSBFKOraclev9i.appendStringWithSpace(buffer, "DISABLE");
                    if ("YES".equalsIgnoreCase(fk.getValidate())) {
                        SSBFKOraclev9i.appendStringWithSpace(buffer, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(fk.getValidate())) {
                    SSBFKOraclev9i.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            }
            if (fk.getExceptionsTable() != null) {
                SSBFKOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                buffer.append("EXCEPTIONS INTO ").append(this.storageDesign.getFormatedLongNameDDL(fk.getExceptionsTable()));
            }
        }
    }
}

