/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v11g;

import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBIndexOraclev10g;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;

public class SSBIndexOraclev11g
extends SSBIndexOraclev10g {
    @Override
    protected void appendIndexSubPartitions(StringBuffer buffer, IndexProxyOracle indexProxy, PartitionListOraclev10g partitionList, AbstractStorageObjectOracle partition, String tablespaceIDs, boolean prettyPrint) {
        String subPartType = partitionList.getSubpartitionType();
        if (subPartType.equalsIgnoreCase("HASH")) {
            StorageObjectCollection subpartitions = null;
            if (partition instanceof PartitionOraclev11g) {
                subpartitions = ((PartitionOraclev11g)partition).getPartitions();
            } else if (partition instanceof ListPartitionOraclev11g) {
                subpartitions = ((ListPartitionOraclev11g)partition).getHashSubpartitions();
            }
            if (subpartitions != null && !this.appendHashSubPartitions(buffer, indexProxy, subpartitions, prettyPrint) && !"".equalsIgnoreCase(tablespaceIDs.trim())) {
                SSBIndexOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                SSBIndexOraclev11g.appendStringWithSpace(buffer, '(');
                SSBIndexOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(tablespaceIDs));
                SSBIndexOraclev11g.appendStringWithSpace(buffer, ')');
            }
        } else if (subPartType.equalsIgnoreCase("LIST")) {
            if (partition instanceof PartitionOraclev11g) {
                this.appendListSubPartitions(buffer, indexProxy, ((PartitionOraclev11g)partition).getListPartitions(), prettyPrint);
            } else if (partition instanceof ListPartitionOraclev11g) {
                this.appendListSubPartitions(buffer, indexProxy, ((ListPartitionOraclev11g)partition).getListSubpartitions(), prettyPrint);
            }
        } else if (subPartType.equalsIgnoreCase("RANGE")) {
            if (partition instanceof PartitionOraclev11g) {
                this.appendRangeSubPartitions(buffer, indexProxy, ((PartitionOraclev11g)partition).getRangeSubpartitions(), prettyPrint);
            } else if (partition instanceof ListPartitionOraclev11g) {
                this.appendRangeSubPartitions(buffer, indexProxy, ((ListPartitionOraclev11g)partition).getRangeSubpartitions(), prettyPrint);
            }
        }
    }

    private void appendRangeSubPartitions(StringBuffer buffer, IndexProxyOracle indexProxy, StorageObjectCollection subpartitions, boolean prettyPrint) {
        boolean first = true;
        for (PartitionOraclev11g rangeSubpartition : subpartitions) {
            String lipPName;
            if (first) {
                SSBIndexOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev11g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                SSBIndexOraclev11g.appendStringWithSpace(buffer, ',');
            }
            SSBIndexOraclev11g.appendNewLine(buffer, prettyPrint, 2);
            SSBIndexOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
            String spName = rangeSubpartition.getName();
            String formattedSpName = this.storageDesign.getFormatedName(rangeSubpartition);
            LocalIndexProperties lip = this.getPropsForIndex(indexProxy, rangeSubpartition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !spName.equals(lipPName)) {
                spName = lipPName;
                formattedSpName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!spName.toUpperCase().startsWith("SYS_")) {
                SSBIndexOraclev11g.appendStringWithSpace(buffer, formattedSpName);
            }
            if (lip == null) continue;
            TableSpaceOracle ts = lip.getTableSpace();
            if (ts != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                SSBIndexOraclev11g.appendNewLine(buffer, prettyPrint, 3);
                SSBIndexOraclev11g.appendStringWithSpace(buffer, "TABLESPACE");
                SSBIndexOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
            }
            if (indexProxy.getCompress() <= 0) continue;
            if ("YES".equalsIgnoreCase(lip.getKeyCompress())) {
                SSBIndexOraclev11g.appendNewLine(buffer, prettyPrint, 3);
                SSBIndexOraclev11g.appendStringWithSpace(buffer, "COMPRESS");
                continue;
            }
            if (!"NO".equalsIgnoreCase(lip.getKeyCompress())) continue;
            SSBIndexOraclev11g.appendNewLine(buffer, prettyPrint, 3);
            SSBIndexOraclev11g.appendStringWithSpace(buffer, "NOCOMPRESS");
        }
        if (!first) {
            SSBIndexOraclev11g.appendStringWithSpace(buffer, ')');
        }
    }
}

