/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DimensionOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDimensionOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    public void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        DimensionOraclev10g dimension = (DimensionOraclev10g)object;
        this.storageDesign = dimension.getStorageDesign();
        this.appendComment(buffer, dimension);
        if (dimension.getLevelSet().length > 0) {
            this.appendPrompt(buffer, dimension, "DIMENSION");
            this.appendCreate(buffer, dimension);
            advancedComment = buffer.toString();
            this.appendLevels(buffer, dimension, prettyPrint);
            this.appendHierarchies(buffer, dimension, prettyPrint);
            this.appendExtendedAttributes(buffer, dimension, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBDimensionOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBDimensionOraclev10g.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementCreateDimension();
        } else {
            SSBDimensionOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: Invalid Dimension without Levels: " + dimension.getName());
            SSBDimensionOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
        SSBDimensionOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
    }

    private void appendCreate(StringBuffer buffer, DimensionOraclev10g dimension) {
        String uname;
        this.appendCreate(buffer);
        SSBDimensionOraclev10g.appendStringWithSpace(buffer, "DIMENSION");
        if (dimension.getUser() != null && !"".equals(uname = dimension.getUser().getName()) && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBDimensionOraclev10g.appendString(buffer, this.storageDesign.getFormatedName(dimension.getUser()));
            SSBDimensionOraclev10g.appendString(buffer, '.');
        }
        SSBDimensionOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(dimension));
    }

    private void appendLevels(StringBuffer buffer, DimensionOraclev10g dimension, boolean prettyPrint) {
        Object[] levels = dimension.getLevelSet();
        for (int i = 0; i < levels.length; ++i) {
            LevelOracle level = (LevelOracle)levels[i];
            SSBDimensionOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            if (level.getColumnSet().size() > 0) {
                SSBDimensionOraclev10g.appendStringWithSpace(buffer, "LEVEL");
                SSBDimensionOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(level));
                SSBDimensionOraclev10g.appendStringWithSpace(buffer, "IS");
                if (level.getColumnSet().size() > 1) {
                    SSBDimensionOraclev10g.appendStringWithSpace(buffer, '(');
                }
                for (int j = 0; j < level.getColumnSet().size(); ++j) {
                    ColumnProxyOracle column = (ColumnProxyOracle)dimension.getStorageDesignOracle().getColumnProxySet().getProxy((String)level.getColumnSet().elementAt(j));
                    if (column == null) continue;
                    if (j > 0) {
                        this.appendComma(buffer);
                    }
                    SSBDimensionOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(column.getTableProxy()) + "." + this.storageDesign.getFormatedName(column));
                }
                if (level.getColumnSet().size() <= 1) continue;
                SSBDimensionOraclev10g.appendStringWithSpace(buffer, ')');
                continue;
            }
            SSBDimensionOraclev10g.appendStringWithSpace(buffer, "--  ERROR: Invalid Level with no Columns: " + level.getName());
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendHierarchies(StringBuffer buffer, DimensionOraclev10g dimension, boolean prettyPrint) {
        Object[] hierarchies = dimension.getHierarchySet();
        for (int i = 0; i < hierarchies.length; ++i) {
            int j;
            HierarchyOracle h = (HierarchyOracle)hierarchies[i];
            if (h.getLevelSet().size() <= 0) continue;
            SSBDimensionOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBDimensionOraclev10g.appendStringWithSpace(buffer, "HIERARCHY");
            SSBDimensionOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(h));
            SSBDimensionOraclev10g.appendStringWithSpace(buffer, '(');
            for (j = 0; j < h.getLevelSet().size(); ++j) {
                LevelOracle level;
                if (j > 0) {
                    SSBDimensionOraclev10g.appendStringWithSpace(buffer, " CHILD OF ");
                }
                if ((level = (LevelOracle)dimension.getStorageDesignOracle().getLevelSet().getById((String)h.getLevelSet().get(j))) == null) continue;
                SSBDimensionOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBDimensionOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(level));
            }
            for (j = 0; j < h.getJoinSet().size(); ++j) {
                SSBDimensionOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                this.appendStringWithSpace(buffer, h.getJoinSet().elementAt(j));
            }
            SSBDimensionOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBDimensionOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendExtendedAttributes(StringBuffer buffer, DimensionOraclev10g dimension, boolean prettyPrint) {
        Object[] attributes = dimension.getAttributeSet();
        for (int i = 0; i < attributes.length; ++i) {
            DimensionAttributeOracle attr = (DimensionAttributeOracle)attributes[i];
            if (attr.getLevel() == null || attr.getColumnSet().size() <= 0) continue;
            SSBDimensionOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBDimensionOraclev10g.appendStringWithSpace(buffer, "ATTRIBUTE");
            if (!"".equals(attr.getName())) {
                SSBDimensionOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(attr));
                SSBDimensionOraclev10g.appendStringWithSpace(buffer, "LEVEL");
            }
            SSBDimensionOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(attr.getLevel()));
            SSBDimensionOraclev10g.appendStringWithSpace(buffer, "DETERMINES");
            for (int j = 0; j < attr.getColumnSet().size(); ++j) {
                ColumnProxyOracle column;
                if (attr.getColumnSet().size() > 1 && j == 0) {
                    SSBDimensionOraclev10g.appendStringWithSpace(buffer, '(');
                }
                if ((column = (ColumnProxyOracle)dimension.getStorageDesignOracle().getColumnProxySet().getProxy((String)attr.getColumnSet().elementAt(j))) == null) continue;
                if (j > 0) {
                    this.appendComma(buffer);
                }
                SSBDimensionOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBDimensionOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(column));
            }
            if (attr.getColumnSet().size() <= 1) continue;
            SSBDimensionOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBDimensionOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DimensionOraclev10g && ((DimensionOraclev10g)object).isMarkedGenerate();
    }
}

