/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.BitmapJoinIndexOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBCreateBitmapJoinIndexOraclev10g
extends AbstractSSBOracle {
    private StorageDesignOraclev10g storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        BitmapJoinIndexOraclev10g index = (BitmapJoinIndexOraclev10g)object;
        if (index.getTable() != null) {
            StringBuffer buffer = new StringBuffer();
            String advancedComment = "";
            this.appendPrompt(buffer, index, "BITMAP INDEX");
            this.storageDesign = (StorageDesignOraclev10g)index.getStorageDesign();
            this.appendComment(oldbuffer, index);
            this.appendCreateBitmapJoinIndex(buffer, index);
            advancedComment = buffer.toString();
            this.appendIndexColumns(buffer, index, prettyPrint);
            this.appendFrom(buffer, index, prettyPrint);
            this.appendWhere(buffer, index, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBCreateBitmapJoinIndexOraclev10g.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementCreateIndex();
        }
    }

    private void appendCreateBitmapJoinIndex(StringBuffer buffer, BitmapJoinIndexOraclev10g index) {
        this.appendCreate(buffer);
        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "BITMAP");
        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "INDEX");
        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(index));
    }

    private void appendIndexColumns(StringBuffer buffer, BitmapJoinIndexOraclev10g index, boolean prettyPrint) {
        SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "ON");
        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(index.getTable()));
        SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, '(');
        SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        Object[] cols = index.getIndexColumnSet().toArray();
        for (int i = 0; i < cols.length; ++i) {
            TableProxyOracle tableProxy;
            if (i > 0) {
                this.appendComma(buffer);
                SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            }
            String colID = (String)cols[i];
            ++i;
            ColumnProxyOracle column = (ColumnProxyOracle)index.getStorageDesign().getColumnProxySet().getProxy(colID);
            if (column == null || (tableProxy = column.getTableProxy()) == null) continue;
            String sortOrder = "ASC";
            if (i < cols.length) {
                sortOrder = (String)cols[i];
            }
            SSBCreateBitmapJoinIndexOraclev10g.appendString(buffer, ' ');
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy) + "." + this.storageDesign.getFormatedName(column));
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, sortOrder);
        }
        SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, ')');
    }

    private void appendFrom(StringBuffer buffer, BitmapJoinIndexOraclev10g index, boolean prettyPrint) {
        SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "FROM");
        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(index.getTable()));
        for (int i = 0; i < index.getDimensionTables().length; ++i) {
            TableProxyOracle table = (TableProxyOracle)index.getStorageDesign().getTableProxySet().getProxy((String)index.getDimensionTables()[i]);
            if (table == null) continue;
            this.appendComma(buffer);
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(table));
        }
    }

    private void appendWhere(StringBuffer buffer, BitmapJoinIndexOraclev10g index, boolean prettyPrint) {
        SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "WHERE");
        Object[] cols = index.getJoinColumnSet().toArray();
        for (int i = 0; i < cols.length - 1; ++i) {
            if (i > 0) {
                SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "AND");
            }
            String dimensionCol = (String)cols[i];
            String baseCol = (String)cols[++i];
            ColumnProxyOracle dimColumn = (ColumnProxyOracle)index.getStorageDesign().getColumnProxySet().getProxy(dimensionCol);
            ColumnProxyOracle baseColumn = (ColumnProxyOracle)index.getStorageDesign().getColumnProxySet().getProxy(baseCol);
            if (dimColumn == null || baseColumn == null) continue;
            TableProxyOracle dimTable = dimColumn.getTableProxy();
            TableProxyOracle baseTable = baseColumn.getTableProxy();
            if (dimTable == null || baseTable == null) continue;
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(dimTable) + "." + this.storageDesign.getFormatedName(dimColumn));
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "=");
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(baseTable) + "." + this.storageDesign.getFormatedName(baseColumn));
        }
        if ("YES".equalsIgnoreCase(index.getLocalPartitioning()) && index.getTable().getPartitioned().equalsIgnoreCase("YES")) {
            SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "LOCAL");
            this.appendPartitionList(buffer, index, index.getTable(), prettyPrint);
        }
        this.appendIndexAttributes(buffer, index, prettyPrint);
    }

    private void appendPartitionList(StringBuffer buffer, BitmapJoinIndexOraclev10g indexProxy, TableProxyOracle tableProxy, boolean prettyPrint) {
        PartitionListOraclev10g partitionList = (PartitionListOraclev10g)tableProxy.getPartitionList();
        if (partitionList != null) {
            String subPartitionTableSpaceIDs;
            String partitionType = partitionList.getPartitionType();
            String subpartitionType = partitionList.getSubpartitionType();
            if (("HASH BY QUANTITY".equalsIgnoreCase(partitionType) || "HASH".equalsIgnoreCase(subpartitionType)) && !"".equals(subPartitionTableSpaceIDs = indexProxy.getHashSubPartitionsTableSpaces())) {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, '(');
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(subPartitionTableSpaceIDs));
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, ')');
            }
            if ("RANGE".equalsIgnoreCase(partitionType) || "COMPOSITE BY HASH".equalsIgnoreCase(partitionType) || "COMPOSITE BY LIST".equalsIgnoreCase(partitionType)) {
                boolean composite = !subpartitionType.equals("");
                this.appendPartitions(buffer, indexProxy, partitionList, composite, prettyPrint);
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partitionType)) {
                this.appendHashPartitions(buffer, partitionList, indexProxy, prettyPrint);
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                this.appendListPartitions(buffer, partitionList, indexProxy, prettyPrint);
            }
        }
    }

    private void appendSegment(StringBuffer buffer, SegmentOracle segment, boolean prettyPrint) {
        if (segment != null && segment.isMarkedGenerate() && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "PCTFREE");
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, segment.getPCTFree());
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                if (segment.getInitrans() > 2) {
                    SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                    SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, segment.getInitrans());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                    SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "2");
                }
                if (!(this.storageDesign instanceof StorageDesignOraclev11g)) {
                    if (segment.getMaxTrans() > 2) {
                        SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "MAXTRANS");
                        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, segment.getMaxTrans());
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "MAXTRANS");
                        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "255");
                    }
                }
            }
            SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "STORAGE");
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, '(');
            SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            boolean props = false;
            if (segment.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (segment.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "NEXT");
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCNextExtent());
                SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "PCTINCREASE");
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCMinExtents());
                SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "FREELISTS");
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCFreeLists());
                SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "FREELIST");
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "GROUPS");
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "BUFFER_POOL");
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCBufferPool());
                props = true;
            }
            if (props) {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, ')');
            } else {
                buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
            }
        }
    }

    private void appendIndexAttributes(StringBuffer buffer, BitmapJoinIndexOraclev10g indexProxy, boolean prettyPrint) {
        String tablespace = indexProxy.getTablespace();
        if (tablespace != null && !tablespace.equals("") && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            if ("DEFAULT".equalsIgnoreCase(tablespace)) {
                if ("YES".equalsIgnoreCase(indexProxy.getLocalPartitioning())) {
                    SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
                }
            } else {
                SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tablespace));
            }
        }
        this.appendSegment(buffer, indexProxy.getSegment(), prettyPrint);
        if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
            if ("YES".equalsIgnoreCase(indexProxy.getLogging())) {
                SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "LOGGING");
            } else if ("NO".equalsIgnoreCase(indexProxy.getLogging())) {
                SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
            }
        }
        if ("YES".equalsIgnoreCase(indexProxy.getOnline())) {
            SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "ONLINE");
        }
        if ("YES".equalsIgnoreCase(indexProxy.getComputeStatistics())) {
            SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
        }
        SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        if (indexProxy.getCompress() > 0) {
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, indexProxy.getCompress());
        } else {
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
        }
        SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        if ("YES".equalsIgnoreCase(indexProxy.getParallel())) {
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "PARALLEL");
            if (!"".equalsIgnoreCase(indexProxy.getDegree())) {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, indexProxy.getDegree());
            }
        } else {
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "NOPARALLEL");
        }
    }

    private void appendListPartitions(StringBuffer buffer, PartitionListOraclev10g partitionList, BitmapJoinIndexOraclev10g index, boolean prettyPrint) {
        TableProxyOracle tableProxy = index.getTable();
        StorageObjectCollection partitions = tableProxy.getPartitions();
        Iterator it = partitions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            String lipPName;
            ListPartitionOraclev10g partition = (ListPartitionOraclev10g)it.next();
            if (first) {
                buffer.append(NEWLINE).append("    ");
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, ',');
            }
            SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex(index, partition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !pName.equals(lipPName)) {
                pName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!pName.toUpperCase().startsWith("SYS_")) {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip != null) {
                TableSpaceOraclev10g ts = (TableSpaceOraclev10g)lip.getTableSpace();
                String logging = lip.getLogging();
                SegmentOraclev10g indexSegment = (SegmentOraclev10g)lip.getSegment();
                if (indexSegment != null) {
                    this.appendSegment(buffer, indexSegment, prettyPrint);
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                    if (ts != null) {
                        SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
                    } else if (indexSegment != null && indexSegment.getTableSpace() != null) {
                        SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexSegment.getTableSpace()));
                    }
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                    if ("YES".equalsIgnoreCase(logging)) {
                        SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                    } else if ("NO".equalsIgnoreCase(logging)) {
                        SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                    }
                }
            }
            if (partitionList.getSubpartitionType().equals("")) continue;
            String tablespaceIDs = "";
            if (lip != null) {
                tablespaceIDs = lip.getHashSubPartitionsTableSpaces();
            }
            this.appendIndexSubPartitions(buffer, index, partitionList, partition, tablespaceIDs, prettyPrint);
        }
        if (!first) {
            buffer.append(NEWLINE).append("    ");
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendHashPartitions(StringBuffer buffer, PartitionListOraclev10g partitionList, BitmapJoinIndexOraclev10g index, boolean prettyPrint) {
        TableProxyOracle tableProxy = index.getTable();
        StorageObjectCollection partitions = tableProxy.getPartitions();
        Iterator it = partitions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            TableSpaceOraclev10g ts;
            String lipPName;
            HashPartitionOraclev10g partition = (HashPartitionOraclev10g)it.next();
            if (first) {
                buffer.append(NEWLINE).append("    ");
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, ',');
            }
            SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex(index, partition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !pName.equals(lipPName)) {
                pName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!pName.toUpperCase().startsWith("SYS_")) {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null || (ts = (TableSpaceOraclev10g)lip.getTableSpace()) == null || !this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) continue;
            SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
        }
        if (!first) {
            buffer.append(NEWLINE).append("    ");
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendPartitions(StringBuffer buffer, BitmapJoinIndexOraclev10g index, PartitionListOraclev10g partitionList, boolean composite, boolean prettyPrint) {
        TableProxyOracle tableProxy = index.getTable();
        StorageObjectCollection partitions = tableProxy.getPartitions();
        Iterator it = partitions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            String lipPName;
            PartitionOraclev10g partition = (PartitionOraclev10g)it.next();
            if (first) {
                SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                buffer.append(',');
            }
            SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex(index, partition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !pName.equals(lipPName)) {
                pName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!pName.toUpperCase().startsWith("SYS_")) {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip != null) {
                SegmentOraclev10g indexSegment = (SegmentOraclev10g)lip.getSegment();
                if (indexSegment != null) {
                    this.appendSegment(buffer, indexSegment, prettyPrint);
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                    TableSpaceOraclev10g ts = (TableSpaceOraclev10g)lip.getTableSpace();
                    if (ts != null) {
                        SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
                    } else if (indexSegment != null && indexSegment.getTableSpace() != null) {
                        SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexSegment.getTableSpace()));
                    }
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                    String logging = lip.getLogging();
                    if ("YES".equalsIgnoreCase(logging)) {
                        SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                    } else if ("NO".equalsIgnoreCase(logging)) {
                        SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                    }
                }
            }
            if (!composite) continue;
            String tablespaceIDs = "";
            if (lip != null) {
                tablespaceIDs = lip.getHashSubPartitionsTableSpaces();
            }
            this.appendIndexSubPartitions(buffer, index, partitionList, partition, tablespaceIDs, prettyPrint);
        }
        if (!first) {
            buffer.append(NEWLINE).append("    ").append(')');
        }
    }

    private LocalIndexProperties getPropsForIndex(BitmapJoinIndexOraclev10g index, StorageObject partition) {
        return this.storageDesign.getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(partition, index);
    }

    private void appendIndexSubPartitions(StringBuffer buffer, BitmapJoinIndexOraclev10g index, PartitionListOraclev10g partitionList, AbstractStorageObjectOracle partition, String tablespaceIDs, boolean prettyPrint) {
        String subPartType = partitionList.getSubpartitionType();
        if (subPartType.equalsIgnoreCase("HASH")) {
            StorageObjectCollection subpartitions = null;
            if (partition instanceof PartitionOraclev10g) {
                subpartitions = ((PartitionOraclev10g)partition).getPartitions();
            } else if (partition instanceof ListPartitionOraclev11g) {
                subpartitions = ((ListPartitionOraclev11g)partition).getHashSubpartitions();
            }
            if (subpartitions != null && !this.appendHashSubPartitions(buffer, index, subpartitions, prettyPrint) && !"".equalsIgnoreCase(tablespaceIDs.trim())) {
                SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, '(');
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(tablespaceIDs));
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, ')');
            }
        } else if (subPartType.equalsIgnoreCase("LIST")) {
            if (partition instanceof PartitionOraclev10g) {
                this.appendListSubPartitions(buffer, index, ((PartitionOraclev10g)partition).getListPartitions());
            } else if (partition instanceof ListPartitionOraclev11g) {
                this.appendListSubPartitions(buffer, index, ((ListPartitionOraclev11g)partition).getListSubpartitions());
            }
        } else if (subPartType.equalsIgnoreCase("RANGE")) {
            if (partition instanceof PartitionOraclev11g) {
                this.appendRangeSubPartitions(buffer, index, ((PartitionOraclev11g)partition).getRangeSubpartitions(), prettyPrint);
            } else if (partition instanceof ListPartitionOraclev11g) {
                this.appendRangeSubPartitions(buffer, index, ((ListPartitionOraclev11g)partition).getRangeSubpartitions(), prettyPrint);
            }
        }
    }

    private void appendListSubPartitions(StringBuffer buffer, BitmapJoinIndexOraclev10g index, StorageObjectCollection subpartitions) {
        boolean first = true;
        for (ListStorageTemplatePartitionOraclev10g listPartition : subpartitions) {
            TableSpaceOracle ts;
            String lipPName;
            if (first) {
                buffer.append(NEWLINE).append("    ");
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, ',');
            }
            buffer.append(NEWLINE).append("    ");
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
            String lpName = listPartition.getName();
            String formattedPName = this.storageDesign.getFormatedName(listPartition);
            LocalIndexProperties lip = this.getPropsForIndex(index, listPartition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !lpName.equals(lipPName)) {
                lpName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!lpName.toUpperCase().startsWith("SYS_")) {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null || (ts = lip.getTableSpace()) == null || !this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) continue;
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
        }
        if (!first) {
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private boolean appendHashSubPartitions(StringBuffer buffer, BitmapJoinIndexOraclev10g index, StorageObjectCollection subpartitions, boolean prettyPrint) {
        boolean result = false;
        boolean first = true;
        for (HashPartitionOraclev10g hashPartition : subpartitions) {
            TableSpaceOraclev10g ts;
            String lipPName;
            if (first) {
                SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
                result = true;
            } else {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, ',');
            }
            SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
            String hpName = hashPartition.getName();
            String formattedPName = this.storageDesign.getFormatedName(hashPartition);
            LocalIndexProperties lip = this.getPropsForIndex(index, hashPartition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !hpName.equals(lipPName)) {
                hpName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!hpName.toUpperCase().startsWith("SYS_")) {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null || (ts = (TableSpaceOraclev10g)lip.getTableSpace()) == null || !this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) continue;
            SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
        }
        if (!first) {
            SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            buffer.append(')');
        }
        return result;
    }

    private void appendRangeSubPartitions(StringBuffer buffer, BitmapJoinIndexOraclev10g index, StorageObjectCollection subpartitions, boolean prettyPrint) {
        boolean first = true;
        for (PartitionOraclev11g rangeSubpartition : subpartitions) {
            TableSpaceOracle ts;
            String lipPName;
            if (first) {
                SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, ',');
            }
            SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
            String spName = rangeSubpartition.getName();
            String formattedSpName = this.storageDesign.getFormatedName(rangeSubpartition);
            LocalIndexProperties lip = this.getPropsForIndex(index, rangeSubpartition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !spName.equals(lipPName)) {
                spName = lipPName;
                formattedSpName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!spName.toUpperCase().startsWith("SYS_")) {
                SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, formattedSpName);
            }
            if (lip == null || (ts = lip.getTableSpace()) == null || !this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) continue;
            SSBCreateBitmapJoinIndexOraclev10g.appendNewLine(buffer, prettyPrint, 3);
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
        }
        if (!first) {
            SSBCreateBitmapJoinIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof BitmapJoinIndexOraclev10g && ((BitmapJoinIndexOraclev10g)object).isMarkedGenerate();
    }

    public void doAppendBJIndex(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        this.doAppend(oldbuffer, object, prettyPrint);
    }
}

