/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ClusterIndexOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBClusterIndexOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        ClusterIndexOraclev10g clusterIndex = (ClusterIndexOraclev10g)object;
        this.storageDesign = clusterIndex.getStorageDesign();
        this.appendPrompt(buffer, clusterIndex, "INDEX");
        this.appendComment(oldbuffer, clusterIndex);
        SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "CREATE");
        SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "INDEX");
        SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(clusterIndex));
        advancedComment = buffer.toString();
        this.appendCluster(buffer, clusterIndex, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        SSBClusterIndexOraclev10g.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        DDLFileMaker.incrementCreateIndex();
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof ClusterIndexOraclev10g) {
            ClusterOracle cluster = ((ClusterIndexOraclev10g)object).getCluster();
            return cluster != null && cluster.isMarkedGenerate();
        }
        return false;
    }

    private void appendCluster(StringBuffer buffer, ClusterIndexOraclev10g clusterIndex, boolean prettyPrint) {
        if (clusterIndex.getCluster() != null) {
            SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "ON");
            SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "CLUSTER");
            SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(clusterIndex.getCluster()));
            this.appendIndexAttributes(buffer, clusterIndex, prettyPrint);
        }
    }

    private void appendIndexAttributes(StringBuffer buffer, ClusterIndexOraclev10g clusterIndex, boolean prettyPrint) {
        SegmentOracle segment;
        TableSpaceOracle tableSpace = clusterIndex.getTableSpace();
        if (tableSpace == null && (segment = clusterIndex.getSegment()) != null && segment.isMarkedGenerate()) {
            tableSpace = segment.getTableSpace();
        }
        if (tableSpace != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
            SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
        }
        this.appendSegment(buffer, clusterIndex.getSegment(), prettyPrint);
        if ("YES".equalsIgnoreCase(clusterIndex.getOnline())) {
            SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "ONLINE");
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
            if ("YES".equalsIgnoreCase(clusterIndex.getLogging())) {
                SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "LOGGING");
            } else if ("NO".equalsIgnoreCase(clusterIndex.getLogging())) {
                SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
            }
        }
        if ("YES".equalsIgnoreCase(clusterIndex.getComputeStatistics())) {
            SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
        }
        SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        if (clusterIndex.getCompress() > 0) {
            SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
            SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, clusterIndex.getCompress());
        } else {
            SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
        }
        if ("YES".equalsIgnoreCase(clusterIndex.getReverse())) {
            SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "SORT");
            }
            SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "REVERSE");
        }
        SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        if ("YES".equalsIgnoreCase(clusterIndex.getParallel())) {
            SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "PARALLEL");
            if (!"".equalsIgnoreCase(clusterIndex.getDegree())) {
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, clusterIndex.getDegree());
            }
        } else {
            SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "NOPARALLEL");
        }
    }

    private void appendSegment(StringBuffer buffer, SegmentOracle segment, boolean prettyPrint) {
        if (segment != null && segment.isMarkedGenerate() && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "PCTFREE");
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, segment.getPCTFree());
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                if (segment.getInitrans() > 2) {
                    SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                    SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, segment.getInitrans());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                    SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "2");
                }
            }
            SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "STORAGE");
            SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, '(');
            SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            boolean props = false;
            if (segment.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (segment.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "NEXT");
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCNextExtent());
                SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "PCTINCREASE");
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCMinExtents());
                SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "FREELISTS");
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCFreeLists());
                SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "FREELIST");
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "GROUPS");
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, "BUFFER_POOL");
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCBufferPool());
                SSBClusterIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                props = true;
            }
            if (props) {
                SSBClusterIndexOraclev10g.appendStringWithSpace(buffer, ')');
            } else {
                buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
            }
        }
    }
}

